<?php
/**
* @package vler
* @subpackage form-markup-generator
*/

/**
* require parent file
*/
require_library('form_markup_generator/field_markup_generators/field_group');
require_library('form_markup_generator/field_markup_generators/patient_disclosure');

/**
* @package vler
* @subpackage form-markup-generator
*/
class Patient_disclosures_markup_generator extends Field_group_markup_generator{
	protected $_type = 'patient_disclosures';
	protected $_field_templates = array('patient_1' => array('type' => 'patient_disclosure'));
	
	
	//since this field group allows additional fields to be added via js, we need to make sure they get added here
	protected function load_field_generators(){		
		//additional patients may have been added via js - that's okay, we'll add them to the field templates and validate their data the same way we do the rest
		if(!empty($_POST)){
			foreach(array_diff(array_keys($_POST[$this->name]), array_keys($this->_field_templates)) as $additional_patient){
				$this->_field_templates[$additional_patient] = $this->_field_templates['patient-1'];
			}
		}

		//make sure that patient rows will be referred to as Patient #N instead of patient_n
		foreach($this->_field_templates as $name => $template){
			$referral_label = humanize($name);
			$last_word = last_word($referral_label);
			if(is_numeric($last_word))
				$referral_label = substr_replace($referral_label, '#'.$last_word, strrpos($referral_label, $last_word));
			$this->_field_templates[$name]['referral_label'] = $referral_label;
		} 
		
		parent::load_field_generators();
    }


}