<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage libraries
*/ /** */

require_library('session/drivers/VLER_Session_files_driver'); 

/**
* Extension that exists solely so that DAAS can find the VLER extension, since the loader doesn't find session drivers.
*
* @package direct-as-a-service
* @subpackage libraries
*/ 
class DAAS_Session_files_driver extends VLER_Session_files_driver {
	
	//clear out file transfer content if the file transfer has expired
	public function gc($maxlifetime){
		parent::gc($maxlifetime);
		
		log_message('debug', 'Beginning api-specific session garbage collection');
		
		//note that this query will *not* show up in the profiler if you enable the profiler after the controller constructor has run (which includes post-controller hooks)
		require_model('file_transfer');
		File_transfer::clear_expired_content($include_slow_query = TRUE);  //note that you might not want to include the slow query when you're testing how long something takes
		
		log_message('debug', 'Completing api-specific session garbage collection');
	}  
}
