<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage libraries
*//** */
 

/**
* @package direct-as-a-service
* @subpackage libraries
*/
class Permissions {
    
        // Account Roles
        const ROLE_ACCOUNT_GROUP_MAINTENANCE = 'accountgroupmaintenance'; 
        
	private $CI;
	private $access_level;
	public function __construct() {
		$this->CI =& get_instance();
		$this->CI->load->model('applicationmodel');

		require_model('application');
		require_model('service_permission');
	}
	
	/*
	 * This function returns an array application IDs that the user has user permission to
	 * $access_level is either 'admins' or 'users'
	 */
	public function get_application_permission($id_or_permissions, $access_level){
		$permissions = $id_or_permissions;
		if(!is_array($id_or_permissions)){
			$user = User::find_one(array('user_org_id' => $id_or_permissions));
			if(!User::is_an_entity($user)) return false;
			$permissions = $user->permissions;
		}
                		
		$apps = array();
		foreach($permissions['Application'] as $application_id => $permission){
			if(array_key_exists($access_level, $permission) && $permission[$access_level])
				$apps[] = $application_id;
		}
		return $apps;
	}
	
	/* This function uses organizational id (for DOD this is EDIPI) to pull the user permissions,
	 * which return as an associative array split between 'API' and 'Application' permissions.
	 */
	public function get_user_permissions($id) {
		if(!empty($id) && !is_numeric($id)) return $this->error->should_be_an_org_id($id);
		$user = User::find_one(array('user_org_id' => $id));
		if(!User::is_an_entity($user)) return false;
 		return $user->permissions;
	}
	
	/* This function uses the permissions returned from get_user_permissions to set an associative array
	 * of the tabs that the user should be able to see for use in loading views.
	 */
	public function set_tab_access_from_permissions($permissions) {
                 //least amount of permissions
		$show = array('onboarding'=>true,'applications'=>false,'facilities' => false,'reports'=>false,'administration'=>false,'user_settings'=>false,'global_search'=>false, 'file_transfer' => false, 'message' => false,'acct_group_maint' => false);
		
		//if registered allow applications tab
		if(isset($permissions['Registered']) && $permissions['Registered']) {
			
			//admins get all of the tabs
			if(isset($permissions['API']) && $permissions['API']['admins']) { 
 				$show = array_combine(array_keys($show), array_fill(0, count($show), true));
                                $show['acct_group_maint'] = false; 
                                return $show;
                        }
			
                        // Enable User Admin Settings for Account Maintenance Role
                        if ($this->isAccountGroupMaintenanceOnly($permissions)) {
                           $show['user_settings'] = true; 
                           $show['administration'] = true;
                           $show['acct_group_maint'] = true; 
                           $show['manage_accounts'] = true;
                           $show['account_requests'] = true; 
                           $show['manage_groups'] = true;
                           $show['manage_groups_lead'] = true; 

                            
                         } else { 
                            //active registerd users get to see the applications, user settings, and the file transfer area
                            $show['applications'] = true;
                            $show['user_settings'] = true;
                            $show['file_transfer'] = true;
                            $show['message'] = true; //file transfer pickup area
                        }
		
			//TO-DO: for FOC, if application admin, allow administration tab
			if(isset($permissions['Application'])) {
				Application::db()->where_in('id', array_keys($permissions['Application']));
				$applications = Application::find();
				foreach($permissions['Application'] as $key => $value) {
					$application = element($key, $applications);
					if(Application::is_an_entity($application) && isset($value[LDAP_APPLICATION_ADMIN_GROUP_NAME]) && $value[LDAP_APPLICATION_ADMIN_GROUP_NAME]) {
						$show = array('onboarding'=>true,'applications'=>true,'facilities'=>false,'reports'=>false,'administration'=>false,'user_settings'=>true,'global_search'=>false);
					}
				}
			}
			
			if(isset($permissions['Permission'])){
				foreach($permissions['Permission'] as $key){
					$show[$key] = 1;
				}
			}
		}
		
		return $show;
	}
	
	/* This function uses the permissions returned from get_user_permissions to set an associative array
	 * of the admin views that the user should be able to see.
	 */
	public function set_admin_access_from_permissions($permissions) {
		//least amount of permissions
		$show = array('application_requests'=>false,'account_requests'=>false,'manage_accounts'=>false);
		//if application admin, allow manage users
		//TO-DO: For FOC, allow app admins to manage users for their app only
		if(isset($permissions['Application'])) {
			Application::db()->where_in('id', array_keys($permissions['Application']));
			$applications = Application::find();
			foreach($permissions['Application'] as $key => $value) {
				$application = element($key, $applications);
				if(Application::is_an_entity($application) && isset($value[LDAP_APPLICATION_ADMIN_GROUP_NAME]) && $value[LDAP_APPLICATION_ADMIN_GROUP_NAME]) {
					$show = array('application_requests'=>false,'account_requests'=>false,'manage_accounts'=>false,'manage_groups'=>false, 'manage_facilities'=>true);
				}
			}
		}
		//api admins get all functions
		if(isset($permissions['API']) && $permissions['API']['admins']) {
			$show = array('application_requests'=>true,'account_requests'=>true,'manage_accounts'=>true,'manage_groups'=>true, 'manage_facilities'=>true);
		}
                elseif($this->isAccountGroupMaintenanceOnly($permissions)) { 
                    $show['manage_accounts'] = true; 
                    $show['account_requests'] = true; 
                    $show['manage_groups'] = true; 
                }
		else{
			$show = array('application_requests'=>in_array('application_requests', $permissions['Permission']),'account_requests'=>in_array('account_requests', $permissions['Permission']),'manage_accounts'=>in_array('manage_accounts', $permissions['Permission']),'manage_groups'=>in_array('manage_groups', $permissions['Permission']));
		}
 		return $show;
	}
	
	/* This function returns the authorized API controllers for a given application (given by application id)
	 * by looking up the permissions in LDAP and returning an associative array of permissions.
	 */
	public function get_api_authorization($app_id) {
		$return_arr['direct'] = $this->CI->applicationmodel->get_direct_api_authorization($app_id);
		$return_arr['admin'] = $this->CI->applicationmodel->get_admin_api_authorization($app_id);
		$return_arr['disclosure'] = $this->CI->applicationmodel->get_disclosure_api_authorization($app_id);
		return $return_arr;
	}

	
	/* This function looks up the permissions a user has given an app, but uses their Direct address
	 * for the lookup.
	 */
	public function get_user_permissions_for_address($address,$app_id) {
		$mailbox = Mailbox::find_by_email_address($address);
		Service_permission::set_up_service_join();
		$service_permissions = $mailbox->service_permissions(array('application_id' => $app_id));
		
		$permissions = array();
		foreach($service_permissions as $permission){
			if($permission->authorized)
				$permissions[$permission->name] = TRUE;
		}
		
		return $permissions;
	}
        
        /**
         * Checks to see if use only has Account Group Maintenance Role
         * 
         * @param array $permissions
         * @return boolean
         */
        public function isAccountGroupMaintenanceOnly($permissions) 
        { 
            //if (true === in_array(self::ROLE_ACCOUNT_GROUP_MAINTENANCE, $permissions['Role'])) {
            if ( true === array_key_exists('Role', $permissions) ) { 
                if ( 1 === count($permissions['Role'])) { 
                    if (true === in_array(self::ROLE_ACCOUNT_GROUP_MAINTENANCE, $permissions['Role']) ) { 
                        return true; 
                    }
                }
            }
            return false; 
        }
	
}
