<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-as-a-service
* @subpackage libraries
*/

/**
* @package direct-as-a-service
* @subpackage libraries
*/
class DAAS_Template extends Template {
	public $show_navbar = true;
	public $active_nav;
	
	public $show_subnav = false;
	public $active_subnav;
	
	
	protected $nav_paths = array(   'onboarding' => 'onboarding',
									'applications' => 'applications/list',
									'reports' => 'reports',
									'administration' => 'administration', 
									'user_settings' => 'user_settings',
									'global_search' => 'global_search', 
									'file_transfer' => 'file_transfer/upload');
									
	protected $nav_dropdowns = array('administration' => array( 'Application Requests' => 'administration/application/requests',
																'Account Requests' => 'administration/account/requests',
																'Manage Accounts' => 'administration/manage/accounts',
																'Manage Groups' => 'administration/manage/groups',
																'Manage Facilities' => 'administration/manage/facilities' ));
																
																
	protected $subnav_paths = array('file_transfer' => array('upload',
															 'available_for_download',														 
															 'received_files',
															 'sent_files',
															 															 
															));																

	function __construct(){
		parent::__construct();
		if(!ENABLE_FILE_TRANSFERS)
			unset($this->nav_paths['file_transfer']);
		
	}	

							
	protected function active_nav(){
		if(isset($this->active_nav)){
			if(array_key_exists($this->active_nav, $this->nav_paths))
				return $this->active_nav;
			else
				$this->error->notice('There is no active tab named '.$this->error->describe($active_nav).'; reverting to default');
		}
		
		$active_nav = $this->CI->uri->segment(1);

		if(array_key_exists($active_nav, $this->nav_paths))
			return $active_nav; 
		return array_first_key($this->nav_paths);
	}
	
	protected function active_subnav(){
		if(isset($this->active_subnav)){
			if(array_key_exists($this->active_subnav, $this->subnav_paths))
				return $this->active_subnav;
			else
				$this->error->notice('There is no active tab named '.$this->error->describe($this->active_subnav).'; reverting to default');
		}
				
		$active_subnav = $this->CI->uri->segment(2);

		$subnav_paths = element($this->active_nav(), $this->subnav_paths, array());

		if(in_array($active_subnav, $subnav_paths))
			return $active_subnav; 
		return first_element($subnav_paths);
	}	
	
	protected function nav_dropdowns(){
		$subnav_items = $this->subnav_items();
		if(empty($subnav_items)) return $this->nav_dropdowns;
		$subnav_paths = array($this->active_nav() => array_combine(collect('link_text', $this->subnav_items()), collect('path', $this->subnav_items())));
		return array_merge($subnav_paths, $this->nav_dropdowns);
	}
	
	protected function nav_items(){
		$nav_items = array();
		$active_nav = $this->active_nav();
		$permissions = array();
		
		$user = User::find_from_session();
		if(User::is_an_entity($user) ){
			$permissions = $this->CI->permissions->set_tab_access_from_permissions($user->permissions);
		}
                
                if (isset($permissions['acct_group_maint']) && true == $permissions['acct_group_maint']) { 
                    unset($this->nav_dropdowns['file_transfer']);
                    unset($this->nav_dropdowns['administration']['Application Requests']);
                    unset($this->nav_dropdowns['administration']['Manage Facilities']);
                    
                    unset($this->nav_paths['file_transfer']);
                }
		foreach($this->nav_paths as $identifier => $path){
			if(is_numeric($identifier)) $identifier = $path;
			if(!isset($permissions[$identifier]) || !$permissions[$identifier]) continue;
			
			$is_active = ($identifier == $active_nav);
			$link_text = humanize($identifier);
			if($is_active)
				$link_text .= ' <span class="sr-only"> (current)</span>';
			$dropdown_items = element($identifier, $this->nav_dropdowns(), array());	
			
			$nav_items[$identifier] = compact('path', 'link_text', 'is_active', 'dropdown_items');
		}
		
		return $nav_items;
	} 
	
	protected function subnav_items(){
		$subnav_items = array();
		$active_nav = $this->active_nav();
		$active_subnav = $this->active_subnav();
		
		foreach(element($active_nav, $this->subnav_paths, array()) as $identifier => $path){
			if(is_numeric($identifier))	$identifier = $path;
			$path = $active_nav.'/'.$path;
			
			$is_active = ($identifier == $active_subnav);
			$link_text = humanize($identifier);
			if($is_active)
				$link_text .= ' <span class="sr-only"> (current)</span>';
			
			$subnav_items[$identifier] = compact('path', 'link_text', 'is_active', 'dropdown_items');
		}	
				
		return $subnav_items;	
	}
					
	public function template_data(){
		if($this->show_navbar){
			$this->_template_data['nav_items'] = $this->nav_items();
			$this->_template_data['active_nav'] = $this->active_nav();
		}
		
		if($this->show_subnav){
			$this->_template_data['subnav_items'] = $this->subnav_items();;
			$this->_template_data['active_subnav'] = $this->active_subnav();
		}
				
		return $this->_template_data;
	}				

}
