<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage helpers
*//** */

	function admin_url($path = '', $protocol = 'https://'){
		return url_for_domain(API_ADMINPANEL_DOMAIN, $path, $protocol);
	}

	function api_url($path = '', $protocol = 'https://'){
		return url_for_domain(API_DOMAIN, $path, $protocol);
	}
	
	function file_transfer_url($path = '', $protocol = 'https://'){
		return url_for_domain(API_FILETRANSFER_DOMAIN, $path, $protocol);
	}
	
	function url_for_domain($domain, $path, $protocol=null){
		$CI = get_instance();
		$site_base_url = $CI->config->slash_item('base_url');
		if(!isset($protocol)){ $protocol = '//'; }
		
		$base_url = $protocol.strip_from_end('/', $domain).'/';

		if (empty($path))
		{
			return $base_url.$CI->config->item('index_page');
		}

		if ($CI->config->item('enable_query_strings') === FALSE)
		{
			if (is_array($path))
			{
				$path = implode('/', $path);
			}
			$path = trim($path, '/');
		}
		elseif (is_array($path))
		{
			$path = http_build_query($path);
		}


		if ($CI->config->item('enable_query_strings') === FALSE)
		{
			$suffix = isset($CI->config->config['url_suffix']) ? $CI->config->config['url_suffix'] : '';

			if ($suffix !== '')
			{
				if (($offset = strpos($path, '?')) !== FALSE)
				{
					$path = substr($path, 0, $offset).$suffix.substr($path, $offset);
				}
				else
				{
					$path .= $suffix;
				}
			}

			return $base_url.$CI->config->slash_item('index_page').$path;
		}
		elseif (strpos($path, '?') === FALSE)
		{
			$path = '?'.$path;
		}

		return $base_url.$CI->config->item('index_page').$path;
	}

?>