<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */


// This can be removed if you use __autoload() in config.php OR use Modular Extensions
require_once APPPATH.'/libraries/DaaS_REST_Controller.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Direct extends DaaS_REST_Controller
{	

	/* VALIDATE (GET request only)
	 * This function validates whether the provided address or domain is trusted by the
	 * system.
	 */
	public function validate_get() {
		$this->load->helper('mail');
		$this->load->helper('validate');
				
		//if no address provided, return message that that field is required
		if(!$this->get('address')) { 
			$response_message['valid'] = false;
			$response_message['message'] = 'Must provide address field.';
			$this->response($response_message, 422); 
		}
		else { $address = base64_decode(rawurldecode($this->get('address'))); }

		//if no sender provided, assume that there is an organizational cert that any domain address will work for
		if(!$this->get('sender')) { 
			$sender = 'validitytest@'.CLINICAL_DOMAIN;
		}else{ 
			$sender = base64_decode(rawurldecode($this->get('sender'))); 
		}
		
		$address_arr = array();
		$to_arr = array();
		normalize_address($address, $to_arr, $address_arr);
		$message = validate($sender,$address_arr);
		
		if($message['valid_message']) { //if everything is valid, then return response	
			$response_message['valid'] = true;	
			$this->response($response_message, 200); 
		}else { //if something is invalid, then return response
			$response_message['valid'] = false;
			$response_message['message'] = $this->generate_invalid_recipients_message($message['invalid_addresses']);
			$this->response($response_message, 200); 
		}
	}
}