<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
* @package direct-as-a-service
* @subpackage controllers
*//** */
 
require_once APPPATH.'controllers/services/mailbox_controller.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
#class account_controller extends Mailbox_controller{ //note - CI's standard is to capitalize the first word in the class name, or the first word after the prefix (e.g. CI_Emails)
class Account_controller extends Mailbox_controller{
	
	public function update_account_post(){
		$required_fields = array('first_name','last_name','facility_id');
		$post = $this->post();
		foreach($required_fields as $required_field){
			if(array_key_exists($required_field, $post)){
				$$required_field = $this->post($required_field,TRUE);
			}
			else{
				array_push($this->missing_required_fields, $required_field);
			}
		}
		//if there is an error with the passed in fields create an error message
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_user_is_unauthorized('manage');
		$this->respond_with_error_if_mailbox_is_inactive();
		if($first_name === ""){
			$this->invalid_fields[] = 'first_name';
		}
		if($last_name === ""){
			$this->invalid_fields[] = 'last_name';
		}
		if($facility_id && !is_numeric($facility_id)){
			$this->invalid_fields[] = 'facility_id';
		}
		$user = User::find_one(array('username' => $this->mailbox->name));
		if(!User::is_an_entity($user)){
			$this->invalid_fields[] = 'mailbox';
		}
		$this->respond_with_error_if_fields_are_invalid();
		$optional = array('middle_name','job_title','department','organization','telephone','mobile','location','ext_mail');
		foreach ($optional as $option){
			if(array_key_exists($required_field, $post)){
				$$option = $this->post($option,TRUE);
			}
		}
		
		if(!isset($ext_mail)){
			$ext_mail = false;
		}
		$attributes = array();
		//add mandatory attrs to array
		$attributes["givenName"] = $first_name;
		$attributes["sn"] = $last_name;
		$attributes["cn"] = $first_name . " " . $last_name;
			
		//deal with optional attributes (middle name is a sepcial case, since we need to change displayName based on it too)
		if(!empty($middle_name)) { $attributes["initials"] = $middle_name; $attributes["displayName"] = $last_name . ", " . $first_name . " " . $middle_name; }
		else { $attributes["initials"] = ""; $attributes["displayName"] = $last_name . ", " . $first_name; }
		if(isset($job_title)) { $attributes["title"] = $job_title; }
		if(isset($department)) { $attributes["departmentnumber"] = $department; }
		if(isset($organization)) { $attributes["o"] = $organization; }
		if(isset($telephone)) { $attributes["telephonenumber"] = $telephone; }
		if(isset($mobile)) { $attributes["mobile"] = $mobile; }
		if(isset($location)) { $attributes["physicaldeliveryofficename"] = $location; }
		$result = $this->usersmodel->update_user($user->id,$ext_mail,$facility_id,$attributes);
		if($result){
			$this->response("User information updated", 200);
		}
		else{
			$this->response("User information failed to updated", 500);
		}
		
		
	}
	public function account_get(){
		$this->load->model('facilitymodel');
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_user_is_unauthorized('manage');
		
		$user = User::find_one(array('username' => $this->mailbox->name));
		if(!User::is_an_entity($user)){
			$this->invalid_fields[] = 'mailbox';
		}
		$this->respond_with_error_if_fields_are_invalid();
		
		$values = $user->values_for_api();
		$values['facilities'] = $this->facilitymodel->get_facilities(true)->result(); //todo - we shouldn't be including this here, this doesn't make sense
		
		$this->response($values, 200);
	}
	
	public function accounts_in_facility_get(){
		$this->load->model('facilitymodel');
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_user_is_unauthorized('manage');
		$user = User::find_one(array('username' => $this->mailbox->name));
		if(!User::is_an_entity($user)){
			$this->invalid_fields[] = 'mailbox';
		}
		$this->respond_with_error_if_fields_are_invalid();
		$user_data = $this->usersmodel->get_user($user->id);
		$data['facility_id'] = $this->usersettingsmodel->get_facility_id_in_mailbox($user_data->username, false);
		$accounts = array();
		if($data['facility_id'] !== null){
			$mailboxes = Mailbox::find(array("facility_id"=>$data['facility_id'],"is_group"=>0));
			foreach ($mailboxes as $mailbox){
				if($this->permissions->get_user_permissions_for_address($mailbox->email_address(),$this->application_id)){
					$accounts[] = $mailbox->name;
				}
			}
		}
		$data['accounts'] = $accounts;
		$this->response($data, 200);
	}
}

?>