<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * @package direct-as-a-service
 * @subpackage controllers
 *//** */

require_once APPPATH.'controllers/admin/Reports.php';

class Event_report_controller extends Reports{

    public function index($adhoc_report_id = null){
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("tickets_report");
        //get user id from session to get permissions
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $selected=null;

        if(!$data['show']['reports']) { show_error('Forbidden',403);  }
        $category = $this->input->post('ticket_category',TRUE);//gets select ticket category
        $export_file_name = $this->input->post('export_file_name',TRUE);

        if($category){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
            //adds each component type into its own json
            $selector = array(
                'category_id' => ($category),
            );

            $items = array(
                'tickets.id' => $this->search_type($this->input->post('ticket_id',TRUE),$this->input->post('ticket_id_type',TRUE)),
                'parent_id' => $this->search_type($this->input->post('ticket_parent',TRUE),$this->input->post('ticket_parent_type',TRUE)),
                'message' => $this->search_type($this->input->post('ticket_message',TRUE),$this->input->post('ticket_message_type',TRUE)),
            );
            $extra_items = array(
                'tickets.id' => $this->search_type($this->input->post('ticket_id',TRUE),$this->input->post('ticket_id_type',TRUE)),
                'parent_id' => $this->search_type($this->input->post('ticket_parent',TRUE),$this->input->post('ticket_parent_type',TRUE)),
                'message' => $this->search_type($this->input->post('ticket_message',TRUE),$this->input->post('ticket_message_type',TRUE)),
                'user_id' => $this->search_type($this->input->post('ticket_user',TRUE),$this->input->post('ticket_user_type',TRUE)),
            );
            $open_start_date = $this->input->post('open_start_date',TRUE);
            $open_end_date = $this->input->post('open_end_date',TRUE);
            $close_start_date = $this->input->post('close_start_date',TRUE);
            $close_end_date = $this->input->post('close_end_date',TRUE);
            //$date_array = array($open_start_date, $open_end_date, $close_start_date, $close_end_date);
            //$date_warning_message = $this->get_date_filter_validation_message($date_array);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($open_start_date, $open_end_date);
            $date_warning_message .= $this->get_paired_dates_filter_validation_message($close_start_date, $close_end_date);

            $between = array(
                'open_date' => $this->check_paired_dates($open_start_date,$open_end_date),
                'close_date' => $this->check_paired_dates($close_start_date,$close_end_date),
            );

            $typesearch = array (
                'user_id' => array(
                    'typesql' => null,
                    'name' => $this->search_type($this->input->post('ticket_user',TRUE),$this->input->post('ticket_user_type',TRUE)),
                    'type' => 3
                )
            );

            //get direction (desc/asc)and if it is being exported
            $dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = 0;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;
            $order = $this->input->post('order',TRUE);

            //calls helper to get data
            $response = $this->reports_helper('tickets',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$this->destination_page,$export,$this->items_per_page);
            $responses_list = $response['response'];

            //Adhoc_Report
            $response_adhoc = $this->reports_helper_adhoc('tickets',$items,$between,$selector,array(),$order,$dir,$this->destination_page,$export,$this->items_per_page);

            //set form data
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['open_end_date'] = $this->reports_correct_out_of_bound_date($open_end_date);
            $form_data['open_start_date'] = $this->reports_correct_out_of_bound_date($open_start_date);
            $form_data['close_end_date'] = $this->reports_correct_out_of_bound_date($close_end_date);
            $form_data['close_start_date'] = $this->reports_correct_out_of_bound_date($close_start_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $size = $response['size'];


            if($selector['category_id'] != '(ALL)') $selected = 'Category: ' . Ticket_category::find_one($selector['category_id'])->category;
            //ExportPDF-PRINT
            $response_export = $this->reports_helper('tickets',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$this->destination_page,$export,$size);
            $response_export_list = $response_export['response'];
            $data['filters'] = $this->export_info($extra_items,$between,$selected,null);

        } else if($adhoc_report_id != ''){
            /*Adhoc Reports Starts Here....*/
            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }
            /*Adhoc Reports Starts Here....*/
            $adhoc_report_data = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id,"tickets")->result();

            //Diff time period
            if(!isset($adhoc_report[0])){
                show_404();
            }
            $diff_time_period =  $this->input->post('time_period',TRUE);
            $time_period_field = $adhoc_report_data[0]->report_time_field;

            $time_start_check = $adhoc_report_data[0]->report_start_date;
            $time_end_check = $adhoc_report_data[0]->report_end_date;

            //Display Information
            $form_data['report_created_time']= $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;

            if($diff_time_period != ''){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator_array = $adhoc_report_data[0]->report_query_generator;

                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);

                //Date information
                $items = array();
                $open_start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $open_end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report_data[0]->report_query_generator;

                //Date information
                $items = array();
                $open_end_date = $adhoc_report_data[0]->report_end_date;
                $open_start_date = $adhoc_report_data[0]->report_start_date;
            }
            //Selector
            $selector = array(
                'category_id' => ($adhoc_report_data[0]->report_selector),
            );

            $between = array(
                'open_date' => $this->check_paired_dates($open_start_date,$open_end_date)
            );

            if($adhoc_report_data[0]->report_selector != '(all)'){
                $form_data['ticket_category'] = $adhoc_report_data[0]->report_selector;
            } else {
                $form_data['ticket_category'] = "";
            }

            //Date Format
            //$date_array = array($open_end_date, $open_start_date);
            $date_warning_message = get_paired_dates_filter_validation_message($open_start_date, $open_end_date);

            //get direction (desc/asc)and if it is being exported
            $order = $adhoc_report_data[0]->report_order_by;
            $dir = $adhoc_report_data[0]->report_order_by_direction;

            $items = array(
                'tickets.id' => $this->search_type($this->input->post('ticket_id',TRUE),$this->input->post('ticket_id_type',TRUE)),
                'parent_id' => $this->search_type($this->input->post('ticket_parent',TRUE),$this->input->post('ticket_parent_type',TRUE)),
                'message' => $this->search_type($this->input->post('ticket_message',TRUE),$this->input->post('ticket_message_type',TRUE)),
            );
            $extra_items = array(
                'tickets.id' => $this->search_type($this->input->post('ticket_id',TRUE),$this->input->post('ticket_id_type',TRUE)),
                'parent_id' => $this->search_type($this->input->post('ticket_parent',TRUE),$this->input->post('ticket_parent_type',TRUE)),
                'message' => $this->search_type($this->input->post('ticket_message',TRUE),$this->input->post('ticket_message_type',TRUE)),
                'user_id' => $this->search_type($this->input->post('ticket_user',TRUE),$this->input->post('ticket_user_type',TRUE)),
            );

            $typesearch = array (
                'user_id' => array(
                    'typesql' => null,
                    'name' => $this->search_type($this->input->post('ticket_user',TRUE),$this->input->post('ticket_user_type',TRUE)),
                    'type' => 3
                )
            );

            //calls helper to get data
            Ticket::db()->where($sql, NULL, $escape_columns=false);
            $size = Ticket::count();
            Ticket::db()->where($sql, NULL, $escape_columns=false)->order_by('tickets.id ASC');
            $response = Ticket::find_for_reports();

            //set form data
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['open_end_date'] = $this->reports_correct_out_of_bound_date($open_end_date);
            $form_data['open_start_date'] = $this->reports_correct_out_of_bound_date($open_start_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = 1;
            $form_data['date_warning_message'] = $date_warning_message;
            $response_adhoc = $response;


            $data['filters'] = $this->export_info($extra_items,$between,$selected,null);

            $responses_list = $response;

            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = 0;

            $data['is_export'] = $is_export;

            Ticket::db()->where($sql, NULL, $escape_columns=false)->order_by('tickets.id ASC');
            $response_export_list= Ticket::find_for_reports();

            if($selector['category_id'] != '(all)') $selected = 'Category: ' . Ticket_category::find_one($selector['category_id'])->category;
            $data['filters'] = $this->export_info($extra_items,$between,$selected,null);
        } else {
            //if this is the first time you have loaded the page
            Ticket::db()->limit($this->items_per_page)->order_by('open_date', 'DESC');
            $responses_list = Ticket::find_for_reports();

            //set defaults
            $form_data = array(
                'direction' => 'DESC',
                'order' => 'open_date',
                'cur_page' => '1',
            );
            //get number of items in log
            $size = Ticket::count();
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;

            //Adhoc Report
            $between = "";
            $response_adhoc = "";
            $dir = "DESC";
            $order = "open_date";
            $data['filters'] = ' ';
        }

        //Adhoc Report
        $data['adhoc_report_between'] = array($between);
        $data['adhoc_report_order'] = $order;
        $data['adhoc_report_direction'] = $dir;
        $data['adhoc_report_response']= $response_adhoc;
        $data['adhoc_report_type'] = "Tickets";

        //set options for comparing
        $data['compare'] = array(
            'equals' => 'Equals',
            'contains' => 'Contains',
            'starts' => 'Starts With',
            'ends' => 'Ends With'
        );

        //pagination setup
        $this->pages->items_total = $size;
        $this->pages->current_page = $this->destination_page;
        $this->pages->paginate();
        $form_data['pagination_bar'] = $this->pages->display_pages();
        $form_data['items_per_page_dropdown'] = $this->pages->display_items_per_page();

        //gets image for asc or desc
        if($form_data['direction'] == 'DESC') { $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>'; }
        else { $data['image'] = '<img src="/images/arrow_up.png" style="border : 0; width:15px;" alt="Ascending"/>'; }

        $form_data['num_pages'] = ceil($size/$this->items_per_page); //num of log pages
        $form_data['items_per_page'] = $this->items_per_page;
        $form_data['pages'] = $this->pages;
        $data['form_data'] = $form_data;
        $data['categories'] = Ticket_category::find(); //gets all categories available
        $data['ticket_list'] = $responses_list;

        foreach($responses_list as $key => $result) {
            $responses_list[$key] = $this->array_to_object($result->values_for_report());
        }

        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }

        //if export
        if($export){
            $this->export(array('ID','Parent','User','Message','Open Date ('.$data['timezone_abbr'].')','Close Date ('.$data['timezone_abbr'].')','Category'),$responses_list,$export_file_name,$extra_items,$between,$selected,null);
        }
        else if($export_pdf) {
            if(!empty($response_export)){
                $data['ticket_list'] = $response_export_list;
            } else {
                $data['ticket_list'] = $responses_list;
            }
            $report_content = $this->input->post('report_content',TRUE);
            $html = $this->load->view('api/reports/result_tables/result_tickets', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html, null, $size);
        }
        else{
            $this->load->view('api/reports/tickets', $data);
        }
    }
}
