<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * @package direct-as-a-service
 * @subpackage controllers
 *//** */

require_once APPPATH.'controllers/admin/Reports.php';

class Points_of_origin_report_controller extends Reports{

    public function index($adhoc_report_id = null){
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("points_of_origin_report");
        //get user id from session to get permissions
        $id = User::organization_id_from_session();
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $selected = null;

        if(!$data['show']['reports']) {
            show_error('Forbidden',403);
        }
        $application_id = $this->input->post('application_id',TRUE);//gets selected
        $export_file_name = $this->input->post('export_file_name',TRUE);

        if($application_id){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
            //adds each component type into its own json
            $end_date = $this->input->post('end_date',TRUE);
            $start_date = $this->input->post('start_date',TRUE);
            //$date_array = array($end_date, $start_date);

            // $date_warning_message = $this->get_date_filter_validation_message($date_array);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
            $between = array(
                'call_date' => $this->check_paired_dates($start_date,$end_date)

            );

            $order = $this->input->post('order',TRUE);
            $dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }

            if ($application_id!='(ALL)') $selected = 'Application: ' . $this->applicationmodel->get_application_name_by_id($application_id)->result()[0]->name;
            $data['is_export'] = $is_export;

            $message_counts = $this->pointsoforiginmodel->message_counts_by_application($application_id, $between, $order, $dir, $this->destination_page, $this->items_per_page, $is_export);

            $form_data = $this->input->post(NULL,TRUE);

            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $data['filters'] = $this->export_info(null,$between,$selected,null);
        } else if ($adhoc_report_id != ''){
            /*Adhoc Report - Starts Here*/

            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }

            //Adhoc Report start here
            $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id, "points_of_origin")->result();
            //Filters and Data from db
            if(!isset($adhoc_report[0])){
                show_404();
            }
            $report_selector = $adhoc_report[0]->report_selector;
            $filters_used = $this->adhocreportsmodel->get_selected_filter_array_from_db($report_selector);

            $application_id = $filters_used['application_id'];

            //From Adhoc Form
            $diff_time_period =  $this->input->post('time_period',TRUE);

            //Get Date information
            $time_period_field = $adhoc_report[0]->report_time_field;
            $time_start_check =  $filters_used['start_date'];
            $time_end_check =  $filters_used['end_date'];

            if($diff_time_period != ''){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);

                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator_array = $adhoc_report[0]->report_query_generator;

                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);

                //Date information
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report[0]->report_query_generator;

                //Date information
                $end_date =  $filters_used['end_date'];
                $start_date =  $filters_used['start_date'];

            }
            //Set Date information
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);

            $between = array(
                'call_date' => $this->check_paired_dates($start_date,$end_date)
            );

            $this->destination_page = $filters_used['adhoc_report_destination_page'];
            $this->items_per_page = $filters_used['adhoc_report_items_per_page'];
            $order = $adhoc_report[0]->report_order_by;
            $dir = $adhoc_report[0]->report_order_by_direction;
            //Export variables
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);

            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;

            if (mb_strtoupper($application_id)!='(ALL)'){
                $selected = 'Application: ' . $this->applicationmodel->get_application_name_by_id($application_id)->result()[0]->name;
            } else {
                $application_id ="";
            }

            $message_counts = $this->pointsoforiginmodel->message_counts_by_application($application_id, $between, $order, $dir, $this->destination_page, $this->items_per_page, $is_export);
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $form_data['application_id'] = $application_id;
            $form_data['order'] = $order;
            $form_data['end_date'] = $end_date;
            $form_data['start_date'] = $start_date;
            $data['filters'] = $this->export_info(null,$between,$selected,null);

            //Display Information
            $form_data['report_created_time']= $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;
            $data['form_data'] = $form_data;

        } else {//if this is the first time you have loaded the page (ie no filters have fields)
            $message_counts = $this->pointsoforiginmodel->message_counts_by_application($application_id, null, null, null, $this->destination_page, $this->items_per_page, false);
            //set defaults
            $form_data = array(
                'direction' =>'ASC',
                'order'=>'application_name',
                'cur_page'=>'1',
            );
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;

            //Adhoc Report
            $dir = "ASC";
            $order = "application_name";
            $between = array ("call_date" => Array("start"=>"", "end" =>""));
            $form_data['application_id'] = "(all)";
            $data['is_export'] = FALSE;
            $data['filters'] = ' ';
        }
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;
        $data['adhoc_report_direction'] = $order;
        $data['adhoc_report_type'] = "points_of_origin";
        $data['adhoc_report_destination_page'] = $this->destination_page;
        $data['adhoc_report_items_per_page'] = $this->items_per_page;
        $data['time_field'] = "call_date";

        $size = $message_counts['total_size'];

        //set options for available applications
        $data['apps'] = $this->applicationmodel->get_applications()->result();

        //pagination setup
        $this->pages->items_total = $size;
        $this->pages->current_page = $this->destination_page;
        $this->pages->paginate();
        $form_data['pagination_bar'] = $this->pages->display_pages();
        $form_data['items_per_page_dropdown'] = $this->pages->display_items_per_page();

        //gets image for asc or desc
        if($form_data['direction'] == 'DESC'){
            $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
        }
        else{
            $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
        }

        $form_data['num_pages'] = ceil($size/$this->items_per_page);//num of log pages
        $form_data['items_per_page'] = $this->items_per_page;
        $form_data['pages'] = $this->pages;
        $data['form_data'] = $form_data;
        $data['message_counts'] = $message_counts['list'];

        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }

        if($export){
            $this->export(array('Originating Application','Total Messages Sent'),$message_counts['list'],$export_file_name,null,$between,$selected,null);
        }
        else if($export_pdf) {
            $html = $this->load->view('api/reports/result_tables/result_points_of_origin', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html, null, $size);
        }
        else if($print_page == 1) {
            $this->clear_cache();
            $data['print_page'] = true;
            $form_data['page_select'] = $this->destination_page;
            $this->load->view('api/reports/points_of_origin', $data);
        }
        else{
            $this->load->view('api/reports/points_of_origin', $data);
        }
    }
}