<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */

require_once APPPATH.'controllers/admin/Reports.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Hisp_report_controller extends Reports{

    public function index($adhoc_report_id = null)
    {
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("hisp_report");
        //get user id from session to get permissions
        $id = User::organization_id_from_session();
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $selected = null;

        if(!$data['show']['reports']) {
            show_error('Forbidden',403);
        }
        $selected_domain = $this->input->post('selected_domain',TRUE);//gets selected
        $data['domains'] = $this->hispmodel->get_domains();
        $export_file_name = $this->input->post('export_file_name',TRUE);

        if($adhoc_report_id != '') {
            /*Adhoc Report - Starts Here*/

            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }

            $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id, "hisp")->result();
            //Diff time period
            if(!isset($adhoc_report[0])){
                show_404();
            }
            $diff_time_period =  $this->input->post('time_period',TRUE);
            $time_period_field = $adhoc_report[0]->report_time_field;

            $selected_filter_array = $this->adhocreportsmodel->get_selected_filter_array_from_db($adhoc_report[0]->report_selector);
            $time_start_check = $selected_filter_array['start_date'];
            $time_end_check = $selected_filter_array['end_date'];

            //Display Information
            $form_data['report_created_time']= $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;

            if($diff_time_period != ''){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);
                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator = $adhoc_report[0]->report_query_generator;

                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);

                //Date information
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
                $between = array(
                    'time' => $this->check_paired_dates($start_date,$end_date),
                );


            } else {
                //calls helper to get data
                $sql = $adhoc_report[0]->report_query_generator;

                //Date information
                $end_date = $selected_filter_array['end_date'];
                $start_date = $selected_filter_array['start_date'];
                $between = array(
                    'time' => $this->check_paired_dates($start_date,$end_date),
                );
            }
            //Selector
            $selector = array(
                'selected_domain' => ($selected_filter_array['selected_domain']),
            );
            $items = array();
            //Date Format
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);
            //get direction (desc/asc)and if it is being exported
            $order = $adhoc_report[0]->report_order_by;
            $dir = $adhoc_report[0]->report_order_by_direction;
            $data['filters'] = $this->export_info($items,$between,$selected,null);
            //Setting exports
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            $data['is_export'] = $is_export;

            $this->destination_page = $selected_filter_array['adhoc_report_destination_page'];
            $this->items_per_page = $selected_filter_array['adhoc_report_items_per_page'];
            $this->pages->items_per_page = $this->items_per_page;
            $message_counts = $this->hispmodel->get_message_counts_grouped_by_domain($selected_filter_array['selected_domain'], $between, $order, $dir, $this->destination_page, $this->items_per_page, $is_export);

            //set form data
            $form_data['end_date'] = $end_date;
            $form_data['start_date'] = $start_date;
            $form_data['selected_domain'] = $selected_filter_array['selected_domain'];
            $form_data['direction'] = $dir;
            $form_data['order'] = $order;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;

            //gets image for asc or desc
            if($form_data['direction'] == 'DESC'){
                $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
            }
            else{
                $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
            }

        }
        else if($selected_domain){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
            //adds each component type into its own json
            $items = array();
            $end_date = $this->input->post('end_date',TRUE);
            $start_date = $this->input->post('start_date',TRUE);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);

            $between = array(
                'time' => $this->check_paired_dates($start_date,$end_date)
            );

            $order = $this->input->post('order',TRUE);
            $dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) {
                $is_export = 'excel';
            }
            else if($export_pdf) {
                $is_export = 'pdf';
            }
            else if($print_page == 1) {
                $is_export = 'print';
            }
            if (mb_strtoupper($selected_domain) !='(ALL)') $selected = 'HISP: ' . $selected_domain;
            $data['is_export'] = $is_export;

            $message_counts = $this->hispmodel->get_message_counts_grouped_by_domain($selected_domain, $between, $order, $dir, $this->destination_page, $this->items_per_page, $is_export);

            $size = $message_counts['total_size'];

            $form_data = $this->input->post(NULL,TRUE);
            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $data['filters'] = $this->export_info($items,$between,$selected,null);

        }
        else{//if this is the first time you have loaded the page (ie no filters have fields)
            $message_counts = $this->hispmodel->get_message_counts_grouped_by_domain($selected_domain, null, null, null, $this->destination_page, $this->items_per_page, false);

            //set defaults
            $form_data = array(
                'direction' =>'ASC',
                'order'=>'domain_name',
                'cur_page'=>'1',
            );
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;

            //Adhoc Report
            $between = array ("time" => Array("start"=>"", "end" =>""));
            $dir = "ASC";
            $order = "domain_name";
            //initiate form data for adhoc report
            $form_data['selected_domain'] = '(ALL)';
            $form_data['start_date'] = '';
            $form_data['end_date'] = '';
            $data['filters'] = ' ';
            $data['is_export'] = FALSE;
        }
        $size = $message_counts['total_size'];
        //set options for available applications
        //$data['apps'] = $this->applicationmodel->get_applications()->result();

        //pagination setup
        $this->pages->items_total = $size;
        $this->pages->current_page = $this->destination_page;
        $this->pages->paginate();
        $form_data['pagination_bar'] = $this->pages->display_pages();
        $form_data['items_per_page_dropdown'] = $this->pages->display_items_per_page();

        //gets image for asc or desc
        if($form_data['direction'] == 'DESC'){
            $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
        }
        else{
            $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
        }

        $form_data['num_pages'] = ceil($size/$this->items_per_page);//num of log pages
        $form_data['items_per_page'] = $this->items_per_page;
        $form_data['pages'] = $this->pages;
        $data['form_data'] = $form_data;
        $data['message_counts'] = $message_counts['list'];

        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;
        $data['adhoc_report_direction'] = $order;
        $data['adhoc_report_type'] = "Hisp";
        $data['adhoc_report_destination_page'] = $this->destination_page;
        $data['adhoc_report_items_per_page'] = $this->items_per_page;

        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }

        //export
        if($export){
            $this->export(array('Domain Name','Total Messages Sent', 'Total Messages Received','Total Messages'),$message_counts['list'],$export_file_name,$items,$between,$selected,null);
        }
        else if($export_pdf) {
            $report_content = $this->input->post('report_content',TRUE);
            $html = $this->load->view('api/reports/result_tables/result_hisp', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html, null, $size);
        }
        else if($print_page == 1) {
            $this->clear_cache();
            $data['print_page'] = true;
            $this->load->view('api/reports/hisp', $data);
        }
        else{
            //$data['message_counts_totals'] = $message_counts_totals;
            $this->load->view('api/reports/hisp', $data);
        }
    }
}