<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * @package direct-as-a-service
 * @subpackage controllers
 *//** */

require_once APPPATH.'controllers/admin/Reports.php';

class Adhoc_report_controller extends Reports{
	
    public function index($show_report = null, $reports_id = null, $show_download = null, $export_type = null){
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        //Show Download Dialog
        $data['show_download'] = $show_download;
        if($show_download) {
            $warning_messages = '';
            foreach($reports_id as $id) {
                $info = $this->get_adhoc_export_size(intval($id), false);
                if($info['size'] > 1000) {
                    $warning_messages .= $info['report_name'] . ' contains ' . $info['size'] . ' records. ';
                }
            }
            if(!empty($warning_messages)) {
                $warning_messages .= 'This will take a few minutes. Are you sure you want to proceed?';
            }
            $data['warning_messages'] = $warning_messages;
        }
        
        //Pass ids to create links
        $data['reports_id'] = $reports_id;
        //Pass type of export
        $data['export_type'] = $export_type;
        
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("adhoc_reports_report");
        //get user id from session to get permissions
        $id = User::organization_id_from_session();
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
    
        if(!$data['show']['reports']) {
            show_error('Forbidden',403);
        }
        
        //Getting Username
        #$id = User::organization_id_from_session();
        #$user_id = $this->usersmodel->get_user_id_from_org_id($id); 
		$user_id = User::organization_id_from_session(); //TODO: Fix this at some point but it throws becausee of the use of the UserModel - BH 2018
        
		//Show Reports Info
        $all_report = FALSE;
        //Check to see if user has access to reports
        if ($this->has_access('reports')) {
          $all_report = TRUE;
        }

        //Report Display type
        switch ($show_report) {
            case 'personal':
                //Private  -  Personal Report List
                $private_reports = $this->adhocreportsmodel->get_private_reports($user_id, $all_report)->result();
                $data['report_list'] = $private_reports;
                $data['show_report'] = $show_report;
                break;
            case 'shared':
                //Shared Report List
                $shared_reports = $this->adhocreportsmodel->get_shared_reports($user_id, $all_report)->result();
                $data['report_list'] = $shared_reports;
                $data['show_report'] = $show_report;
                break;
            case 'everyone':
                //Global  -  Everyone Report List
                $global_reports = $this->adhocreportsmodel->get_global_reports($all_report)->result();
                $data['report_list'] = $global_reports;
                $data['show_report'] = $show_report;
                break;
            default:
                //Private  -  Personal Report List -  default
                $private_reports = $this->adhocreportsmodel->get_private_reports($user_id, $all_report)->result();
                $data['report_list'] = $private_reports;
                $data['show_report'] = 'personal';
        }
        
        $this->load->view('api/reports/adhoc_reports', $data);
    }	
	
    /**
     * Copy Adhoc Report to private reports
     */
    public function copy($report_id){
        
        //Select Report Information
        $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($report_id)->result();    
        $selected_filter_array = $this->adhocreportsmodel->get_selected_filter_array_from_db($adhoc_report[0]->report_selector);
        
        //Report type
        if(!isset($adhoc_report[0])){
            show_404();
        }
        $report_type =  $adhoc_report[0]->report_type;
        $report_name =  $adhoc_report[0]->report_name;
        
        //Adding Report Created from
        $report_selector_extra_options = $adhoc_report[0]->report_selector . "<=>copy_from>>".$report_id;
        
        //Selecting Post Data
        $report_name = 'Copy: '. $adhoc_report[0]->report_name;
        $report_description = $adhoc_report[0]->report_description;
        $report_access = 'private';
        $adhoc_report_between = $adhoc_report[0]->report_time_period;
        $adhoc_report_selector = $adhoc_report[0]->report_query_generator;
        $adhoc_report_order = $adhoc_report[0]->report_order_by_direction; 
        $adhoc_report_direction = $adhoc_report[0]->report_order_by;
        $adhoc_report_type = $adhoc_report[0]->report_type;
        $adhoc_report_start_date = $adhoc_report[0]->report_start_date;
        $adhoc_report_end_date = $adhoc_report[0]->report_end_date;
        $adhoc_report_selector_option = $report_selector_extra_options;            
        $adhoc_report_time_field = $adhoc_report[0]->report_time_field;
        
        //Getting username data
        $id = User::organization_id_from_session();
        $user_id = $this->usersmodel->get_user_id_from_org_id($id); 
        $report_status = 0;

        $add_report = $this->adhocreportsmodel->create_adhoc_report($report_name,$report_description,$report_access,$adhoc_report_between,$adhoc_report_selector,$adhoc_report_order,$adhoc_report_direction,$adhoc_report_type, $user_id, $report_status, $adhoc_report_start_date, $adhoc_report_end_date, $adhoc_report_selector_option, $adhoc_report_time_field);
        
        redirect('/reports/adhoc_reports/'.$report_access);
    }


    public function delete($report_id){
        //Delete Report
        $delete_report = $this->adhocreportsmodel->delete_adhoc_report($report_id);
        //Redirect to the correct adhoc report section
        $report_access = $this->adhocreportsmodel->get_report_type_by_id($report_id)->result();    
        
        redirect('/reports/adhoc_reports/'.$report_access[0]->report_access_type);
    }
	
    /**
     * Multiple Delete Adhoc Report
     */
    public function delete_multiple($report_selection){
        //Get ids to delete
        $reports_id_array = $_POST['report_ids_delete'];
        $reports_id = explode(",", $reports_id_array);

        //Delete reports
        if ($reports_id){
            foreach ($reports_id as $id){
                if($id){
                    $this->adhocreportsmodel->delete_adhoc_report($id);
                }
            } 
        }    
        //Send back to report
        redirect('/reports/adhoc_reports/'.$report_selection);
    } 

	public function export_all_in_zip() {
		$report_ids = $this->input->post('report_ids',TRUE);
		$export_type = $this->input->post('export_type',TRUE);
		$zip = new ZipArchive();
		$pdf = new WkHtmlToPdf(array('binPath' => WKHTMLTOPDF_EXE_PATH));
		$zip_name = time() . hexdec(bin2hex(openssl_random_pseudo_bytes(4))) . '.zip';
		$path_to_zip = $pdf->getTmpDir() . '\\' . $zip_name;
		$res = $zip->open($path_to_zip, ZipArchive::CREATE);
		$report_ids = explode(',', $report_ids);
		$temp_pdf_names = [];
		for($i = 0; $i < count($report_ids) - 1; $i++) {
			
			if($export_type === 'pdf') {
				$export_array = $this->adhoc_export($report_ids[$i], 'html');
				$pdf = new WkHtmlToPdf(array('binPath' => WKHTMLTOPDF_EXE_PATH));
				// Add a HTML string
				$pdf->addPage($export_array['html']);
				$path_to_temp_file = $pdf->getPdfFilename();
				$pdf->saveAs($path_to_temp_file.'.pdf');
				$temp_pdf_names[$i] = $path_to_temp_file.'.pdf';
				if ($res === TRUE) {
					$zip->addFile($path_to_temp_file.'.pdf', $export_array['report_name'] . '.pdf');
				}
				else {
					error_log('failed to add pdf file to the zip file.');
				}
			}
			else {
				$export_array = $this->adhoc_export($report_ids[$i], 'excel_to_file');
				$temp_pdf_names[$i] = $export_array['path_to_temp_file'];
				if ($res === TRUE) {
					$zip->addFile($export_array['path_to_temp_file'], $export_array['report_name'] . '.csv');
				}
				else {
					error_log('failed to add excel file to the zip file.');
				}
			}
		}
		
		//set fileDownloadAllToken, so the system is able to detect when the file downloading window for pdf export returns
		setcookie('fileDownloadAllToken', true, time() + 3600, '/reports/', false, false);
		if ($res === TRUE) {
			$zip->close();
		} else {
			error_log('failed to close the zip file.');
		}
	
		//delete temp pdf files
		foreach($temp_pdf_names as $pdf_name) {
			if(!unlink($pdf_name)) {
				error_log('failed to delete temp export files.');
			}
		}

		//the clean is necessary to keep returned zip file valid
		ob_clean();
		ob_end_flush();
		//return zip file to user
		header($_SERVER["SERVER_PROTOCOL"] . " 200 OK");
		header("Cache-Control: public"); // needed for i.e.
		header("Content-Type: application/zip");
		header("Content-Transfer-Encoding: Binary");
		header("Content-Length:".filesize($path_to_zip));
		header("Content-Disposition: attachment; filename=export_" . $export_type . ".zip");
		readfile($path_to_zip);
		//delete zip file
		if(!unlink($path_to_zip)) {
			error_log('failed to delete zip file.');
		}
		exit;
	}

    /**
     * Multiple Export PDF Adhoc Report
     */
    public function export_to_pdf_multiple($report_selection){
        //Get ids to export to pdf array
        $reports_id_array = $this->input->post('report_ids_pdf', TRUE);
        $reports_id = explode(',', $reports_id_array);
        //filter out empty values in report id array
        $reports_id = array_values(array_filter($reports_id));
        //Set variables to create link
        $show_download = TRUE;
        $export_type = "adhoc_export_pdf";
        //Checking that array is not null or empty
        if(!empty($reports_id_array)) {
            $this->index($report_selection, $reports_id, $show_download, $export_type);
        } else {
            redirect('/reports/adhoc_reports/'.$report_selection);
        }    

    } 
        
    /**
     * Multiple Export Excel Adhoc Report
     */
    public function export_to_excel_multiple($report_selection){
        //Get ids to export to excel array
        $reports_id_array = $this->input->post('report_ids_excel', TRUE);
        $reports_id = explode(',', $reports_id_array);
        //filter out empty values in report id array
        $reports_id = array_values(array_filter($reports_id));
        //Set variables to create link
        $show_download = TRUE;
        $export_type = "adhoc_export_excel";
        //Checking that array is not null or empty
        if(!empty($reports_id_array)) {
            $this->index($report_selection, $reports_id, $show_download, $export_type);
        } else {
            redirect('/reports/adhoc_reports/'.$report_selection);
        }        
    }  

}