<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage controllers
*//** */


require_once APPPATH.'controllers/admin/DAAS_controller.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/
class Onboarding extends DAAS_Controller
{
	public function __construct(){
		parent::__construct();
				
		$this->load->library(array('eventlog','template'));
		$this->load->model( array('accountrequestmodel', 'applicationmodel'));
		require_models('account_request', 'application', 'application_account');
	}
	
	public function index() {
		$this->onboarding();
	}
		
	
	/* -----------------------------*
	 *  ONBOARDING TAB FUNCTIONS    *
	 * -----------------------------*/
	
	/** Terms of service for this organization - users must agree to this every time that they log in. */
	public function banner(){
		$redirect_uri = $this->session->flashdata('redirect_uri');
		if(empty($redirect_uri))
			$redirect_uri = site_url('onboarding');
			
		if(array_key_exists('banner_agree', $_SESSION) && $_SESSION['banner_agree'])
			redirect($redirect_uri);		
		
		if(!empty($_POST) && array_key_exists('submit', $_POST)){
			$redirect_uri = $this->input->post('redirect_uri', TRUE);
			if(!string_begins_with(base_url(), $redirect_uri))
				$redirect_uri = site_url($redirect_uri);
			if(!$this->is->string_like_a_url($redirect_uri))
				$redirect_uri = site_url('onboarding');
			
			$_SESSION['banner_agree'] = true;
			redirect($redirect_uri);
			return; //in case the redirect fails
		}
		
		$this->template->show_navbar = false;
		$this->template->set('title', WARNING_BANNER_PAGE_TITLE);
		$this->template->set('page_title', WARNING_BANNER_TITLE);
		

		//there is so little content to this page that it doesn't seem worth redirecting
		$content = '<div class="well">'.WARNING_BANNER.'</div>';
		$content .= form_open('onboarding/banner');
		if(!empty($this->session->flashdata('redirect_uri')))
			$content .= form_hidden('redirect_uri', $this->session->flashdata('redirect_uri'));
		$content .= form_submit('submit', 'I agree', 'class="btn btn-default btn-sm"');
		$content .= form_close();
		
		return $this->template->load_string('template', $content);
	}
	

	/** 
	 * Onboarding is the main page a user will see when first accessing the site. 
	 */
	public function onboarding() {		
		$this->template->set('title', 'Direct API: Onboarding');		
	
		$data['user'] = $user = User::find_from_session();
		$category = Ticket_category::find_one(array('category' => 'Contact'));

		$data['category'] = $category->id;
		
		$data['account_request'] = $account_request =  Account_request::find_from_session();
		$data['status'] = Account_request::is_an_entity($account_request) ? $account_request->status() : User::organization_id_from_session();

		if($user) {
			$data['sent_message'] = $user->has_submitted_ticket_today(array('category_id' => $category->id));
		}
		
		if(!empty($this->session->flashdata('error_message'))) {
			$data['error_message'] = $this->session->flashdata('error_message');
			$data = array_merge($data, $this->session->flashdata('post_data_from_last_request')); //add post data to $data from flashdata
		}
		
		if(!empty($this->session->flashdata('success_message'))) {
			$data['success_message'] = $this->session->flashdata('success_message');
		}
		
		$this->template->load('template', 'api/onboarding/onboarding', $data);
	}

	/*
	 * Documentation directory
	 */
	public function documentation() {
		$this->template->title =  'Direct API: API Documentation';
		$this->template->page_title = 'API Documentation';
		$this->template->load('template', 'api/onboarding/documentation');
	}

	/**
	* Centralized function that can show any of the docs that we have for services
	* @param string $type The service we're showing, as named in the view
	*/ 
	public function docs_for_service($type){
		if(!$this->is->view('api/onboarding/services/'.$type)){
			if(is_on_local()) $this->error->warning('There is no documentation for '.$type); //only do this on local so people can't fill our logs by just hitting a bad URL
			show_404();
		}
		
		$title = 'Direct API: '.humanize($type);
		if(string_begins_with('automatic_reply', $type))
			$title = str_replace('Automatic Reply', 'Automatic Reply - ', $title);
		$active_tab = array('onboarding' => true);

		//get user id from session to get permissions
		$id = User::organization_id_from_session();
		$permissions = $this->permissions->get_user_permissions($id);
		$show = $this->permissions->set_tab_access_from_permissions($permissions);

		$this->load->view('api/onboarding/services/'.$type, compact('title', 'active_tab', 'show'));		
	}

	/*
	 * Widget documentation
	 * todo: when more widgets are added, create a directory page, meanwhile this will just lead to the New Messages widget page
	 */
	public function widgets($widget_page = NULL){
		$this->template->set('title', 'Direct API: Widgets');
		$this->template->set('page_title', 'Widget Documentation');
		if(empty($widget_page)) {
			$this->template->load('template', 'api/onboarding/widgets/widget_directory');
		}
		else if($widget_page === 'new_message_count') {
			$this->template->load('template', 'api/onboarding/widgets/new_message_count');
		}
		else if($widget_page === 'send_ccd') {
			$this->template->load('template', 'api/onboarding/widgets/send_ccd');
		}
		else { show_404(); }
	}


}
