<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* Parent controller for the API ADMIN that will authenticate the user, set session variables 
* @package direct-as-a-service
* @subpackage controllers
*/ 

/**
* @package direct-as-a-service
* @subpackage controllers
*/ 
class DAAS_controller extends CI_Controller {
	
	var $user; //a User object represent the currently logged-in user
	
	public function __construct(){
		parent::__construct();

		$this->load->library('Validator', array(), 'is');
		
		//in general, all aspects of API Admin are limited to people who can be authorized and proved to be VA users (whether they have an account on our site or not)
		//in a very few cases, we allow some non-va users to access certain parts of the site (at the time of this writing, just to download file transfers, but we may expand that in future) -- MG 2016-09-15
		if(method_exists($this, 'allow_non_va_users') && $this->allow_non_va_users()) return;				

		//from here on out, code assumes that the user has a PIV badge and is authorized as a VA user, even if they don't have an account on our site
		if(!User::log_in())
			show_error('Unauthorized',401);
			
		//check if user has agreed to banner
		$banner = $this->session->userdata('banner_agree');
		$exclude_from_banner = array('onboarding/banner', 'authorize/register', 'authorize/edit_webservice_permission');
		if((empty($_SESSION['banner_agree']) || $_SESSION['banner_agree'] != 'true') && !in_array($this->uri->segment(1).'/'.$this->uri->segment(2), $exclude_from_banner)) {
			$this->session->set_flashdata('redirect_uri',uri_string());
			redirect('onboarding/banner');
		}
	}
	


}