<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* URI ROUTING
* 
* This file lets you re-map URI requests to specific controller functions.
*
* Typically there is a one-to-one relationship between a URL string
* and its corresponding controller class/method. The segments in a
* URL normally follow this pattern:
*
*	example.com/class/method/id/
*
* In some instances, however, you may want to remap this relationship
* so that a different class/function is called than the one
* corresponding to the URL.
*
* Please see the user guide for complete details:
*
*	http://codeigniter.com/user_guide/general/routing.html
*
* 
* RESERVED ROUTES
*
* There area two reserved routes:
*
*	$route['default_controller'] = 'welcome';
*
* This route indicates which controller class should be loaded if the
* URI contains no data. In the above example, the "welcome" class
* would be loaded.
*
*	$route['404_override'] = 'errors/page_missing';
*
* This route will tell the Router what URI segments to use if those provided
* in the URL cannot be matched to a valid route.
*
* @package direct-as-a-service
* @subpackage config
*/

//set default controller differently if using the admin panel domain
if(defined('PHPUNIT_TEST')){
	$route['default_controller'] = 'unit_test_controller'; 
}elseif(defined('API_ADMINPANEL_DOMAIN') && mb_strstr($_SERVER['HTTP_HOST'], API_ADMINPANEL_DOMAIN)) {
	$route['default_controller'] = 'admin_redirect';
}else { 
	$route['default_controller'] = 'admin/direct'; 
}
$route['404_override'] = '';


if(!in_api_context()){
	$route['authorize/edit_webservice_permission/id/(:num)/mailbox_name/(:any)/is_group/(:num)/redirect_url/(:any)'] = 'admin/user_settings/edit_webservice_permission/$1/$2/$4';
	$route['authorize/edit_webservice_permission/(.+)'] = 'admin/user_settings/edit_webservice_permission';
	$route['authorize/edit_webservice_permission'] = 'admin/user_settings/edit_webservice_permission';
	$route['authorize/register/id/(:num)/unique/(:any)/destination/(:any)'] = 'admin/registration_controller/application_account_request/$1/$2/$3';
	$route['authorize/register/id/(:num)/unique/(:any)/(:any)'] = 'admin/registration_controller/application_account_request/$1/$2';
	$route['authorize/register/id/(:num)/unique/(:any)'] = 'admin/registration_controller/application_account_request/$1/$2';
	$route['authorize/register'] = 'admin/registration_controller/application_account_request';
}

/* Admin Panel Routes */
/* onboarding routes */
$route['onboarding/request'] = 'admin/registration_controller/onboarding_request/';
$route['onboarding/request/edit/(.+)'] = 'admin/registration_controller/onboarding_request_edit/$1';

/* applications routes */
$route['applications/list'] = 'admin/applications/application_list/';
$route['applications/edit/(.+)'] = 'admin/applications/application_edit/$1';

/* facilities routes */
$route['facilities/list'] = 'admin/facilities/facility_list/';
$route['facilities/edit/(.+)'] = 'admin/facilities/facility_edit/$1';

/* file transfer routes */
if(ENABLE_FILE_TRANSFERS){
	$route['message/(:num)/file_transfer/(:any)'] = 'admin/file_transfer_controller/view/$1/$2'; 
	$route['file_transfer/(authorize|download)/(:num)/(:any)'] = 'admin/file_transfer_controller/$1/$2/$3';
	$route['file_transfer/(ajax_upload_progress)/(:any)'] = 'admin/file_transfer_controller/$1/$2';
	$route['file_transfer/(:any)'] = 'admin/file_transfer_controller/$1';
	$route['file_transfer/(:any)/(:get)'] = 'admin/file_transfer_controller/$1';
}


/* reports routes */
$route['reports/requests'] = 'reports/request_report_controller/index/';
$route['reports/requests/(.+)'] = 'reports/request_report_controller/index/$1';
$route['reports/report_requests'] = 'reports/request_report_controller/index/'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/report_requests/(.+)'] = 'reports/request_report_controller/index/$1'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/events'] = 'reports/event_report_controller/index/';
$route['reports/events/(.+)'] = 'reports/event_report_controller/index/$1';
$route['reports/report_events'] = 'reports/event_report_controller/index/'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/report_events/(.+)'] = 'reports/event_report_controller/index/$1'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/logins'] = 'reports/login_report_controller/index';
$route['reports/logins/(.+)'] = 'reports/login_report_controller/index/$1';
$route['reports/report_logins'] = 'reports/login_report_controller/index'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/report_logins/(.+)'] = 'reports/login_report_controller/index/$1'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/mail'] = 'reports/mail_report_controller/index';
$route['reports/mail/(.+)'] = 'reports/mail_report_controller/index/$1';
$route['reports/report_mail'] = 'reports/mail_report_controller/index'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/report_mail/(.+)'] = 'reports/mail_report_controller/index/$1'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/tickets'] = 'reports/ticket_report_controller/index';
$route['reports/tickets/(.+)'] = 'reports/ticket_report_controller/index/$1';
$route['reports/facility'] = 'reports/facility_report_controller/index';
$route['reports/facility/(.+)'] = 'reports/facility_report_controller/index/$1';
$route['reports/report_facility'] = 'reports/facility_report_controller/index'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/report_facility/(.+)'] = 'reports/facility_report_controller/index/$1'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/hisp'] = 'reports/hisp_report_controller/index';
$route['reports/hisp/(.+)'] = 'reports/hisp_report_controller/index/$1';
$route['reports/report_hisp'] = 'reports/hisp_report_controller/index'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/report_hisp/(.+)'] = 'reports/hisp_report_controller/index/$1'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/points_of_origin'] = 'reports/points_of_origin_report_controller/index';
$route['reports/points_of_origin/(.+)'] = 'reports/points_of_origin_report_controller/index/$1';
$route['reports/report_points_of_origin'] = 'reports/points_of_origin_report_controller/index'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/report_points_of_origin/(.+)'] = 'reports/points_of_origin_report_controller/index/$1'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/user_activity_summary'] = 'reports/user_summary_report_controller/index';
$route['reports/user_activity_summary/(.+)'] = 'reports/user_summary_report_controller/index/$1';
$route['reports/report_user_activity_summary'] = 'reports/user_summary_report_controller/index'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/report_user_activity_summary/(.+)'] = 'reports/user_summary_report_controller/index/$1'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/group_activity_summary'] = 'reports/group_summary_report_controller/index';
$route['reports/group_activity_summary/(.+)'] = 'reports/group_summary_report_controller/index/$1';
$route['reports/report_group_activity_summary'] = 'reports/group_summary_report_controller/index'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/report_group_activity_summary/(.+)'] = 'reports/group_summary_report_controller/index/$1'; //deprecated - here for backwards compatibility until we remove all references to it
$route['reports/save_adhoc_report'] = 'admin/reports/save_adhoc_report/';

/* adhoc reports routes */
$route['reports/adhoc_reports'] = 'reports/adhoc_report_controller/index';
$route['reports/adhoc_reports/(:any)'] = 'reports/adhoc_report_controller/index/$1';
$route['reports/adhoc_export_delete/(:num)'] = 'reports/adhoc_report_controller/delete/$1';
$route['reports/adhoc_report_delete_multiple/(.+)'] = 'reports/adhoc_report_controller/delete_multiple/$1';
$route['reports/adhoc_report_export_to_pdf_multiple/(.+)'] = 'reports/adhoc_report_controller/export_to_pdf_multiple/$1';
$route['reports/adhoc_report_export_to_excel_multiple/(.+)'] = 'reports/adhoc_report_controller/export_to_excel_multiple/$1';
$route['reports/copy_adhoc_report/(:num)'] = 'reports/adhoc_report_controller/copy/$1';
$route['reports/adhoc_report_export_all_in_zip'] = 'reports/adhoc_report_controller/export_all_in_zip/';

/* user settings routes */
$route['user_settings/application_list'] = 'admin/user_settings/application_list/';
$route['user_settings/webservice_access_edit'] = 'admin/user_settings/webservice_access_edit/';
$route['user_settings/account_edit'] = 'admin/user_settings/account_edit/';

/* global search routes */
$route['global_search'] = 'admin/global_search_controller/index';
$route['global_search/search'] = 'admin/global_search_controller/search/';
$route['global_search/view/(:num)'] = 'admin/global_search_controller/view/$1';
$route['global_search/raw/(:num)'] = 'admin/global_search_controller/raw/$1';
$route['global_search/update_folders/(.+)'] = 'admin/global_search_controller/update_folders/$1';
$route['global_search/get_attachment/(:num)/(.+)'] = 'admin/global_search_controller/get_attachment/$1/$2';

/* admin routes */
$route['administration/manage/accounts'] = 'admin/administration/admin_manage_accounts/';
$route['administration/manage/accounts/edit/access/(.+)'] = 'admin/administration/admin_edit_account_access/$1';
$route['administration/manage/accounts/edit/(.+)'] = 'admin/administration/admin_edit_account/$1';
$route['administration/manage/accounts/disable'] = 'admin/administration/disable_account/';
$route['administration/manage/accounts/enable'] = 'admin/administration/enable_account/';
$route['administration/application/requests'] = 'admin/administration/application_request_list/';
$route['administration/account/requests'] = 'admin/administration/account_request_list/';
$route['administration/manage/groups'] = 'admin/administration/admin_manage_groups/';
$route['administration/manage/groups/edit/access/(.+)'] = 'admin/administration/admin_edit_group_access/$1';
$route['administration/manage/groups/edit/(.+)'] = 'admin/administration/admin_edit_group/$1';
$route['administration/manage/groups/disable'] = 'admin/administration/disable_group/';
$route['administration/manage/groups/enable'] = 'admin/administration/enable_group/';
$route['administration/manage_groups/application_list/(.+)'] = 'admin/user_settings/application_list/$1';
$route['administration/manage_accounts/application_list/(.+)'] = 'admin/user_settings/application_list/$1';
$route['administration/manage/facilities'] = 'admin/administration/admin_manage_facilities/';
$route['administration/manage/facilities/edit'] = 'admin/administration/facility_edit';
$route['administration/manage/facilities/edit/(.+)'] = 'admin/administration/facility_edit/$1';

/* ------------------- */

/* Admin API routes */
$route['admin/create/user'] = 'services/admin/create_user/';
$route['admin/create/group'] = 'services/admin/create_group/';

/* ------------------- */

$route['onboarding/documentation/(:any)'] = 'admin/onboarding/docs_for_service/$1';

/*Re-route sub-directories for controllers to top-level */
/* admin pages */
$route['onboarding'] = 'admin/onboarding';
$route['onboarding/(.+)'] = 'admin/onboarding/$1';
$route['applications'] = 'admin/applications';
$route['applications/(.+)'] = 'admin/applications/$1';
$route['facilities'] = 'admin/facilities';
$route['facilities/(.+)'] = 'admin/facilities/$1';
$route['reports'] = 'admin/reports';
$route['reports/(.+)'] = 'admin/reports/$1';
$route['administration'] = 'admin/administration';
$route['administration/(.+)'] = 'admin/administration/$1';
$route['user_settings'] = 'admin/user_settings';
$route['user_settings/(.+)'] = 'admin/user_settings/$1';
$route['support'] = 'admin/support';
$route['support/(.+)'] = 'admin/support/$1';
$route['logout'] = 'public_controller/log_out';

if(is_on_local())
	$route['style_guide'] = 'public_controller/style_guide';

/* API SERVICES  */

/* accounts */
$route['direct/account/update/(.+)'] = 'services/account_controller/update_account/$1';
$route['direct/account/update'] = 'services/account_controller/update_account';
$route['direct/account/in_facility/(.+)'] = 'services/account_controller/accounts_in_facility/$1';
$route['direct/account/in_facility'] = 'services/account_controller/accounts_in_facility';
$route['direct/account/(.+)'] = 'services/account_controller/account/$1';
$route['direct/account'] = 'services/account_controller/account';

/* groups*/

$route['direct/group/update/(.+)'] = 'services/group_controller/update_group/$1';
$route['direct/group/update'] = 'services/group_controller/update_group';
$route['direct/group/in_facility/(.+)'] = 'services/group_controller/groups_in_facility/$1';
$route['direct/group/in_facility'] = 'services/group_controller/groups_in_facility';
$route['direct/group/(.+)'] = 'services/group_controller/group/$1';
$route['direct/group'] = 'services/group_controller/group';


/* folders */
$route['direct/folders/archive/(.+)'] = 'services/folder_controller/archive_folder/$1';
$route['direct/folders/archive'] = 'services/folder_controller/archive_folder';
$route['direct/folders/rename/(.+)'] = 'services/folder_controller/rename_folder/$1';
$route['direct/folders/rename'] = 'services/folder_controller/rename_folder';
$route['direct/folders/create/(.+)'] = 'services/folder_controller/create_folder/$1';
$route['direct/folders/create'] = 'services/folder_controller/create_folder';
$route['direct/folders/change_parent/(.+)'] = 'services/folder_controller/change_parent/$1';
$route['direct/folders/change_parent'] = 'services/folder_controller/change_parent';

$route['direct/folders/(.+)'] = 'services/folder_controller/folders/$1';
$route['direct/folders'] = 'services/folder_controller/folders';

/* message save/send */
$route['direct/messages/save/(.+)'] = 'services/message_send_controller/save/$1';
$route['direct/messages/save'] = 'services/message_send_controller/save';
$route['direct/messages/send/draft/(.+)'] = 'services/message_send_controller/send_draft/$1';
$route['direct/messages/send/draft'] = 'services/message_send_controller/send_draft';
$route['direct/send/(.+)'] = 'services/message_send_controller/send/$1';
$route['direct/send'] = 'services/message_send_controller/send';
$route['direct/save/(.+)'] = 'services/message_send_controller/save/$1';
$route['direct/save'] = 'services/message_save_controller/send';
$route['direct/disclosure/log/(.+)'] = 'services/message_disclosure_controller/log_attachment_disclosure/$1';
$route['direct/disclosure/log'] = 'services/message_disclosure_controller/log_attachment_disclosure';
$route['direct/disclosures/log/(.+)'] = 'services/message_disclosure_controller/log_disclosures_for_message/$1';
$route['direct/disclosures/log'] = 'services/message_disclosure_controller/log_disclosures_for_message';

/* message management */
$route['direct/messages/move/(.+)'] = 'services/message_controller/move_message/$1';
$route['direct/messages/move'] = 'services/message_controller/move_message';
$route['direct/messages/archive/(.+)'] = 'services/message_controller/archive_message/$1';
$route['direct/messages/archive'] = 'services/message_controller/archive_message';
$route['direct/messages/restore/(.+)'] = 'services/message_controller/restore_message/$1';
$route['direct/messages/restore'] = 'services/message_controller/restore_message';
$route['direct/messages/flag/set/(.+)'] = 'services/message_controller/set_flag/$1';
$route['direct/messages/flag/set'] = 'services/message_controller/set_flag';
$route['direct/messages/process_incoming/(.+)'] = 'services/message_controller/process_incoming/$1';
$route['direct/messages/process_incoming'] = 'services/message_controller/process_incoming';

/* message retrieve */
$route['direct/messages/count/(.+)'] = 'services/message_retrieve_controller/count/$1';
$route['direct/messages/count'] = 'services/message_retrieve_controller/count';
$route['direct/messages/(.+)'] = 'services/message_retrieve_controller/messages/$1';
$route['direct/messages'] = 'services/message_retrieve_controller/messages';

$route['direct/message/(.+)'] = 'services/message_retrieve_controller/message/$1';
$route['direct/message'] = 'services/message_retrieve_controller/message';

/*directory*/
$route['direct/addresses/(.+)'] = 'services/directory_controller/addresses/$1';
$route['direct/addresses'] = 'services/directory_controller/addresses';

/* automatic replies */
$route['direct/automatic_reply/(create|update|delete|find)/(.+)'] = 'services/automatic_replies_controller/$1/$2';
$route['direct/automatic_reply/(create|update|delete|find)'] = 'services/automatic_replies_controller/$1';

/* file_transfers */
if(ENABLE_FILE_TRANSFERS){
	$route['direct/file_transfer/(create|delete)/(.+)'] = 'services/file_transfer_controller/$1/$2';
	$route['direct/file_transfer/(create|delete)'] = 'services/file_transfer_controller/$1';
}

/* mailboxes */
$route['direct/mailboxes/(.+)'] = 'services/user_controller/mailboxes/$1';
$route['direct/mailboxes'] = 'services/user_controller/mailboxes';

/* reports */
$route['direct/reports/mailbox_activities/(.+)'] = 'services/reports/mailbox_activities/$1';
$route['direct/reports/mailbox_activities'] = 'services/reports/mailbox_activities';

/* validation */
$route['direct/validate/(.+)'] = 'services/direct/validate/$1';
$route['direct/validate'] = 'services/direct/validate';

/* disclosure */
$route['disclosure/summary/(.+)'] = 'services/disclosure_controller/summary/$1';
$route['disclosure/summary'] = 'services/disclosure_controller/summary';
$route['disclosure/(.+)'] = 'services/disclosure_controller/audit/$1';
$route['disclosure'] = 'services/disclosure_controller/audit';

/* defaults - these must be the last routes in the file! */
$route['direct/(.+)'] = 'services/direct/$1';
$route['direct'] = 'services/direct';

$route['admin/(.+)'] = 'services/admin/$1';
$route['admin'] = 'services/admin';

/* tests */
if(DIRECT_ENVIRONMENT == 'LOCAL'){
	$route['tests/(:any)'] = 'tests/$1_tests/index';
	$route['tests/(:any)/(.+)'] = 'tests/$1_tests/test/$2';
	$route['unit-tests'] = 'unit_test_controller/index';
}
/* ------------------- */

/* End of file routes.php */
/* Location: ./application/config/routes.php */