<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage config
*//** */

/**
* Base Site URL
*
* URL to your CodeIgniter root. Typically this will be your base URL,
* WITH a trailing slash:
*
*	http://example.com/
*
* If this is not set then CodeIgniter will guess the protocol, domain and
* path to your installation.
*
* @global string $config['base_url']
*/
if(defined('PHPUNIT_TEST') || (defined('API_ADMINPANEL_DOMAIN') && mb_strstr($_SERVER['HTTP_HOST'], API_ADMINPANEL_DOMAIN))) {
	$config['base_url']	= 'https://'.API_ADMINPANEL_DOMAIN.'/';
}elseif(defined('API_FILETRANSFER_DOMAIN') && mb_strstr($_SERVER['HTTP_HOST'], API_FILETRANSFER_DOMAIN)){
	$config['base_url'] = 'https://'.API_FILETRANSFER_DOMAIN.'/';
}else {
	$config['base_url']	= 'https://'.API_DOMAIN.'/';
}

/**
* Index File
* 
* Typically this will be your index.php file, unless you've renamed it to
* something else. If you are using mod_rewrite to remove the page set this
* variable so that it is blank.
*
* @global string $config['index_page']
*/
$config['index_page'] = '';

/**
* URI PROTOCOL
* 
* This item determines which server global should be used to retrieve the
* URI string.  The default setting of 'AUTO' works for most servers.
* If your links do not seem to work, try one of the other delicious flavors:
*
* 'AUTO'			Default - auto detects
* 'PATH_INFO'		Uses the PATH_INFO
* 'QUERY_STRING'	Uses the QUERY_STRING
* 'REQUEST_URI'		Uses the REQUEST_URI
* 'ORIG_PATH_INFO'	Uses the ORIG_PATH_INFO
*
* @global string $config['uri_protocol']
*/
$config['uri_protocol']	= 'AUTO';

/**
* URL suffix
* 
* This option allows you to add a suffix to all URLs generated by CodeIgniter.
* For more information please see the user guide:
*
* http://codeigniter.com/user_guide/general/urls.html
*
* @global string $config['url_suffix']
*/

$config['url_suffix'] = '';

/**
* Default Language
* 
* This determines which set of language files should be used. Make sure
* there is an available translation if you intend to use something other
* than english.
*
* @global string $config['language']
*/
$config['language']	= 'english';

/**
* Default Character Set
* 
* This determines which character set is used by default in various methods
* that require a character set to be provided.
*
* @global string $config['charset']
*/
$config['charset'] = 'UTF-8';

/**
* Enable/Disable System Hooks
* 
* If you would like to use the 'hooks' feature you must enable it by
* setting this variable to TRUE (boolean).  See the user guide for details.
*
* @global boolean $config['enable_hooks']
*/
$config['enable_hooks'] = TRUE;


/**
* Class Extension Prefix
* 
* This item allows you to set the filename/classname prefix when extending
* native libraries.  For more information please see the user guide:
*
* http://codeigniter.com/user_guide/general/core_classes.html
* http://codeigniter.com/user_guide/general/creating_libraries.html
*
* @global string $config['subclass_prefix']
*/
$config['subclass_prefix'] = 'DAAS_';

/*
|--------------------------------------------------------------------------
| Composer auto-loading
|--------------------------------------------------------------------------
|
| Enabling this setting will tell CodeIgniter to look for a Composer
| package auto-loader script in application/vendor/autoload.php.
|
|	$config['composer_autoload'] = TRUE;
|
| Or if you have your vendor/ directory located somewhere else, you
| can opt to set a specific path as well:
|
|	$config['composer_autoload'] = '/path/to/vendor/autoload.php';
|
| For more information about Composer, please visit http://getcomposer.org/
|
| Note: This will NOT disable or override the CodeIgniter-specific
|	autoloading (application/config/autoload.php)
*/
$config['composer_autoload'] = FALSE;

/**
* Allowed URL Characters
* 
* This lets you specify with a regular expression which characters are permitted
* within your URLs.  When someone tries to submit a URL with disallowed
* characters they will get a warning message.
*
* As a security measure you are STRONGLY encouraged to restrict URLs to
* as few characters as possible.  By default only these are allowed: a-z 0-9~%.:_-
*
* Leave blank to allow all characters -- but only if you are insane.
*
* DO NOT CHANGE THIS UNLESS YOU FULLY UNDERSTAND THE REPERCUSSIONS!!
*
* @global string $config['permitted_uri_chars']
*/
$config['permitted_uri_chars'] = 'a-z 0-9~%.:_\'\-()@=';
/* 2017-06-30 - Myke Carter - Apostrophe added to accommodate users with apostrophes in their names and/or external email addresses */

/**
* Enable Query Strings
* 
* By default CodeIgniter uses search-engine friendly segment based URLs:
* example.com/who/what/where/
*
* By default CodeIgniter enables access to the $_GET array.  If for some
* reason you would like to disable it, set 'allow_get_array' to FALSE.
*
* You can optionally enable standard query string based URLs:
* example.com?who=me&what=something&where=here
*
* Options are: TRUE or FALSE (boolean)
*
* The other items let you set the query string 'words' that will
* invoke your controllers and its functions:
* example.com/index.php?c=controller&m=function
*
* Please note that some of the helpers won't work as expected when
* this feature is enabled, since CodeIgniter is designed primarily to
* use segment based URLs.
*/
$config['allow_get_array']		= TRUE;
$config['enable_query_strings'] = FALSE;
$config['controller_trigger']	= 'c';
$config['function_trigger']		= 'm';
$config['directory_trigger']	= 'd'; // experimental not currently in use

/**
* Error Logging Threshold
* 
* If you have enabled error logging, you can set an error threshold to
* determine what gets logged. Threshold options are:
* You can enable error logging by setting a threshold over zero. The
* threshold determines what gets logged. Threshold options are:
*
*	0 = Disables logging, Error logging TURNED OFF
*	1 = Error Messages (including PHP errors)
*	2 = Debug Messages
*	3 = Informational Messages
*	4 = All Messages
*
* For a live site you'll usually only enable Errors (1) to be logged otherwise
* your log files will fill up very fast.
*
* @global int $config['log_threshold']
*/
$config['log_threshold'] = 1;

/**
* Error Logging Directory Path
* 
* Leave this BLANK unless you would like to set something other than the default
* application/logs/ folder. Use a full server path with trailing slash.
*
* @global string $config['log_path']
*/
$config['log_path'] = '';


/*
|--------------------------------------------------------------------------
| Log File Extension
|--------------------------------------------------------------------------
|
| The default filename extension for log files. The default 'php' allows for
| protecting the log files via basic scripting, when they are to be stored
| under a publicly accessible directory.
|
| Note: Leaving it blank will default to 'php'.
|
*/
$config['log_file_extension'] = '';

/*
|--------------------------------------------------------------------------
| Log File Permissions
|--------------------------------------------------------------------------
|
| The file system permissions to be applied on newly created log files.
|
| IMPORTANT: This MUST be an integer (no quotes) and you MUST use octal
|            integer notation (i.e. 0700, 0644, etc.)
*/
$config['log_file_permissions'] = 0644;

/**
* Date Format for Logs
* 
* Each item that is logged has an associated date. You can use PHP date
* codes to set your own date formatting
*
* @global string $config['log_date_format']
*/
$config['log_date_format'] = 'Y-m-d H:i:s';

/**
* Error Views Directory Path
*
* Leave this BLANK unless you would like to set something other than the default
* application/views/errors/ directory.  Use a full server path with trailing slash.
*
* @global string $config['error_views_path']
*/
$config['error_views_path'] = '';

/**
* Cache Directory Path
* 
* Leave this BLANK unless you would like to set something other than the default
* system/cache/ folder.  Use a full server path with trailing slash.
*
* @global string $config['cache_path']
*/
$config['cache_path'] = '';

$application_ini_config = parse_ini_file(APPLICATION_INI_LOCATION);

/**
* Encryption Key
* 
* If you use the Encryption class or the Session class you
* MUST set an encryption key.  See the user guide for info.
*
* @global string $config['encryption_key']
*/
$config['encryption_key'] = $application_ini_config['encryption_key'];

/*
|--------------------------------------------------------------------------
| Session Variables
|--------------------------------------------------------------------------
|
| 'sess_driver'
|
|	The storage driver to use: files, database, redis, memcached
|
| 'sess_cookie_name'
|
|	The session cookie name, must contain only [0-9a-z_-] characters
|
| 'sess_expiration'
|
|	The number of SECONDS you want the session to last.
|	Setting to 0 (zero) means expire when the browser is closed.
|
| 'sess_save_path'
|
|	The location to save sessions to, driver dependant.
|
|	For the 'files' driver, it's a path to a writable directory.
|	WARNING: Only absolute paths are supported!
|
|	For the 'database' driver, it's a table name.
|	Please read up the manual for the format with other session drivers.
|
|	IMPORTANT: You are REQUIRED to set a valid save path!
|
| 'sess_match_ip'
|
|	Whether to match the user's IP address when reading the session data.
|
| 'sess_time_to_update'
|
|	How many seconds between CI regenerating the session ID.
|
| 'sess_regenerate_destroy'
|
|	Whether to destroy session data associated with the old session ID
|	when auto-regenerating the session ID. When set to FALSE, the data
|	will be later deleted by the garbage collector.
|
| Other session cookie settings are shared with the rest of the application,
| except for 'cookie_prefix' and 'cookie_httponly', which are ignored here.
|
*/
$config['sess_driver'] = 'files';
$config['sess_cookie_name'] = 'api_session';
$config['sess_expiration'] = 600;
$config['sess_save_path'] = NULL;
$config['sess_match_ip'] = FALSE;
$config['sess_time_to_update']	= 0; //don't change the session id until the session expires
$config['sess_regenerate_destroy'] = FALSE;

/**
* Cookie Related Variables
* 
* 'cookie_prefix' = Set a prefix if you need to avoid collisions
* 'cookie_domain' = Set to .your-domain.com for site-wide cookies
* 'cookie_path'   =  Typically will be a forward slash
* 'cookie_secure' =  Cookies will only be set if a secure HTTPS connection exists.
*/
$config['cookie_prefix']	= '';
$config['cookie_domain']	= '';
$config['cookie_path']		= '/';
$config['cookie_secure'] = TRUE;
$config['cookie_httponly'] = TRUE;

/*
|--------------------------------------------------------------------------
| Standardize newlines
|--------------------------------------------------------------------------
|
| Determines whether to standardize newline characters in input data,
| meaning to replace \r\n, \r, \n occurences with the PHP_EOL value.
|
| This is particularly useful for portability between UNIX-based OSes,
| (usually \n) and Windows (\r\n).
|
*/
$config['standardize_newlines'] = FALSE;

/**
* Global XSS Filtering
* 
* Determines whether the XSS filter is always active when GET, POST or
* COOKIE data is encountered
*
* @global boolean $config['global_xss_filtering']
*/
$config['global_xss_filtering'] = FALSE;

/**
* Cross Site Request Forgery
*--------------------------------------------------------------------------
* Enables a CSRF cookie token to be set. When set to TRUE, token will be
* checked on a submitted form. If you are accepting user data, it is strongly
* recommended CSRF protection be enabled.
*
* 'csrf_token_name' = The token name
* 'csrf_cookie_name' = The cookie name
* 'csrf_expire' = The number in seconds the token should expire.
*/
$config['csrf_protection'] = TRUE;
$config['csrf_token_name'] = 'dpii_api_token';
$config['csrf_cookie_name'] = 'dpii_api_token_cookie';
$config['csrf_expire'] = 300;
$config['csrf_regenerate'] = FALSE;
$config['csrf_exclude_uris'] = array();

/**
* Output Compression
* 
* Enables Gzip output compression for faster page loads.  When enabled,
* the output class will test whether your server supports Gzip.
* Even if it does, however, not all browsers support compression
* so enable only if you are reasonably sure your visitors can handle it.
*
* VERY IMPORTANT:  If you are getting a blank page when compression is enabled it
* means you are prematurely outputting something to your browser. It could
* even be a line of whitespace at the end of one of your scripts.  For
* compression to work, nothing can be sent before the output buffer is called
* by the output class.  Do not 'echo' any values with compression enabled.
*
* @global boolean $config['compress_output']
*/
$config['compress_output'] = FALSE;

/**
* Master Time Reference
* 
* Options are 'local' or 'gmt'.  This pref tells the system whether to use
* your server's local time as the master 'now' reference, or convert it to
* GMT.  See the 'date helper' page of the user guide for information
* regarding date handling.
*
* @global string $config['time_reference'] 
*/
$config['time_reference'] = 'local';


/**
* Rewrite PHP Short Tags
* 
* If your PHP installation does not have short tag support enabled CI
* can rewrite the tags on-the-fly, enabling you to utilize that syntax
* in your view files.  Options are TRUE or FALSE (boolean)
*
* @global boolean $config['rewrite_short_tags']
*/
$config['rewrite_short_tags'] = FALSE;


/**
* Reverse Proxy IPs
* 
* If your server is behind a reverse proxy, you must whitelist the proxy IP
* addresses from which CodeIgniter should trust the HTTP_X_FORWARDED_FOR
* header in order to properly identify the visitor's IP address.
* Comma-delimited, e.g. 'IP        ,IP        '
*
* @global string $config['rewrite_short_tags']
*/
$config['proxy_ips'] = '';
