<?PHP
/**
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

$CI = get_instance(); //the controller is not always available as $this, so we'll grab the controller via get_instance() instead

$show_adminpanel_link = $CI->has_permission('adminpanel');

?>

<div id="logout">
	<div class="optionbar_left">
		<div id="optionbar_menu">
			<span style="float: left; padding-right: 10px;"><a class="hidden_context hidden_link" id="skipNav" href="#menuContent">Skip Navigation</a></span>
		<?php if(string_begins_with(site_url('inbox'), current_url())): ?>
			<span class="selected optionbar_menu_item">Mailbox</span>
		<?php else: ?>
			<span class="optionbar_menu_item"><a href="<?php echo site_url('inbox') ?>">Mailbox</a></span>
		<?php endif ?>
		<?php if(string_begins_with(site_url('settings'), current_url())): ?>
			<span class="selected optionbar_menu_item">Settings</span>
		<?php else: ?>
			<span class="optionbar_menu_item"><a href="<?php echo site_url('settings') ?>">Settings</a></span>
		<?php endif ?>
			<span class="optionbar_menu_item">
				<a href="<?php echo site_url('feedback') ?>" onclick="return showFeedbackForm('<?php echo $CI->security->get_csrf_token_name() ?>','<?php echo $CI->security->get_csrf_hash() ?>');">Feedback</a>
			</span>
			
			<?PHP 				
				//reports link
				if(strpos($_SERVER['REQUEST_URI'],'reports') === FALSE || strpos($_SERVER['REQUEST_URI'],'adminpanel') !== FALSE) {
					echo '<span class="optionbar_menu_item"><a href="' .  base_url() .'reports/get_mailbox_activities">Reports</a></span>';
				}
				else { echo '<span class="selected optionbar_menu_item">Reports</span>'; }
				
				//Show Global Address book and personal address book on any inbox controller only

				if(!string_begins_with(site_url('inbox/compose'), current_url())){
					echo '<span class="optionbar_menu_item"><a href="javascript:getGlobalAddressBook();">Global Address Book</a></span>';
					echo '<span class="optionbar_menu_item"><a href="javascript:getPersonalAddressBook();">Personal Contacts List</a></span>';
				}else {
					echo '<span class="optionbar_menu_item"><a href="#" class="address-book">Global Address Book</a></span>';
					echo '<span class="optionbar_menu_item"><a href="#" class= "contact-list">Personal Contacts List</a></span>';
				}

				
				//admin panel link
				if($show_adminpanel_link) {
					if(strpos($_SERVER['REQUEST_URI'],'adminpanel') === FALSE) {
						echo '<span class="optionbar_menu_item"><a href="/adminpanel">Admin Panel</a></span>';
					}
					else { echo '<span class="selected optionbar_menu_item">Admin Panel</span>'; }
				}
			?>
		</div>
	</div>
	<div class="optionbar_right">
	<?php if(!empty($CI->session->userdata('mailbox_group')) && !empty($this->user->mailbox_names())): //only show the mailbox list if the user has options to choose from ?>
		<div style="padding-right: 10px; display: inline-block;">
			<span style="padding-right: 10px; position: relative; top: -5px;">Mailbox Group:</span>
			<div class="mailbox_select toplevel">
				<a href="#"><span class="mailbox_name" title="<?php echo html_escape($CI->session->userdata('mailbox_group')) ?>"><?php echo html_escape($CI->session->userdata('mailbox_group')) ?></span><span class="mailbox_select_icon">&#9660;</span></a>
				<div class="mailbox_select list">
					<ul>
					<?php foreach($CI->user->mailbox_names as $group => $group_cn): ?>
						<?php if($group == $CI->session->userdata('mailbox_group')) continue; ?>
						<li><a href="/inbox/change_mailbox_group/<?php echo rawurlencode($group) ?>"><?php echo html_escape($group_cn) ?></a></li>
					<?php endforeach ?>
					</ul> 
				</div>
			</div>
		</div>
	<?php endif ?>
	<span style="float: right;">Logged in as <strong>
	<?PHP
		if(!empty($this->user->cn()))
			echo html_escape($CI->user->cn);
		else
			echo html_escape($CI->user->username);

		echo "</strong> | <a href=\"" . base_url() . "auth/logout" . "\">Logout</a>";
	?>
	</span>
	</div>
</div>
<a id="permission_url" href="" style="display: none;"></a>