<?php
/**
* Markup to view any message that is not a draft.
*
* Note that this view is intended to be used within the larger context of inbox/{@link template.php}, in conjunction with the
* {@link _view_menu} partial.
*
* <code>
* $this->template->set('menu_partial', '_view_menu');
* $this->template->load('template', 'inbox/view', $data);
* </code>
*
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/

$CI = get_instance();

//	sent messages include icons to indicate delivery status; let's format them before we display the markup to keep the markup as clear as possible
//	this will result in a $to and a $cc address

foreach(array('to', 'cc') as $recipient_type) {
	if (!$message->sent) {
		$$recipient_type = array_map('htmlentities', $message->addresses_for_display($recipient_type));
	} else {
		$$recipient_type = array();
		foreach ($message->addresses_for_display($recipient_type) as $address) {
			$markup = '<a style="text-decoration:none; color:#000000">' . htmlentities($address) . ' </a>'; //why are we putting the address in an <a>?
			$markup .= '<img src="/images/email_icons/' . make_string_css_friendly($message->delivery_status($address)) . '.png" title="' . $message->delivery_status($address) . '" alt="'.$message->delivery_status($address).' Icon">';
			array_push($$recipient_type, $markup); //wouldn't normally use array_push, but php doesn't seem to like [] with $$ syntax
		}
	}
}

$security_token = $this->security->get_csrf_token_name().'='.$this->security->get_csrf_hash();

?>
<input style="display:none;" id="current_user" value="<?php if (isset($status_enabled)) { echo $user->id; }?>"/>
<input style="display:none;" id="display_name" value="<?php if (isset($status_enabled)) { echo $user->cn; }?>"/>
<div id="msg_header">
	<div class="subject" title="<?php echo $message->subject_for_display(); ?>">
		<?php if(isset($status_enabled) && $status_enabled) echo $this->load->view('inbox/_assignment_link', compact('user', 'message', 'workflow_item'), TRUE); ?>
		<?php echo $message->subject_for_display(); ?>
		<?php if($message->importance != 'normal'): ?>
			<br />
			<span class="msg_priority">This message was sent with <?php echo ucfirst($message->importance) ?> importance.</span>
		<?php endif ?>
	</div>
	<div id="msg_subheader">
		<div class="date"><?php echo $message->timestamp_for_display() ?></div>
		<div class="addresses">
			<div class="address-item"><strong>From</strong>: <?php echo implode(', ', array_map('htmlentities', $message->addresses_for_display('sender'))); ?></div>
				<div class="address-item"><strong>To</strong>: <?php if($to == array(ALL_USERS_MOCK_ADDRESS)) echo 'All VA Direct Users'; else echo implode(', ',  $to); ?></div>
				<?php if(!$message->property_is_empty('cc')): ?>
					<div class="address-item"><strong>CC</strong>: <?php echo implode(', ',  $cc) ?></div>
				<?php endif ?>
			</div>

			<?php if($message->has_attachments()): ?>
			<div class="attachments">
				<strong>Attachments</strong>: <br />
				<input type="hidden" name="msg_id" value="<?php echo $message->id ?>" />
				<table id="attachments-list">
				  <tbody>
						<tr>
						<?php $i = 0; foreach($message->attachment_files as $attachment): ?>
							<td class="<?php echo $attachment->extension ?> <?php if($attachment->property_exists('schema')) echo $attachment->schema ?>"
								<?php if(is_a($attachment, 'Patient_document_attachment')):?>style="width: 20%;"<?php endif ?>>
							<?php if($attachment->property_exists('child_patient_documents') && !$attachment->property_is_empty('child_patient_documents')): ?>
								<a href="#" class="zip-expand-icon zip-name expanded" data-attachment-index="<?php echo $i;?>"><?php echo $attachment->name;?></a>
								<a href="#" title="Click to collapse clinical document content from zip archive" class="zip-expand-icon expanded" data-attachment-index="<?php echo $i;?>">&#x25BC;</a>
							<?php else: ?>
								<?php echo $attachment->link(); ?>
							<?php endif ?>
								(<?php echo byte_format($attachment->bytes); ?>)
							<?php if(is_a($attachment, 'Zip_attachment')): ?>
								(<?php echo $attachment->link('Download');?>)
							<?php endif ?>
						<?php if(is_a($attachment, 'Patient_document_attachment')): //note that we shouldn't be adding additional columns without making colspan adjustments.  refactor later - grids would probably be better ?>
							<td class="no" style="width: 50px;">
								<?php echo $CI->load->view('inbox/message/_patient_document_menu', compact('attachment', 'i'), TRUE) ?>
							</td>
							<td class="no info"><?php echo $this->load->view('inbox/message/_patient_preview', compact('attachment'), TRUE) ?></td>
							<td class="no">
								<span class="c32name">(<?php echo $attachment->description ?>)</span>
						<?php endif ?>
						<?php if($attachment->property_exists('child_patient_documents') && !$attachment->property_is_empty('child_patient_documents')): ?>
							<ul id="zip_contents<?php echo $i; ?>" class="zip-file-list">
							<?php foreach($attachment->child_patient_documents as $key => $child_patient_document): ?>
								<li class="<?php echo $child_patient_document->extension; ?>">
									<?php echo $child_patient_document->link(null, array('data-zip-name' => $attachment->name, 'data-zip-index' => $child_patient_document->index_in_parent)); ?>
									<?php echo $CI->load->view('inbox/message/_patient_document_menu', array('attachment' => $child_patient_document, 'i' => $i), TRUE) ?>
									<?php //echo $CI->load->view('inbox/message/_patient_preview', array('attachment' => $child_patient_document), TRUE) //todo - CSS needs to be fixed so that this works ?>
									<span class="c32name"> (<?php echo $child_patient_document->description?>)</span>
								</li>
							<?php endforeach ?>
							</ul>
						<?php endif ?>
                                                <?php if (!is_a($attachment, 'Patient_document_attachment') && is_a($attachment, 'Image_attachment')) { ?>
 								<?php echo $CI->load->view('inbox/message/_image_attachment_menu', compact('attachment', 'i'), TRUE) ?>
							
                                                <?php } ?>
						</td>
					</tr>
				<?php $i++; ?>
				<?php endforeach ?>
				</tbody>
			</table>
		</div>
	<?php endif ?>
	</div>
</div>
<div id="msg_body"><?php echo $message->body_for_display ?></div>
<script>
	$(function () {
		$('[data-toggle="popover"]').popover()
		
		$('#msg_body a').each(function(){
		    var target = $(this).attr('target'); 
		    if (!target) { 
			$(this).attr('target','_blank'); 
		    }
		}); 
	})
</script>