<?php
/**
* Markup for notification emails when a user submits feedback.  We are purposely not including the username or the feedback in this email to avoid including any PII/PHI in this email.
*
* If making changes, please consult the resources below to take a look at HTML/CSS compatibility in email.
*
* @see http://www.pinpointe.com/blog/email-campaign-html-and-css-support
* @see https://www.campaignmonitor.com/css/
*
* @author M. Gibbs <gibbs_margaret@bah.com>
*
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

?>
<style>
p {font-family: Helvetica, 'Helvetica Neue', Arial, san-serif; color: #222;);}
a {text-decoration: none; color: #005daa;}
a:hover {text-decoration: underline; color: #005daa;}
</style>

<p>A user has submitted <?php echo (($type == 'Issue Report') ? 'an issue report for' : 'feedback about') ?> the <?php echo link_to(site_url(), 'VA Direct Project') ?>.  You can see this submission and other feedback on the <?php echo link_to('adminpanel/logs/feedback', 'Feedback Log') ?>.  Please take a look at your earliest convenience.</p>

<p>Thanks,<br />
<?php echo EMAIL_SIGNATURE ?></p>
<br />
<hr />
<p><font size="2" color="#999">You received this notification because you are an administrator for <?php echo link_to(site_url(), 'VA Direct Secure Messaging') ?>.  If you believe that you should no longer be part of this list, please contact the VA Direct Leadership.</font></p>