<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage models
*/

require_models('database_model', 'user');

/**
* DEPRECATED. Use the User model for new code.
* @package direct-project-innovation-initiative
* @subpackage models
*/
class User_model extends Database_model {
	protected $primary_key = 'user_id';
	protected $_logged_in_user;
	
	//////////////////////////////////////////
	// METHODS CONCERNING THE LOGGED IN USER
	//////////////////////////////////////////
	
	public function logged_in_user($field = null){	
		if(!isset($this->_logged_in_user)){
			$user = User::find_from_session();
			if(!User::is_an_entity($user))
				$this->_logged_in_user = array();
			else{
				$this->_logged_in_user = $user->values();
				$this->_logged_in_user['dn'] = $user->dn();
			}
		}
				
		if(is_null($field))
			return $this->_logged_in_user;
		if(!array_key_exists($field, $this->_logged_in_user)) return $this->error->should_be_a_recognized_user_property($field);
		return $this->_logged_in_user[$field];		
	}
	
	////////////////////////////////////////
	// METHODS CONCERNING ALL USERS
	////////////////////////////////////////
	
	//note - if you're going to need more info than just the username, it's more efficient to just get the user object and get the info from it
	//that way, we can just do one db lookup at a timed	
	public function user_cn_from_id($id) {
		if(!$this->is->nonzero_unsigned_integer($id)) return $this->error->should_be_a_nonzero_unsigned_int($id);
		
		//check to see if the id is for the current logged-in user, so we can skip looking up the user
		$CI = get_instance();
		if(User::is_an_entity($CI->user) && $CI->user->id == $id) return $this->user->cn;
		
		$user = User::find_one($id);
		if(User::is_an_entity($user))
			return $user->cn;
		return FALSE;
	}
	
}
