<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage models
*/

/** */
require_model('api_entity');

#TODO - COUNT WON'T CURRENTLY WORK (THERE'S NO COUNT RESOURCE, SO WE'LL NEED TO JUST

/**
* Manages data for the user record saved in DAAS, as opposed to the user record stored here in webmail
* @package direct-project-innovation-initiative
* @subpackage models
*/
class API_user extends API_entity {

#	static $create_resource = '/direct/folders/create';
#	static $delete_resource = '/direct/folders/archive';
	static $find_resource = '/direct/account';
	static $find_one_resource = '/direct/account';
	static $update_resource = '/direct/account/update';

	protected $field_names_to_ldap_attributes = array('first_name' => 'givenName',
													  'middle_name' => 'initials',
													  'last_name' => 'sn',
													  'job_title' => 'title', 
													  'department' => 'departmentnumber',
													  'organization' => 'o',
													  'telephone' => 'telephonenumber',
													  'mobile' => 'mobile',
													  'location' => 'physicaldeliveryofficename');



													  

	public function values_for_ldap(){
		$values_for_ldap = array('cn' => implode_nonempty(' ', array($this->first_name, $this->last_name)),
								 'displayName' => implode_nonempty(', ', array($this->last_name, implode_nonempty(' ', array($this->first_name, $this->middle_name)))));
		
		foreach($this->field_names_to_ldap_attributes as $field_name => $ldap_attribute){
			$values_for_ldap[$ldap_attribute] = $this->$field_name;
		}	
		
		return $values_for_ldap;	
	}												  


/////////////////////////
// STATIC
/////////////////////////	
	
	//overrides parent because we don't have a count resource for folders	
    public static function count($id_or_conditions = array()){
		return count(static::find($id_or_conditions));
    }
	
	public static function fields(){
		return array('mailbox', 'first_name', 'middle_name', 'last_name', 'job_title', 'department', 'organization', 'telephone', 'mobile', 'external_email', 'location', 'facility_id');  
    }	
	
	public static function find_for_home_facility($id_or_conditions = array(), $key_by = null){
		return API_user_for_home_facility::find($id_or_conditions, $key_by);
	}
	
	public static function register_organization_id($organization_id){
		$CI = get_instance();
		if(!$CI->api->call('/authorize/register', array('unique' => $organization_id))){
			return $CI->error->warning('Unable to reach API to check if an account is pending for organization id '.$CI->error->describe($organization_id));
		}
		
		$status = element('status', $CI->api->output_as_array());
		if($status != 'Pending'){
			return $CI->error->warning('Unable to register organization id '.$CI->error->describe($organization_id).': status is '.$CI->error->describe($status));
		}
		
		return true;
	}	
	
	protected static function _results_from_api_output(){
		$output = parent::_results_from_api_output();
		$output['username'] = $output['mailbox'];
		unset($output['request_id'], $output['mailbox'], $output['facilities']);
		
		return array($output['id'] => $output);
	} 
	
	protected static function _conditions_for_find($id_or_conditions){
		$conditions = parent::_conditions_for_find($id_or_conditions);
		$CI = get_instance();
		
		//make sure we have a mailbox - assume that it's the current mailbox if not otherwise specified
		if(!array_key_exists('mailbox', $conditions) && isset($CI->user)){
			$conditions['mailbox'] = $CI->user->user_name;
		}
		return $conditions;	
	}			
			
}


class API_user_for_home_facility extends API_entity {
	static $find_resource = '/direct/account/in_facility';
	static $find_one_resource = '/direct/account/in_facility';
}
