<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*//** */

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class DPII_CCD extends CCD{

	
	public function __construct($xml_string){
		$this->values_to_parse['patient_icn']['default_value']='&ndash;';
		$this->values_to_parse['organization']['xpath_query']['default_value'] = '&ndash;';
		parent::__construct($xml_string);
	}
	
	function date_of_birth(){
		if(empty($this->raw_value('date_of_birth')) || strlen($this->raw_value('date_of_birth')) == 8) return 'Unknown';
		return $this->human_readable_date($this->raw_value('date_of_birth'));
	}
	
	/** 
	* How we'll describe this document throughout webmail
	*/
	function description(){
		$patient_name = $this->patient_name();
		$description = $this->title();
		if(!empty($patient_name)) $description .= ' for '.$patient_name;
		if(!empty($this->raw_value('organization'))){
			$description .= ' from '.$this->organization;
			$description = strip_from_beginning($this->organization, $description); //Title sometimes starts with the organization - we don't need the redundancy
		}
		
		return $description;
	}

	
}
?>