<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/ /** */

require_once('Mail/RFC822.php');

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class Mailformat {

///Note to developers -- Do not add new methods to this library.  Methods having to do with formatting message data should go on the Message model (or, if they're more general than just our messages, add them to an appropriate helper).  Methods relating to folders should go on the folder model or the mailbox model as appropriate.  If you need to add a new method and are not sure of an appropriate place for it, talk to Margaret or Adam.  -- MG 2014-11-17


	protected $CI;
	protected $is_multiple_folder_search;
	public function __construct(){
		$this->CI =& get_instance();
	}


	
//CODE REVIEW NOTES: By the time you have this much markup in a method, it's time to separate it out into a view.  For a small, contained snippet of markup like this that may be used multiple times on a page, put an underscore at the start of the view name to indicate to other developers that it's not a view for a full page.  When you call it, use the optional third parameter for loading a view that returns the markup as a string for better portability. --MG 2014/11/17
	public function mailbox_list($is_multiple_folder_search = FALSE) {
		$this->is_multiple_folder_search = $is_multiple_folder_search;
		
		$mailbox = Mailbox::find_from_session();	
		if(!Mailbox::is_an_entity($mailbox)) $this->CI->error->warning('Could not find mailbox from session');
		
		$session_folder = Folder::find_from_session();	
		if(!Folder::is_an_entity($session_folder)) return $this->CI->error->warning('Could not find folder from session');
		
		$_SESSION['unseen'] = $session_folder->new;
		$_SESSION['folder_name'] = $session_folder->name_for_display();
	
		$markup = $this->CI->load->view('inbox/folders/_menu', array('is_multiple_folder_search' => $is_multiple_folder_search), TRUE);

		return array('folder_list' => $markup, 
				'folders' => $mailbox->folders);
	
	}
	
	
	/* Function designed to strip out repetitive RE's and FWD's from a message subject. Will also replace the most recent RE or FWD
     * with FWD or RE (respectively) if necessary; e.g., forwarding the following message 
	 * RE: Some Subject Here 
	 
	 * ...will instead result in
	 * FWD: Some Subject Here
	*/
	public function msg_subject_sanitize($msg_subject,$type){
		$new_subject = $msg_subject;
		//detect if this is the subject that is already a reply or forward
		$multiple_replies = 	(substr($msg_subject,0,3) == 'RE:') || (substr($msg_subject,0,3) == 'Re:') || 
								(substr($msg_subject,0,2) == 'Fw') || (substr($msg_subject,0,2) == 'FW');
								
		//Conditional offset to handle if there is a Re:/Fwd: of some sort already in the subject
		$offset=((substr($msg_subject,0,4) == 'FWD:') || (substr($msg_subject,0,4) == 'Fwd:')) ? 4 : ($multiple_replies? 3: 0);
		
		//remove previous Re: / Fwd: then add ours
		if($type == 'reply' || $type == 'replyall') { $new_subject = 'Re: '. trim(substr($msg_subject,$offset)); }
		else if($type == 'forward') { $new_subject = 'Fwd: ' . trim(substr($msg_subject,$offset)); }
		else { return $msg_subject; } //just return original subject if not a reply or forward
		
		return $new_subject;
	}
	
	public function display_address_for_send($address){
		if(!is_string($address)) return $this->error->should_be_a_string($address);
		if(empty($address)) return '';
		
		if(string_begins_with('(', $address))
			$address = "\"" . str_replace(" (","\" <",$address); 
		else 
			$address = str_replace("(","<",$address); 
		
		return str_replace(")",">",$address);
	}
	
	public function format_display_addresses_for_sending($addresses) {
		return array_map( array($this, 'display_address_for_send'), $addresses);
	}
	
	public function format_address_list_for_display($addresses) {
		if(!is_null($addresses) && !is_string($addresses)) return $this->CI->error->should_be_a_string($addresses);
		if(empty(trim($addresses))) return array();
				
		$formatted_addresses = array();
		foreach(Mail_RFC822::parseAddressList($addresses) as $address) {
			if(!empty($address->host) && $address->host == "MISSING_DOMAIN") unset($address->host);
			
			if(!empty($address->personal) && !empty($address->mailbox) && !empty($address->host)){ 
				$formatted_addresses[] = $address->personal . " (" . $address->mailbox . "@" . $address->host . ")";
			}elseif(!empty($address->mailbox) && !empty($address->host)){
				$formatted_addresses[] = $address->mailbox . "@" . $address->host;
			}elseif(!empty($address->personal)){ 
				return array($address->personal); 
			}elseif(!empty($address->mailbox)){
				return array($address->mailbox); 
			}elseif(!empty($address->host)){
				return array($address->host); 
			}
		}
		return $formatted_addresses;
	}

}
?>