<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/ /** */

require_once APPPATH.'controllers/inbox.php';
require_once 'Mail/mimeDecode.php';

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Attachment_controller extends Inbox {

	var $max_attachment_size_in_bytes;
	
	function __construct(){
		parent::__construct();
		$this->max_attachment_size_in_bytes =  MAX_ATTACHMENTS_SIZE_IN_BYTES;	
	}


	/**
	* Generates a description for a document currently in the user's attachment cache.
	* Attachments which do not have descriptions (currently everything that isn't a CCD) will get an empty response.
	*/
    public function ajax_attachment_description($filename) {
		$filename = urldecode($filename);

		if(empty($filename) || !$this->is->string_like_a_file_path($filename)) return false;
		if(!$this->user->file_name_exists_in_attachment_cache($filename)) return false;

		$attachment = $this->user->attachment_from_cache($filename);
		if(!$attachment->property_exists('description') || $attachment->property_is_empty('description')) return false;
		echo preg_replace("/[\n\r]/", '', $attachment->description);
    }

	//attaches a single file
    function attach() {
		if(!IS_AJAX) show_404();
		$message_id = $this->input->post('msg_id');

		if(ENABLE_FILE_TRANSFERS && $_FILES['attach']['size'] > $this->max_attachment_size_in_bytes)
			return $this->ajax_add_file_transfer($message_id);
			
		//this seems weird.  is this really right?   -- MG 2014-04-17
		if(empty($_FILES) && empty($_POST) && strtolower(element('REQUEST_METHOD', $_SERVER)) == 'post')
			return $this->show_attachment_error('Unable to upload '.$filename.'; adding this file would exceed the maximum size limit for attachments', 413);

		if(!isset($_FILES['attach'])) show_404(); //preserving the orginal code, but this seems like a strange response.  wouldn't it be more consistent to do a bad request response?  -- MG 2014-04-17

		//make sure we have a file to attach
		$filename = element('name', element('attach', $_FILES, array()));
		if(empty($filename)) return $this->show_attachment_error('Bad Request', 400);
		if(!Message::attachment_has_valid_extension($filename)) return $this->show_attachment_error('Invalid file type', 400);

#TODO - THIS WOULD BE AN EXCELLENT PLACE TO RENAME THE FILE IF IT EXISTS IN THE CACHE ALREADY

		//first, make sure we have a cache - we won't if this is the first attachment for this message
		if(!directory_exists($this->user->attachment_cache())) mkdir($this->user->attachment_cache()); //attempt to create the cache if needed
		if(!directory_exists($this->user->attachment_cache())) return $this->error->warning('Could not create an attachment cache for '.$this->user->describe().' at '.$this->user->attachment_cache());

		//check to make sure that we don't already have a file with this name in the cache - change the name if needed
		$existing_filenames = get_filenames($this->user->attachment_cache());
		$extension = substr($filename, strpos($filename, '.'));
		$filename = strip_from_end($extension, $filename); //temporarily remove the extension from the filename so that we can add the numbers

		//if we have duplicate file names, make them unique by adding a number (#) to each one
		for($i = 1; in_array($filename.$extension, $existing_filenames); $i++){
			//make sure to clear out any parentheses that we've added.  Note that we'll have to do this even for things we didn't add so that we don't mess things up while re-saving.
			if(preg_match('/\(\d+\)$/', $filename, $matches)) {
				$filename = trim(strip_from_end(first_element($matches), $filename)); //clear out any numbers that we've added already
			}
			$filename = $filename.' ('.$i.')';
		}
		$filename = $filename.$extension;

		//before we try to add the file to the cache, check if the filename is too long.
		$string_filename = strip_from_end($extension, $filename);
 		if (mb_strlen($string_filename) > 160){
 			return $this->show_attachment_error('Too many characters in the filename, please rename file. '.$string_filename, 400);
 		}

 		//add the file to the cache if possible
		$success = move_uploaded_file($_FILES['attach']['tmp_name'], $this->user->attachment_cache().'/'.$filename);
		if(!$success) return $this->show_attachment_error('Unable to upload file '.$filename, 400);

		//check the current size of the cache
		if($this->user->attachment_cache_size_in_bytes() >  MAX_ATTACHMENTS_SIZE_IN_BYTES) {
			$this->clear_attachment($filename);
			return $this->show_attachment_error('Unable to upload '.$filename.'; adding this file would exceed the maximum size limit for attachments', 413);
		}

		$attachment = $this->user->attachment_from_cache($filename);

		$type = 'attachments';
		$filesize = $attachment->bytes();
		$token = $this->security->get_csrf_hash();
		$success_message = json_encode(array_merge(compact('type', 'token', 'filename', 'filesize'), array('markup' => $this->load->view('inbox/compose/_attachment', compact('attachment'), TRUE))));

		if(IS_AJAX)
			echo $success_message;
		else
			echo '<textarea status="200">'.$success_message.'</textarea>';

    }

	public function clear_attachment($filename) {
		$filename = html_entity_decode(rawurldecode($filename));
		$attachment = $this->user->attachment_from_cache($filename);
		
		if(!is_a($attachment, 'Attachment')){
			//log error instead of triggering php error so that we don't mess with AJAX functionality on dev
			log_message('error', 'Unable to remove attachment - there is no file named '.$this->error->describe($filename).' in the attachment cache'); 
			return true; //return true because this attachent isn't here, so it's as though it were removed
		}
		
		if(!$this->user->remove_attachment_from_cache($filename))
			show_error('Failed to remove attachment '.$filename.' due to internal error.', 500);
		
		return true;
    }

	public function download($filename, $message_id = null, $zip_index = null){
		$this->output->enable_profiler(false);
		$attachment = $this->find_attachment_or_redirect($filename, $message_id, $zip_index);
		$attachment->download();
	}

	public function download_as($file_type, $filename, $message_id = NULL, $zip_index = NULL){
		if(intval($message_id) === 0) { $message_id = null; }
		$this->output->enable_profiler(false);
		$attachment = $this->find_attachment_or_redirect($filename, $message_id, $zip_index);
		$method_name = 'download_as_'.$file_type;
		if(method_exists($attachment, $method_name))
			return $attachment->$method_name();

		$this->error->warning(get_class($attachment).' does not have a method called '.$method_name);
		$attachment->download();
	}

	public function view($filename, $message_id = null, $zip_index = null){
		$this->output->enable_profiler(false);
		$attachment = $this->find_attachment_or_redirect($filename, $message_id, $zip_index);
		if(method_exists($attachment, 'view')){
			return $attachment->view();
		}
		$attachment->download();
	}

	public function view_inline($filename, $message_id = null, $zip_index = NULL){
		$this->output->enable_profiler(false);
		$attachment = $this->find_attachment_or_redirect($filename, $message_id, $zip_index);
		if(method_exists($attachment, 'view_inline')){
			return $attachment->view_inline();
		}
		$this->view($filename, $message_id);
	}



    /* This function takes an image attachment stored in session and loads a view that will display it */
#TODO - rename this using actual words
    public function imgdisp($id, $filename, $inline = NULL) {
		if(!$inline) return $this->view($filename, $id);

		#TODO - WE REALLY NEED SOME VALIDATION AS TO WHAT THE $inline VALUE COULD BE - IS THIS A SECURITY RISK?

		//this could should only be called when there is a single inline image taking up the entire body of the message
		//and there is no parts array, a condition that only seems to happen when an image is sent in apple mail
		//inline with no text also included
		$attachment = $this->find_attachment_or_redirect($filename, $id);
		header('Content-Type: image/'.$inline); //set content type in headers
		header('Content-Disposition: attachment; filename="' . $attachment->name . '"');
		echo base64_decode($message->body);
    }

	/** Displays the form to submit patient id for attaching clinical documents*/
	public function patient_id_form($message_id,$header=null){
		if(!is_null($message_id) && !Message::formatted_like_an_id($message_id)) show_404();

		//make sure that the message id is valid
		$message = Message::find_one($message_id);
		if(!Message::is_an_entity($message) ) show_404();

                if (empty($header)) { 
                    $header = 'Attach a VA Continuity of Care Document';
                }
		$this->template->set('header', rawurldecode($header));

		//set up the form generator so that we can validate existing data or provide the form to populate new data
		require_library('form_markup_generator');
		$markup_generator = new Form_markup_generator();
		$markup_generator->set_fields( array('given_name' => array('type' => 'text_input', 'required' => true),
											 'family_name' => array('type' => 'text_input', 'required' => true),
											 'social_security_number' => array('type' => 'social_security_number', 'required' => true),
											 'gender' => array('type' => 'dropdown', 'options' => array('' => '', 'M' => 'Male', 'F' => 'Female', 'Medically Undifferentiated')),
											 'date_of_birth' => array('type' => 'date')
									  ));
		$markup_generator->field('date_of_birth')->field('year')->maximum = date('Y'); //no future dates are allowed for birthdays

		$markup = '';
		if(!empty($_POST)){
			$markup_generator->set_values_from_post();
			if(!$markup_generator->validates()){
				$this->template->set('danger_message', '<strong>We need you to make a few changes to this form.</strong> '.ul_if_multiple($markup_generator->validation_messages));
			}elseif(!array_key_exists('refine_search_terms', $_POST)){

				//if we have a patients field, then we're reloading the patient confirmation form and can skip the patient lookup
				if(array_key_exists('patients', $_POST)){
					if(!empty($_POST['patient_id'])){ //if we've established the patient id, we're done!
						require_library('patient_data/patient_id');
						$patient = new Patient(element($this->input->post('patient_id'), $this->input->post('patients')));

						if($message->attach_ccd_for_patient($patient)){
#							$this->session->set_success_message("Success! We've attached the VA CCD for ".$patient->full_name().' (ICN #'.$patient->icn());
							$redirect_location = 'inbox/compose/draft/'.$message_id;

							//for ajax, set the success message, close the window && redirect -- (todo: give the option of looking up another patient)
							if(!IS_AJAX) redirect($redirect_location);

							//we should be able to do some sort of explicit fancybox close or just $('#fancybox-close').click();, but it's causing js errors and weird ghosting while saving.
							//so for now, we'll just plan on removing all the fancybox divs
							echo '<script>$("#save_btn").click();$("[id^=fancybox]").remove();</script>';

							//clear the existing values so that we have an empty field for the user look up a new patient
/*							foreach($markup_generator->field_names as $field_name){
								$markup_generator->field($field_name)->clear_value();
							}

							$feedback = '<strong>Success!</strong> We\'ve attached the VA Continuity of Care Document for '.$patient->full_name().' (ICN #'.$patient->icn().'). ';
							$feedback .= 'You can look up another patient, or <a href="#" onclick="$(\'#fancybox-close\').click(); return false;">return to your draft</a>.';

							$this->template->set('success_message', $feedback);
							$this->template->load('form_dialog_template.php', 'inbox/patient_data/_lookup_form', compact('markup_generator')); */
							return true; //whether ajax or non-ajax, we're done - save was successful
						}

						$error_message = '<strong>The system encountered an error.</strong> We were unable to find and attach the VA CCD for '.$patient->full_name().'. ';
						$error_message .= implode_nonempty(' ', $this->document_retrieve->feedback_messages());
						$this->template->set('danger_message',$error_message);
					}

					return $this->patient_confirmation_form($message, $this->input->post('patients'), array_intersect_key($_POST, $markup_generator->fields));
				}

				//otherwise, find patients that match the search criteria
				$this->load->library('patient_data/patient_id');
				$patients = $this->patient_id->patients_matching_criteria($markup_generator->values);

				if(!is_array($patients)){ //if we encounter an error, set a feedback message and display the usual form
					if(!empty($this->patient_id->feedback_messages()))
						$this->template->set('danger_message', implode_nonempty(' ', $this->patient_id->feedback_messages()));
					else
						$this->template->set('danger_message', '<strong>An error was encountered.</strong> We were unable to search for patients at this time.  Please try again in a moment, and contact an administrator if the problem persists.');
				}elseif(empty($patients)){ //if no patients were found, set a feedback message and display the usual form
					$this->template->set('warning_message', '<strong>No patients found.</strong> We were unable to find any patients matching the criteria below.  Please provide additional traits and try again.');
				}else{
					return $this->patient_confirmation_form($message, $patients, array_intersect_key($_POST, $markup_generator->fields));
				}
			}
		}
		$this->template->load('form_dialog_template.php', 'inbox/patient_data/_lookup_form', compact('markup_generator'));
	}

	public function save_to_das($message_id, $filename, $zip_index = null) {
		$attachment = $this->find_attachment_or_redirect($filename, $message_id, $zip_index);
		if(!is_a($attachment, 'Patient_document_attachment') || $attachment->schema == 'CCR') show_404();

		if($attachment->save_to_das()){
			$this->session->set_success_message('Success! The attachment has been saved to DAS.');
		}else{
			$this->session->set_error_message($attachment->das_user_friendly_error_message);			
		}
			
		redirect('inbox/viewmsg/'.$message_id);
	}
	
////////////////////////////////////
// FILE TRANSFERS
//////////////////////////////////

	//currently in progress - needs more work before it can be used -- MG 2016-08-17
	public function ajax_add_file_transfer($message_id){
		if(!ENABLE_FILE_TRANSFERS) show_404();
		if(!IS_AJAX) show_404();
		
		//Make sure the message really exists
		if(!Message::formatted_like_an_id($message_id)){
			$this->error->should_be_a_message_id($message_id);
			show_404();
		}

		// get current user API info
		//todo - we should consider just storing the api user id instead - could be a column on the db
		$api_user = API_user::find_one(array('mailbox' => $this->user->user_name));
		if(!API_user::is_an_entity($api_user)){
			$this->error->warning('Could not find the api user for '.$this->user->describe());
			show_error('The file transfer could not be uploaded', 401);
		}
		
		// get file_transfer content
		if(!is_uploaded_file($_FILES['attach']['tmp_name'])){
			$this->error->warning('Unable to find file transfer to add for message#'.$message_id);
			show_error('The file could not be uploaded', 400);
		}
		
		if($_FILES['attach']['size'] > MAX_FILE_TRANSFER_SIZE_IN_BYTES)
			show_error('The file is too large to be uploaded', 413);
			
		ini_set('memory_limit', '1024M'); 
		ini_set('max_execution_time', '1200');
		
		$values = array(   'message_id' => $message_id,
						   'name' => $_FILES['attach']['name'],
						   'content' => file_get_contents($_FILES['attach']['tmp_name']),
						   'type' => $_FILES['attach']['type'],
						   'created_by' => $api_user->id,
						   'mailbox' => $this->mailbox->name,
					  );

		session_write_close(); //because we don't need to write to the session anymore and this could take a while - see CI session concurrency docs

		//make the call 
		$this->api->clear();
		$this->api->files_to_send[] = array('filename' => $_FILES['attach']['name'], 'binary_string' => file_get_contents($_FILES['attach']['tmp_name']));
		if(!$this->api->call('/direct/file_transfer/create', 
									  array('message_id' => $message_id,
									 	   'name' => $_FILES['attach']['name'],
									       'type' => $_FILES['attach']['type'],
									       'created_by' => $api_user->id,
									       'mailbox' => $this->mailbox->name), 
									  'POST')){
			show_error('The file could not be uploaded', 500);
		}
		
		$file_transfer = element('file_transfer', $this->api->output_as_array());
		$id = $file_transfer['id'];
		$token = $this->security->get_csrf_hash();
		$type = 'file-transfers';
		
		echo json_encode(array_merge(compact('token', 'type', 'file_transfer'), array('markup' => $this->load->view('inbox/compose/_file_transfer', compact('file_transfer', 'id'), TRUE))));
	}
	
	public function ajax_remove_file_transfer($file_transfer_id){
		if(!ENABLE_FILE_TRANSFERS) show_404();
		if(!IS_AJAX) show_404();
		
		if(IS_AJAX) ini_set('display_errors', 0);  //don't display errors while we're in the API -- just write them to the log
		
		$file_transfer_id = html_entity_decode(rawurldecode($file_transfer_id));
		$this->api->clear();
		if(!$this->api->call('/direct/file_transfer/delete', array('id' => $file_transfer_id, 'user' => $this->user->user_name, 'mailbox' => $this->mailbox->name,), 'DELETE')){
			$this->error->warning('An error was encountered and file_transfer#'.$file_transfer_id.' could not be removed using url '.current_url());
			show_error('An error was encountered and the file transfer could not be removed', 500);
		}

		return true;
	}


/////////////////////////////////////////////////////////////
// PROTECTED
/////////////////////////////////////////////////////////////

	protected function find_attachment_or_redirect($filename, $message_id = NULL, $zip_index = NULL){
		$filename = html_entity_decode(rawurldecode($filename));

		if(!$this->is->string_like_a_file_path($filename)) show_404();
		if(!is_null($message_id) && !Message::formatted_like_an_id($message_id)) show_404();		
		if(!is_null($zip_index) && !$this->is->integer($zip_index)) show_404();

		//if the attachment has been saved to the message, grab it from the message
		if(Message::formatted_like_an_id($message_id)){
			$message = Message::find_one($message_id);
			if(!Message::is_an_entity($message)) show_404(); //make sure the message really exists
			$attachment = element($filename, $message->attachment_files);
		}

		//if the attachment has not yet been saved, grab it from the attachment cache
		if(!isset($attachment) || !is_a($attachment, 'Attachment'))
			$attachment = $this->user->attachment_from_cache($filename);

		if(!is_a($attachment, 'Attachment')) show_404(); //make sure the attachment is really on this message
		
		if(!is_null($zip_index)){
			if(!array_key_exists($zip_index, $attachment->children)) show_404();
			return $attachment->children[$zip_index];
		}
		
		return $attachment;
	}

	protected function patient_confirmation_form(Message $message, array $patients, array $patient_search_criteria){
		$this->load->library('patient_data/patient_id');
		$this->template->set('header', 'Attach a VA Continuity of Care Document');

		if(count($patients) == 1)
			$subheader = 'One patient matched your search criteria.  Please confirm that this is the patient you\'re looking for.';
		else
			$subheader = ucfirst(number_as_text(count($patients))).' patients matched your search criteria.  Please select a patient in order to find and retrieve their clinical documentation.';

		if(!empty($_POST['patients']) && empty($_POST['patient_id'])){
			$this->template->set('danger_message', '<strong>No patient selected.</strong> Please select a patient, or refine your search terms to find other matches.');
		}

		$markup = form_open(current_url(), array('role' => 'form', 'class' => 'patient-lookup-results'));

		//add the search criteria as hidden fields in case we need to redirect back to the patient lookup form
		foreach($patient_search_criteria  as $field => $value){
			$markup .= form_hidden($field, $value);
		}

#TODO - PROBABLY TIME TO MOVE THIS MARKUP INTO A PARTIAL/VIEW OF SOME KIND

		//add each of the matching patients as hidden fields in case we need to reload this form - that way we won't need to do the lookup again
		foreach($patients as $icn => $patient){
			if(is_array($patient)) $patients[$icn] = $patient = new Patient($patient);
			$markup .= $patient->hidden_field_markup('patients['.$icn.']');
		}

		$markup .= '<div class="panel panel-default">';
		$markup .= '<div class="panel-heading">'.$subheader.'</div>';

		$markup .= '<ul class="patients list-group">';
		foreach($patients as $icn => $patient){
			$markup .= '<li class="radio list-group-item"><label class="row">'.form_radio('patient_id', $icn).$this->load->view('inbox/patient_data/_patient', compact('message', 'patient'), TRUE).'</label></li>';
		}
		$markup .= '</ul>';
		$markup .= '</div>';

		$markup .=  '<div class="button-container">';
		$markup .= form_submit('patient_id_submit', 'Find and Attach Document', 'class="btn btn-primary btn-sm"' );
		$markup .= form_submit('refine_search_terms', 'Refine Search Terms', 'class="btn btn-default btn-sm"');
		$markup .= '</div>';
		$markup .= form_close();

		return $this->template->load_string('form_dialog_template.php', $markup);
	}
	
	protected function show_attachment_error($message, $status){
		if(!$this->is->nonempty_string($message)) return $this->error->should_be_a_nonempty_string($message);
		if(!$this->is->nonzero_unsigned_integer($status)) return $this->error->should_be_a_nonzero_unsigned_integer($status);

		if(IS_AJAX)
			show_error($message, $status);
		else
			echo '<textarea status="'.$status.'">'.$message.'</textarea>';
	}

}
/* End of file inbox.php */
/* Location: ./application/controllers/inbox.php */