<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*//** */

require_once APPPATH.'controllers/adminpanel.php';

/**
* Admin pages for user management.
*
* This code was originally in the AdminPanel controller, but have been moved to a child class for better maintainability / code organization.
* Note that many of these functions were originally in one giant function called manage_users() which routed calls by action to helper methods; 
* routing is now handled using Codeigniter routing functionality instead so that each action can be separated into a child function.
*
* @todo Many of the forms direct to {@link process_request}, which routes to an appropriate field based on the $_POST function. It would be better
* to set up the forms to point directly to their own processing action and remove the process_request function.
*
* @todo Remove process_request function and set up forms to go directly to the methods that process_request would have routed them to
*
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class User_controller extends AdminPanel {
	
	public $title; 
	
	function __construct() {
		parent::__construct();
		$this->verify_permission('manage_users'); 
		
		require_model('api_user');
		require_library('form_markup_generator/user_form_markup_generator');
		$this->title = PORTAL_TITLE_PREFIX . 'Admin Panel';
	} 
	
	function create(){
		$this->verify_permission('manage_users_create');
		
		require_library('form_markup_generator');
		$markup_generator = new Form_markup_generator();
		$markup_generator->set_fields( array('username' => array('type' => 'text_input', 'required' => true)));
		
		if(!empty($_POST)){
			$markup_generator->set_values_from_post();
			if(!$markup_generator->validates()){
				$error_message = '<strong>We need you to make a few changes to this form.</strong> '.ul_if_multiple($markup_generator->validation_messages);
			}elseif(User::exists(array('user_name' => $markup_generator->value('username')))){
				//show a message and let them go straight to the edit form
				$success_message = '<strong>This user already exists in this application.</strong> You can edit their information '.link_to('adminpanel/manage_users/user/'.$markup_generator->value('username'), 'here').'.';
			}elseif(!API_user::exists(array('mailbox' => $markup_generator->value('username')))){
				$error_message = '<strong>This user has not yet been created in API Admin, or does not have the correct access for this application.</strong> You can create a user or manage their application access from the API Admin '.link_to(API_ADMIN_URL.'/administration/manage/accounts', 'Manage Accounts', 'target="blank"').' page.';
			}elseif(!User::create(array('user_name' => $markup_generator->value('username')))){
				$error_message = '<strong>An error occurred and this user was not saved.</strong> Please try again in a moment, and contact a system administrator if the problem persists.';
			}else{
				$success_message = '<strong>Success!</strong> This user has been added to this application. You can edit their information '.link_to('adminpanel/manage_users/user/'.$markup_generator->value('username'), 'here').'.';				
			}
		}
		
		$title = $this->title;
	 	$this->load->view('adminpanel/manage_users/account_creation', compact('title', 'success_message', 'error_message', 'markup_generator'));	
	}
	
	//display a list of all active users
	public function index($page_number=1, $show_removed = false){		
	
		if(!$this->has_permission('manage_users_all')){
			if(!$this->has_permission('manage_users_facilities')){
				$usernames_in_facility = collect('mailbox', Api_user::find_for_home_facility());
			}else{
				show_404();
				return $this->error->warning($this->user->describe().' does not have permission for manage_users_all');			
			}
		}
		
		if(empty($page_number) || !$this->is->nonzero_unsigned_integer($page_number))
			$page_number = 1;
			
		$page_start = ($page_number - 1) * ADMINPANEL_DISPLAY_PER_PAGE;
			
		if(!empty($usernames_in_facility)) User::db()->where('username IN', $usernames_in_facility());
		$total_users = User::count( array('user_deleted_flag' => $show_removed, 'user_is_group' => false));
		$users = array();
		
		if(!empty($total_users)){
			if(!empty($usernames_in_facility)) User::db()->where('username IN', $usernames_in_facility());
			User::db()->order_by('user_name ASC')->limit(ADMINPANEL_DISPLAY_PER_PAGE, $page_start);
			$users = User::find(array('user_deleted_flag' => $show_removed, 'user_is_group' => false));
		}

		$data = array('title' => $this->title, 'page' => $page_number);
		$this->load->view('adminpanel/manage_users/index', array_merge($data, compact('users', 'total_users', 'show_removed')));	
	}
	
	public function remove($user_id) {		
		$this->load->library('audit');
				
		if(!User::formatted_like_an_id($user_id)) show_404();
		$user = User::find_one(array('user_id' => $user_id, 'user_deleted_flag' => false));
		
		if(!User::is_an_entity($user)) show_404();
		$this->can_edit_user($user->username);
		
		if($user->id == $this->user->id){
			$this->session->set_error_message('Cannot remove logged in user account.');			
			redirect('adminpanel/manage_users'); //don't let them delete themselves
			return; 		
		}
		
		$user->user_deleted_flag = true;
		if(!$this->ldap->delete_ldap_account($user->username) || !$user->save()){
			$this->session->set_error_message('An error occurred and the user could not be removed. Contact a system administrator for assistance.');					
			redirect('adminpanel/manage_users'); 
			return;
		}
		
		$this->audit->log_event('edit', array($user->id, $this->user->id, 'Remove User', date('U')));
		$this->session->set_success_message('The user has been removed.  If needed, you can undo this action from the Manage Removed Users tab.');
		redirect('adminpanel/manage_users'); 
	}	
	
	//display a list of all inctive users
	public function removed($page_number=1){
		if(!$this->is->nonzero_unsigned_integer($page_number)) redirect('adminpanel/manage_users/removed');
		$this->index($page_number, $show_removed=true);
	}	
	
	public function restore($user_id) {		
		$this->load->library('audit');
		
		if(!User::formatted_like_an_id($user_id)) show_404();
		$user = User::find_one(array('user_id' => $user_id, 'user_deleted_flag' => true));
		
		if(!User::is_an_entity($user)) show_404();
		$this->can_edit_user($user->username);
		
		$user->user_deleted_flag = false;
		if(!$this->ldap->restore_ldap_account($user->username) || !$user->save()){
			$this->session->set_error_message('An error occurred and the user could not be restored. Contact a system administrator for assistance.');					
			redirect('adminpanel/manage_users'); 
			return;
		}
		
		$this->audit->log_event('edit', array($user->id, $this->user->id, 'Restore User', date('U')));
		$this->session->set_success_message('The user has been restored.  If needed, you can undo this action from the Manage Users tab.');
		redirect('adminpanel/manage_users'); 
		return;
	}	
	
	function user($username){
		if(empty($username)) show_404();
		$this->can_edit_user($username);

		$user = User::find_one(array('user_name' => $username));
		if(!User::is_an_entity($user)){
			redirect('adminpanel/manage_users');
			return $this->error->warning('Unable to edit user '.$this->error->describe($username).' because the user was not found in the database'); //in case the redirect doesn't work
		}		
				
		require_library('form_markup_generator/user_form_markup_generator');
		$markup_generator = new User_form_markup_generator($user, array('include_admin_fields' => true));
		
		$title = $this->title;
		
		if(empty($_POST) && !$markup_generator->load_saved_values()){
			$markup_generator = null; //if we can't load the saved values, it's because we can't save form to the API, so don't let them fill out the form.
			$this->load->view('adminpanel/manage_users/edit', compact('title', 'markup_generator', 'username', 'user')); 
			return; //view will tell the admin that the user hasn't granted the API the right permissions.  todo - there could be other cases, we should expand this out.		
		}if(!empty($_POST)){
			$markup_generator->set_values_from_post();
			if(!$markup_generator->validates()){
				$error_message = '<strong>We need you to make a few changes to this form.</strong>&nbsp;&nbsp;'.ul_if_multiple($markup_generator->validation_messages);
			}elseif(!$markup_generator->save_values()){	
				$error_message = '<strong>An error occurred and your changes could not be saved.</strong>&nbsp;&nbsp;Please try again in a moment, and contact an administrator if the problem persists.';
			}else{
				$manage_users_link = link_to('adminpanel/manage_users', 'Manage Users');
				if(!$user->is_active)  $manage_users_link = link_to('adminpanel/manage_users/removed', 'Manage Removed Users');
				
				$success_message = '<strong>Success!</strong>&nbsp;&nbsp;Your changes have been saved. You can make further changes or return to the '.$manage_users_link.' page.';
				$markup_generator->load_saved_values();			
			}
		}
				
		$this->load->view('adminpanel/manage_users/edit', compact('title', 'markup_generator', 'user', 'username', 'error_message', 'success_message'));				
	}
	
}
/* End of file adminpanel.php */
/* Location: ./application/controllers/adminpanel.php */