<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* Help Controller: To present video on the video view page. 
* This page is used to controll different video souces and resolution that present on video view page. 
* The video source might come from either local server or youtube and for the local video it come with different resolutions.
* @package direct-project-innovation-initiative
* @subpackage controllers
*/


class Help_controller extends CI_Controller  {
	
	public function video($name){
		load_library('template');
		require_library('video');
		
		if(!Video::exists($name)) show_404();
		try{
			$video = new Video($name);
		}catch(Exception $e){
			$this->error->warning($e->getMessage());
			show_404();
		}

		$this->template->set('video', $video);
		$this->template->set('videos', Video::all());
		
		//if we don't have a YouTube video, see if we have a local video we can display instead
		if(!isset($video->external_url)){
			foreach($video->resolutions as $resolution){
				if(isset($video->$resolution))
					return $this->template->load('help/video_template', 'help/_video_local', compact('video', 'resolution'));
			}
		}
		
		$this->template->load('help/video_template', 'help/_video_external_url', compact('video'));	
	}
	
	public function local_video($name, $resolution){
		load_library('template');
		require_library('video');
		$resolution = str_replace('-', '_', $resolution);
		
		if(!Video::exists($name)) show_404();
		try{
			$video = new Video($name);
		}catch(Exception $e){
			$this->error->warning($e->getMessage());
			show_404();
		}
		
		if(!isset($video->$resolution)) redirect('help/videos/'.$name);
		
		$this->template->set('video', $video);
		$this->template->set('videos', Video::all());
		$this->template->load('help/video_template', 'help/_video_local', compact('video', 'resolution'));		
	}
	
}