<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 
?>
				<h1><a href="/onboarding/documentation/" class="underline">Documentation</a> &rarr; /direct/messages/save - POST</h1>
				<p>The Save Message web service allows authorized applications to save messages as drafts and can be accessed by sending a POST request to /direct/messages/save.</p>
				<h3>Authentication</h3>
				<p>
					The API authentication utilized is based upon hash message authentication code (HMAC). HMAC is an authentication method that combines a cryptographic hash function with a secret cryptographic key. After the successful registration of an application on the API, a public and private key like the example below will be provisioned for its use.
				</p>
				<p class="code">
					Public Key: REDACTED
					<br/>Private Key: REDACTED
				</p>
				<p>
					On every request that an application sends to the API they must include an Authorization header. The authorization header is a string that the API will utilize to confirm the identity, and the message content, of the sender. The authorization header consists of three parts. The first part is the API identifier, represented by the word "DAAS", which stands for Direct as a Service. The API identifier is followed by a space that separates it from the identifying content. The identifying content consists of the unique public key and the base64 encoded HMAC hash generated by the request content and the private key, delimited by a colon. An example of the authorization header is below.
				</p>
				<p class="code">
					Authorization: DAAS REDACTED
				</p>
				<p>
					The HMAC string is generated by running an HMAC hash function on a plain text string and the application's private key. The plain text string that must be hashed using HMAC is constructed as follows:
					<ul>
						<li>HTTP Request Type</li>
						<li>Date</li>
						<li>Content-MD5 (Optional)</li>
						<li>Content Type (Not including boundary)</li>
						<li>URI</li>
					</ul>
					These values are separated by new line characters ("\n"). An example of the plain text string is below:
				</p>
				<p class="code">
					POST\n06/03/2013 12:13:56 EST\niB94gawbwUSiZy5FuruIOQ==\nmultipart/form-data\n/direct/messages/save/format/json
				</p>
				<p>
					The string above is hashed with the application's private key using the SHA-256 algorithm. A snippet of JavaScript code showing an example of this is shown below:
				</p>
				<p class="code">
					var hashString = CryptoJS.HmacSHA256("POST\n06/03/2013 12:13:56 EDT\niB94gawbwUSiZy5FuruIOQ==\nmultipart/form-data\n/direct/messages/save/format/json","REDACTED");
					<br/>var base64 = encode64(""+hashString);
					<br/>var authorization = "DAAS REDACTED:"+base64;
				</p>
				<p>
					In the example above the Content MD5 is provided but this is an optional field. If the Content MD5 header is not specified then the hash should not have the MD5 specified either.
				</p>
				<h3>Headers</h3>
				<p>
					There are three headers that must be sent with each save call and one optional header. These headers are used in validating who the message came from, who it is going to and the message itself.
				</p>
				<div class="column">
					<div class="left">
						<ul>
							<li>Authorization</li>
							<p>
								The first required header is the Authorization header covered in the Authentication section at the top of this page.
							</p>
							<li>Date or X-Daas-Date</li>
							<p>
								The second required header that must be included is the Date header. Some browsers will not let an application specify the Date header programmatically, so in this case it is also acceptable to use the X-Daas-Date header as the API will interpret them interchangeably. This header should be populated with the current date and time, in any standard format (including time zone information if not time zone agnostic), when the POST request is submitted. The value supplied in the Date header must match the value used in the creation of the hash string for the Authorization header.
							</p>
						</ul>
					</div>
					<div class="right">
						<ul>
							<li>Content-Type</li>
							<p>
								The final required header for POST requests is the Content-Type. The Content-Type header must match the Content-Type provided in the hash string for the Authorization header except the hash string does not include the boundary parameter of the Content-Type if there is one (i.e. multipart/form-data Content-Type).
							</p>
							<li>Content-Md5</li>
							<p>
								The optional header is the Content-Md5 header. This header should contain an MD5 hash of the entire POST body. If this header is specified then it must also be included in the hash string for the Authorization header. When provided, this serves as an extra security precaution above and beyond TLS to ensure the POST request sent has not been modified in transit.
							</p>
						</ul>
					</div>
				</div>
				<h3>Arguments</h3>
				<p>
					There are 9 arguments that can be sent to the save web service.
				</p>
				<div class="column">
					<div class="left">
						<ul>
							<li>Sender</li>
							<p>
								This is a required field that defines who the Direct message comes from.						
							</p>
							<li>To</li>
							<p>
								This is a required field that defines who the Direct message will be sent to. This field will accept comma or semi-colon delimited RFC822 addresses. The validate web service will be run on all addresses in the "To" field to validate that they are trusted recipients before being sent out.
							</p>
							<li>CC</li>
							<p>
								This is an optional field that defines additional people that will receive the Direct message as a carbon copy. This field will accept comma or semi-colon delimited RFC822 addresses. The validate web service will be run on all addresses in the "CC" field to validate that they are trusted recipients before being sent out.
							</p>
							<li>Mailtype</li>
							<p>
								This is an optional field and defines what format the Direct message body will be sent in. The options for this field are "Text" for plain text or "HTML" for an HTML formatted message. If no mailtype, or an invalid mailtype, is specified the type will default to HTML.
							</p>
							<li>Draft ID</li>
							<p>
								This is an optional field that defines what existing draft to overwrite with the one provided. This is used so that the draft folder doesn't fill up with auto-saves for the same message.
							</p>
						</ul>
					</div>
					<div class="right">
						<ul>
							<li>Priority</li>
							<p>
								This is an optional field that defines what priority the Direct message will be sent with. The options for this field are the numbers 1-5, with 1 being the highest priority and 5 being the lowest. If no priority, or an invalid priority, is specified it will default to 3 (normal priority).
							</p>
							<li>Subject</li>
							<p>
								This is an optional field that defines what the subject line of the Direct message will read. If no subject is specified then (No Subject) will be added as the subject by default.
							</p>
							<li>Body</li>
							<p>
								This is an optional field and defines what the message body of the Direct message will contain. If no body is specified a blank body will be sent with the message.
							</p>
							<li>Files</li>
							<p>
								Optionally, a POST request can be sent as multipart/form-data with file data. This file data defines the files that will be attached to the direct message. The file fields can be passed with any POST field name that the third-party application chooses, they simply must be included in the multipart data. The total size of all attachments must be less than 10 MB and .exe files cannot be attached.
							</p>
						</ul>
					</div>
				</div>
				<h3>Example Response</h3>
				<ul>
					<li>Success</li>
						<ul>
							<li>HTTP-200, {"request_id":"1","mailbox":"tauser","id":"235","message":"Message saved"}</li>
						</ul>
					<li>Error</li>
						<ul>
							<li>HTTP-401, {"request_id":"2","message": "Access Denied. Authentication Failed."}</li>
							<li>HTTP-403, {"request_id":"3","message":"Access Denied. Use Not Authorized."}</li>
							<li>HTTP-403, {"request_id":"4","message":"Access Denied. User Not Authorized."}</li>
							<li>HTTP-422, {"request_id":"5","message":"Message not found"}</li>
							<li>HTTP-422, {"request_id":"6","fields":["mailbox"],"message":"'Mailbox' is a required field."}</li>
							<li>HTTP-422, {"request_id":"7","message":"'Mailbox' contains invalid input","fields":["mailbox"]}</li>
						</ul>
				</ul>
				<h3>Sample Code</h3>
				<p>
					The save web service is constructed in the same manner that the send web service is. Please click <a href="/onboarding/documentation/send_example">here</a> to be taken to some sample code snippets for the send web service and use that as a basis for creating the save call.
				</p>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>