<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

?>
<style>	
	input[size] { width: auto; max-width: 100%; }
	main form.form-horizontal { margin: 2em 0; }
	#required_fields_message { margin: 0 0 20px 25px; }
</style>
<?php if(Account_request::is_an_entity($account_request) && $account_request->user_is_deactivated()): ?>
	<p>Your account is currently disabled, contact an administrator to request access.</p>				
<?php else: ?>
	<?php if(empty($_POST) && Account_request::is_an_entity($account_request) && $account_request->is_denied()): ?>
		<div class="alert alert-warning alert-dismissible" role="alert">
			<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<p><strong>Your account request has been denied.</strong>  <?php if(!$account_request->property_is_empty('justification')) echo 'The reason given was:'; ?></p>
			<?php if(!$account_request->property_is_empty('justification')): ?><blockquote><?php echo $account_request->justification ?></blockquote><?php endif ?>
			<p>Please correct any issues with your request before submitting a new one.</p>
		</div>
	<?php elseif(empty($_POST) && Account_request::is_an_entity($account_request) && $account_request->is_pending()): ?>
		<div class="alert alert-success alert-dismissible" role="alert">
			<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<p><strong>Your account request has been submitted.</strong> It is currently awaiting review by an administrator. An email notification will be sent to you when the request status changes. </p>
		</div>	
	<?php endif ?>
	<?php if(isset($application)): ?>
		<p>You need to create an account on <?php echo PRODUCT_NAME ?> before you can use <?php echo $application->name ?>.
		   Fill out the form below in order to submit your account request.  You will be notified when your account has been approved.</p>
	<?php endif ?>
	<?php if(!empty($error_message)) echo dismissable_alert($error_message, 'danger'); ?>
	
	<?php echo form_open(current_url(), array('class' => 'form form-horizontal', 'data-label-length' => 'max-'.ceil($markup_generator->longest_inline_label_length/5)*5)) ?>
		<div class="well">
			<p id="required_fields_message" class="req"><abbr title="Required field">*</abbr> = Required Field</p>
			<?php echo $markup_generator->markup() ?>
		</div>
		<input class="btn btn-default <?php echo grid_offset_for_width($markup_generator->label_width_class) ?>" type="submit" value="Submit Registration"/>
		<?php echo link_to( (empty($redirect_url) ? site_url('onboarding') : $redirect_url), 'Cancel', array('class' => 'cancel')) ?>
	<?php echo form_close() ?>
<?php endif ?>
