<?php
/**
* @package direct-as-a-service
* @subpackage views
* @filesource
*/ /** */

	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 

	$CI = get_instance();
	if(!isset($form_data)) $form_data = array();
		
	$fields = array('app_name' => array('label' => 'Application Name',
										'aria-label' => 'Please enter the name of the application requesting access.'),
					'app_url' => array( 'label' => 'Application URL',
										'aria-label' => 'Please enter the URL of the application requesting access.'),
					'app_desc' => array('label' => 'Application Description',
										'aria-label' => 'Please enter a description of the application requesting access.'),
					'app_just' => array('label' => 'Justification',
										'aria-label' => 'Please enter a justification for why this application needs access to '.PRODUCT_NAME.'.'),
					'app_poc_name' => array('label' => 'POC Name',
											'aria-label' => 'Please enter a Point of Contact who can speak for the application and explain their needs to the '.PRODUCT_NAME.' Administrators.'),
					'app_poc_email' => array('label' => 'POC External Email',
											'aria-label' => 'Please enter the email address of the POC above.'),
					'app_poc_phone' => array('label' => 'POC Phone',
											'aria-label' => 'Please enter the phone number of the POC above.'));
											
?>
				<div id="success">&nbsp;</div>
				<div id="error">&nbsp;</div>
				<h1>Application Request</h1>
				<div class="column">
					<?PHP if(isset($validation_errors)) { echo '<div class="message_error">'.$validation_errors.'</div>'; } ?>
					<?PHP if(isset($error_message)) { echo '<div class="message_error">'.$error_message.'</div>'; } ?>
				<?php if(isset($request) && $request->denied > 0 && $request->denial_reason): ?>
					<div class="message">
						<p>This application has been denied for the following reason:</p>
						<p class="denial-reason"><?php echo $request->denial_reason; ?></p>
						<p>Please update the request and resubmit.</p>
					</div>
				<?php endif ?>
				<?php if(isset($request)): ?>
					<p>Please fill out all fields in the following form to update your application request details.</p>
				<?php else: ?>
					<p>Please fill out all fields in the following form to request access to the API web services for your application.</p>
				<?php endif ?>
					<?PHP echo form_open(current_url(),array('id'=>'requestForm')); ?>
						<div class="form">
							<?PHP if(isset($request)) echo form_hidden('app_id',$request->id,'app_id'); ?>
					<?php foreach($fields as $name => $label): ?>
							<label for="<?php echo $name ?>"><?php echo $label['label'] ?>:</label>
							<p class="hidden_context" style="display:none;" id="<?php echo $name ?>_help"><?php echo $label['aria-label'] ?></p>
						<?php if($name == 'app_desc' || $name == 'app_just'): ?>
							<?php echo form_textarea($name, element($name, $form_data), 'id="'.$name.'" class="ttFocus" aria-descriedby="'.$name.'_help" title="'. $label['aria-label'].'"') ?>	
						<?php else: ?>	
							<?php echo form_input($name, element($name, $form_data), 'id="'.$name.'" class="ttFocus" aria-descriedby="'.$name.'_help" title="'. $label['aria-label'].'"') ?>	
						<?php endif ?>												
					<?php endforeach ?>								
						</div>	
						<div class="text-right"><input class="blue-button" type="submit" value="Save"/></div>	
					<?PHP echo form_close(); ?>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>