<?php
/**
* @package direct-as-a-service
* @subpackage views
* @filesource
*/ /** */

//note - including a MAX_FILE_SIZE field prevents PHP from actually uploading files to the server if they're too large
//while this can easily be hacked and should not be counted on as a security measure, it can improve performance to avoid large files from being uploaded

?>
<style>
	.modal-header { padding-bottom: 0; border-bottom: none;  }
	.modal-body { padding-top: 0; }
	 main .subnav-content .modal-body p { margin-top: 0.5em; }
	.modal-footer { border-top: none; }
	.progress { margin: 1em 0; }
	.progress-container .percent-container { display: inline-block; float: right; margin-left: 0.5em; }
</style>
<p>You can use this form to send files to another Direct user that are too large to be attached to a Direct Message. The recipient will be sent a Direct message with a link that will allow them to download the file. The link will expire after thirty (30) days.</p>
<?php echo form_open_multipart(current_url(), array('class' => 'file-transfer')) ?>
	<input type="hidden" name="MAX_FILE_SIZE" value="<?php echo $form->field('file_to_transfer')->max_size_in_bytes ?>" />
	<div class="well">
		<?php echo $form->markup(); ?>
	</div>
	<div class="pull-right">
		<input type="submit" value="Submit" class="btn btn-default btn-sm" />
	</div>
<?php echo form_close(); ?>
<div class="modal fade" id="file-transfer-save-notice" tabindex="-1" role="dialog" aria-labelledby="file-transfer-save-notice-label">
	<div class="modal-dialog" role="document">
    		<div class="modal-content">
			<div class="modal-header">
				<h4 class="modal-title" id="file-transfer-save-notice-label">Your file transfer is being saved.</h4>
			</div>
      			<div class="modal-body">
				<p>This may take a few minutes. We appreciate your patience.</p>
				<div class="progress-container">
					<div class="percent-container"><span class="percent">0%</span><span class="sr-only"> Complete</span></div>
					<div class="progress">
						<div class="progress-bar progress-bar-striped active" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width: 0%;"></div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>