<?php
/**
* @package icarus
* @subpackage partials-lister
*/

#TODO -- separate into smaller functions, view, etc.
$links = array();
$page = $lister->page;
$total_pages = $lister->total_pages;

$class = 'previous';
if($lister->page <= 1)
	$class .= ' disabled';

$links['previous'] = $lister->markup_for_pagination_link($page-1, '<span aria-hidden="true">&laquo;</span> Previous', array('class' => $class));

//implement ellipses
if($total_pages > 9){
	$starting_point = 1;
	$ending_point = $total_pages;
	
	if($page - 2 > 2){
		$links[1] = $lister->markup_for_pagination_link(1);
		$links['...'] = $lister->markup_for_pagination_link('...');
		$starting_point = $page - 2;
	}

	if($page + 2 <$total_pages){
		$ending_point = $page + 2;
	}
	
	for($page = $starting_point; $page <= $total_pages && $page <= $ending_point; $page++){
		$links[$page] = $lister->markup_for_pagination_link($page);
	}
	
	
	if($ending_point < $total_pages){
		$links['...'] = $lister->markup_for_pagination_link('...');
		$links[$total_pages] = $lister->markup_for_pagination_link($total_pages);
	}
	
}
else{
	for($page = 1; $page <= $total_pages; $page++){
		$links[$page] = $lister->markup_for_pagination_link($page);
	}
}		

$class = 'next';
if($lister->page >= $total_pages)
	$class .= ' disabled';
	
$links['next'] = $lister->markup_for_pagination_link($lister->page + 1, 'Next <span aria-hidden="true">&raquo;</span>', array('class' => $class));

?>
<ul class="pagination pagination-sm">
<?php foreach($links as $page => $link): ?>
	<li<?php if($page == $lister->page) echo ' class="active"'; elseif(string_contains('disabled', $link)) echo ' class="disabled"'; ?>>
		<?php echo $link ?>
	</li>
<?php endforeach ?>
</ul>