<?php
/**
* @package direct-as-a-service
* @subpackage views
*/ /** */

$requires_passcode = !Mailbox::is_an_entity(Mailbox::find_by_email_address($file_transfer->recipient));

?>
<p><?= $sender->display_name() ?> has sent you a secure file transfer.  This file is available for download until <?= unix_to_display($file_transfer->expires_at) ?>.</p>
<p>
<strong>File Name:</strong> <?= $file_transfer->name ?><br>
<strong>File Size:</strong> <?= byte_format($file_transfer->size) ?><br>
<strong>Download Link:</strong> <?= link_to($file_transfer->url_for_view($requires_passcode)) ?><br>
<?php if($requires_passcode): ?><strong>Passcode:</strong> <?= $file_transfer->passcode ?><br><?php endif ?>
<?php if(!$file_transfer->property_is_empty('note')): ?>
<strong>Message:</strong> <?= $file_transfer->note ?>
<?php endif ?>
</p>