<?php 
/**
* @filesource
* @package exercisedesigndashboard
* @subpackage views
*/
 
if(!isset($lister)) return $this->error_helper->warning('I expected to be passed a parameter called $lister');
if(!is_a($lister, 'Lister')) return $this->error_helper->should_be('Lister object', $lister);

if($lister->total_items > 10){
	$items_per_page_options = array();
	foreach(array(10, 25, 50, 100) as $possibility){
		$items_per_page_options[site_url($lister->url_for_items_per_page($possibility))] = $possibility;
	}
}

  
?>
<?php if(!$lister->property_is_empty('total_items')): ?>
<nav class="table-nav">
	<div class="table-total"><?php echo $lister->total_items ?> results</div>
	<div class="table-pagination"><?php echo $lister->markup_for_pagination() ?></div>
<?php if(!empty($items_per_page_options)): ?>
	<div class="table-items-per-page">
		<label>Records per page: <?php echo form_dropdown('items_per_page', $items_per_page_options, array_search($lister->items_per_page, $items_per_page_options), array(
		'onchange' => 'window.location = $(this).val();')) ?></label>
	</div>
<?php endif ?>
</nav>
<?php endif ?>