<?php
/**
* @package direct-as-a-service
* @subpackage views
* @filesource
*/ /** */
 
	$this->load->view('api/header'); 
	$this->load->view('api/nav');
	$count = 0;
?>
<script>
$(function() {
	$("#tabs").tabs();
	$("#active_link").removeAttr("tabindex");
	$("#pending_link").removeAttr("tabindex");
	$("#denied_link").removeAttr("tabindex");
});
</script>

				<h1>Application List</h1>
				<div class="column">
					<?PHP if(isset($message)) { echo '<div id="message_info" class="message_info">'.$message.'</div>'; } ?>
					<?PHP if(isset($error_message)) { echo '<div id="message_error" class="message_error">'.$error_message.'</div>'; } ?>
					<?PHP if(isset($success_message)) { echo '<div id="message_success" class="message_success">'.$success_message.'</div>'; } ?>
					<div id="message-success" class="message_success display_none">&nbsp;</div>
					<div id="message-error" class="message_error display_none">&nbsp;</div>
					
					<div id="tabs" class="column">						
						<ul>
							<a class="hidden_context hidden_link" id="skip_nav" href="#nav_tab_holder" style="font-weight: normal;">Skip Navigation</a>														
							<li><a id="active_link" href="#active" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Active</a></li>
							<li><a id="pending_link" href="#pending" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Pending Approval</a></li>
							<li><a id="denied_link" href="#denied" onclick="javascript:clearMessage('message_info');clearMessage('message_error');clearMessage('message_success');">Denied</a></li>
							<div name="nav_tab_holder" id="nav_tab_holder" class="hidden_context hidden_link" > </div>
						</ul>												
						<div id="active">
							<p>This table lists the current applications that are authorized to utilize the Direct API 
							web services.</p>
							<?php if (sizeof($active_list) == 0) { ?>
								<div class="message">You currently have no active applications.</div>
							<?php }else{ ?>
								<br/>
								<table id="active_application_table" class="display">
									<caption class="hidden_context">Active Applications</caption>
									<thead>
										<tr class="gridheader">
											<th align="center" scope="col">Name</th>
											<th scope="col">POC</th>											
											<th scope="col">Application Keys</th>
											<th scope="col">Actions</th>
										</tr>
									</thead>
									<?php $count = 0; foreach($active_list as $app){ ?>
										<tr>
											<td class="active_application_name">
												<a href="/applications/edit/<?php echo $app->id; ?>"><?php echo $app->name; ?></a>&nbsp;
												<?php if ($app->url){?>
													<br/><a target="_blank" href="<?php echo $app->url; ?>"><?php echo $app->url; ?></a>&nbsp;
												<?php } ?>
												<?php if ($app->description){?>
													<br/><?php echo $app->description; ?>&nbsp;
												<?php } ?>
											</td>
											<td class="active_application_poc">
												<?php if ($app->poc_name){?>
													<?php echo $app->poc_name; ?>&nbsp;
												<?php } ?>
												<?php if ($app->poc_email){?>
													<br/><a href="mailto:<?php echo $app->poc_email; ?>"><?php echo $app->poc_email; ?></a>&nbsp;
												<?php } ?>
												<?php if ($app->poc_phone){?>
													<br/><?php echo $app->poc_phone; ?>&nbsp;
												<?php } ?>
											</td>
											<td class="active_application_keys">
												<div id="public-modal<?php echo $app->id; ?>" title="Public Key for <?php echo $app->name; ?>">
													<?php echo $app->public_key; ?>
												</div>
												<a href="#" onclick="setTimeout(function(){$('#StatusUpdater').text('<?php echo "Public key for ". $app->name. " is ".implode(' ',str_split($app->public_key)); ?>');},10);"  id="public-link<?php echo $app->id; ?>">View Public Key</a><br/>
												<div id="private-modal<?php echo $app->id; ?>" title="Private Key for <?php echo $app->name; ?>">
													<?php echo $app->private_key; ?>
												</div>
												<a href="#" onclick="setTimeout(function(){$('#StatusUpdater').text('<?php echo "Private key for ". $app->name. " is ".implode(' ',str_split($app->private_key)); ?>');},10);"  id="private-link<?php echo $app->id; ?>">View Private Key</a><br/>
											</td>
											<td class="active_application_actions">
												<!-- form is actually submitted via ajax and is controlled in main.js -->
												<?PHP echo form_open('/applications/update_key',array('id'=>'keyForm'.$app->id,'class'=>'keyForm')); ?>
													<?PHP echo form_hidden('app_id',$app->id,'app_id'.$count); ?>
													<div class="center">
														<a href="#" onclick="if (confirm('Are you sure you want to regenerate keys for <?php echo $app->name; ?>?')){$('#keyForm<?php echo $app->id; ?>').submit();}" title="Regenerate Keys: <?php echo $app->name; ?>"><img src="/images/icons/key_go.png" alt="Regenerate Keys: <?php echo $app->name; ?>" /></a>
														<a href="/applications/edit/<?php echo $app->id; ?>/<?php if(isset($active_cur_page)){echo $active_cur_page;}else{echo 1;} ?>/<?php if(isset($active_items_per_page)){echo $active_items_per_page;}else{echo ITEMS_PER_PAGE_DEFAULT;}?>/
														<?php if(isset($pending_cur_page)){echo $pending_cur_page;}else{echo 1;} ?>/<?php if(isset($pending_items_per_page)){echo $pending_items_per_page;}else{echo ITEMS_PER_PAGE_DEFAULT;}?>/
														<?php if(isset($denied_cur_page)){echo $denied_cur_page;}else{echo 1;} ?>/<?php if(isset($denied_items_per_page)){echo $denied_items_per_page;}else{echo ITEMS_PER_PAGE_DEFAULT;}?>" title="Edit Application: <?php echo $app->name; ?>"><img src="/images/icons/application_edit.png" alt="Edit Application: <?php echo $app->name; ?>" /></a>
													</div>
												<?PHP echo form_close(); ?>
											</td>
										</tr>
									<?php $count++; } ?>
								</table>
							<?php } ?>
							<br/>
							<p class="center">
								<input type="button" class="blue-button" onclick="location.href='/onboarding/request/'" value="Request New Application"/>
							</p>
						</div>
						<div id="pending">
							<p>This table lists the applications that are currently waiting for authorization to utilize the Direct API 
							web services.</p>
							
							<?php if (sizeof($pending_list) == 0) { ?>
								<div class="message">You currently have no application requests pending approval.</div>
							<?php }else{ ?>
								<br/>
								<table id="pending_application_table" class="display">
									<caption class="hidden_context">Pending Applications</caption>
									<thead>
										<tr class="gridheader">
											<th scope="col">Name</th>
											<th scope="col">POC</th>											
											<th scope="col">Justification</th>
											<th scope="col">Request Date</th>
										</tr>
									</thead>
									<?php foreach($pending_list as $app){ ?>
										<tr>
											<td class="pending_application_name">
												<a href="/onboarding/request/edit/<?php echo $app->id; ?>"><?php echo $app->name; ?></a>&nbsp;
												<?php if ($app->url){?>
													<br/><a target="_blank" href="<?php echo $app->url; ?>"><?php echo $app->url; ?></a>&nbsp;
												<?php } ?>
												<?php if ($app->description){?>
													<br/><?php echo $app->description; ?>&nbsp;
												<?php } ?>
											</td>
											<td class="pending_application_poc">
												<?php if ($app->poc_name){?>
													<?php echo $app->poc_name; ?>&nbsp;
												<?php } ?>
												<?php if ($app->poc_email){?>
													<br/><a href="mailto:<?php echo $app->poc_email; ?>"><?php echo $app->poc_email; ?></a>&nbsp;
												<?php } ?>
												<?php if ($app->poc_phone){?>
													<br/><?php echo $app->poc_phone; ?>&nbsp;
												<?php } ?>
											</td>
											<td class="pending_application_justification"><?php echo $app->justification; ?>&nbsp;</td>
											<td class="pending_application_request_date"><?php echo date("M d Y H:i:s",$app->requested_date); ?>&nbsp;</td>
										</tr>
									<?php } ?>
								</table>
							<?php } ?>
						</div>
						<div id="denied">
							<p>This table lists the applications that have been rejected access to utilize the Direct API 
							web services. Please update the necessary information and resubmit.</p>
							
							<?php if (sizeof($denied_list) == 0) { ?>
								<div class="message">You currently have no application requests that have been denied.</div>
							<?php }else{ ?>
								<br/>
								<table id="denied_application_table" class="display">
									<caption class="hidden_context">Denied Applications</caption>
									<thead>
										<tr class="gridheader">
											<th align="center" scope="col">Name</th>
											<th scope="col">POC</th>											
											<th scope="col">Justification</th>
											<th scope="col">Request Date</th>
											<th scope="col">Denial Reason</th>
										</tr>
									</thead>
									<?php foreach($denied_list as $app){ ?>
										<tr>
											<td class="denied_application_name">
												<a href="/onboarding/request/edit/<?php echo $app->id; ?>"><?php echo $app->name; ?></a>&nbsp;
												<?php if ($app->url){?>
													<br/><a target="_blank" href="<?php echo $app->url; ?>"><?php echo $app->url; ?></a>&nbsp;
												<?php } ?>
												<?php if ($app->description){?>
													<br/><?php echo $app->description; ?>&nbsp;
												<?php } ?>
											</td>
											<td class="denied_application_poc">
												<?php if ($app->poc_name){?>
													<?php echo $app->poc_name; ?>&nbsp;
												<?php } ?>
												<?php if ($app->poc_email){?>
													<br/><a href="mailto:<?php echo $app->poc_email; ?>"><?php echo $app->poc_email; ?></a>&nbsp;
												<?php } ?>
												<?php if ($app->poc_phone){?>
													<br/><?php echo $app->poc_phone; ?>&nbsp;
												<?php } ?>
											</td>
											<td class="denied_application_justification"><?php echo $app->justification; ?>
											<td class="denied_application_request_date"><?php echo date("M d Y H:i:s",$app->requested_date); ?>&nbsp;</td>
											<td class="denied_application_denial_reason"><?php echo $app->denial_reason; ?>&nbsp;</td>
										</tr>
									<?php } ?>
								</table>
							<?php } ?>
						</div>
					</div>
					<script>
						$(function() {
							$('[id^=public-modal]').dialog({ autoOpen: false })
							$('[id^=public-link]').click(function(e){
								e.preventDefault();
								var id = $(e.target).attr('id').replace('public-link','');
								$('[id^=public-modal]').dialog({
									modal:true,
									width:650,
									height:100
								});
								$('[id=public-modal'+id+']').dialog('open');
							});
							$('[id^=private-modal]').dialog({ autoOpen: false })
							$('[id^=private-link]').click(function(e){
								e.preventDefault();
								var id = $(e.target).attr('id').replace('private-link','');
								$( "[id^=private-modal]" ).dialog({
									modal:true,
									width:650,
									height:100
								});
								$('[id^=private-modal'+id+']').dialog('open');
							});
						});
					</script>
					
					<?PHP
						echo form_open('/applications/list',array('id'=>'app_list_form'));
						$hidden_inputs = array(
							'page_select_correction' => '',
							'prefix' => '',
							'active_page_on_bar' => '',
							'active_page_select' => '',
							'active_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							'pending_page_on_bar' => '',
							'pending_page_select' => '',
							'pending_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							'denied_page_on_bar' => '',
							'denied_page_select' => '',
							'denied_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
						);
						echo form_hidden($hidden_inputs,TRUE);
						echo form_close();
					?>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>
<script type='text/javascript'>
	goToSubTab(<?PHP if(isset($anchor)){echo get_instance()->json->encode($anchor);} ?>);
	assignPaginationFormValues(<?PHP echo get_instance()->json->encode($form_values); ?>);

	$(document).ready(function() {
		$('#active_application_table').dataTable({	
			"fnDrawCallback": function(oSettings) {
				if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
					$(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
				} else {
					$(oSettings.nTableWrapper).find('.dataTables_paginate').show();
				}
			},
			"sDom" : '<"top_info"i><"top_paginate"p><"top_length"l><"H"fr>t<"bottom_info"i><"bottom_paginate"p><"bottom_length"l>',
			"bSort" : false,
			//disable sorting on the 1st and 6th columns, which are columns of checkboxes, dropdowns, and action buttons respectively
			"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2,3]},
			                 { 'bSearchable': false, 'aTargets': [2,3]},
			                 { "sClass": "center", 'aTargets': [2,3]},
			                 { "width": "35%", "targets": [0,1] }],
			//set search box text
			"oLanguage": {
				"sSearch": "Find Application: ",
				"sInfo": "_TOTAL_ results",
				"fnInfoCallback" : function(oS, iStart, iEnd, iMax, iTotal, sPre) {
					if(iTotal == 1) { return iTotal + " result"; }
					return iTotal + " results";
				},
				"sLengthMenu": "Records per page _MENU_",
				"oPaginate" : { "sNext" : "Next »", "sPrevious" : "« Previous", },
				"sEmptyTable":    "No applications were found",
				"sZeroRecords":   "No applications were found",
			}
		});
	});

	$(document).ready(function() {
		$('#pending_application_table').dataTable({
			"fnDrawCallback": function(oSettings) {
				if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
					$(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
				} else {
					$(oSettings.nTableWrapper).find('.dataTables_paginate').show();
				}
			},
			"sDom" : '<"top_info"i><"top_paginate"p><"top_length"l><"H"fr>t<"bottom_info"i><"bottom_paginate"p><"bottom_length"l>',
			"bSort" : false,
			//disable sorting on the 1st and 6th columns, which are columns of checkboxes, dropdowns, and action buttons respectively
			"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2,3]},
			                 { "sClass": "center", 'aTargets': []}],
			//set default sorting to Last Modified 2nd column, ascending
			"aaSorting": [[0,"asc"]],
			//set search box text
			"oLanguage": {
				"sSearch": "Find Application: ",
				"sInfo": "_TOTAL_ results",
				"fnInfoCallback" : function(oS, iStart, iEnd, iMax, iTotal, sPre) {
					if(iTotal == 1) { return iTotal + " result"; }
					return iTotal + " results";
				},
				"sLengthMenu": "Records per page _MENU_",
				"oPaginate" : { "sNext" : "Next »", "sPrevious" : "« Previous", },
				"sEmptyTable":    "No applications were found",
				"sZeroRecords":   "No applications were found",
			}
		});
	});

	$(document).ready(function() {
		$('#denied_application_table').dataTable({
			"fnDrawCallback": function(oSettings) {
				if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
					$(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
				} else {
					$(oSettings.nTableWrapper).find('.dataTables_paginate').show();
				}
			},
			"sDom" : '<"top_info"i><"top_paginate"p><"top_length"l><"H"fr>t<"bottom_info"i><"bottom_paginate"p><"bottom_length"l>',
			"bSort" : false,
			//disable sorting on the 1st and 6th columns, which are columns of checkboxes, dropdowns, and action buttons respectively
			"aoColumnDefs": [{ 'bSortable': false, 'aTargets': [0,1,2,3,4]},
			                 { "sClass": "center", 'aTargets': []}],
			//set default sorting to Last Modified 2nd column, ascending
			"aaSorting": [[0,"asc"]],
			//set search box text
			"oLanguage": {
				"sSearch": "Find Application: ",
				"sInfo": "_TOTAL_ results",
				"fnInfoCallback" : function(oS, iStart, iEnd, iMax, iTotal, sPre) {
					if(iTotal == 1) { return iTotal + " result"; }
					return iTotal + " results";
				},
				"sLengthMenu": "Records per page _MENU_",
				"oPaginate" : { "sNext" : "Next »", "sPrevious" : "« Previous", },
				"sEmptyTable":    "No applications were found",
				"sZeroRecords":   "No applications were found",
			}
		});
	});
</script>