<?php
/**
* @package direct-as-a-service
* @subpackage views
* @filesource
*/ /** */
 
	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 

	$CI = get_instance();
	if(!isset($form_data)) $form_data = array();
		
	$fields = array('app_name' => array('label' => 'Application Name',
										'aria-label' => 'Please enter the name of the application requesting access.'),
					'app_url' => array( 'label' => 'Application URL',
										'aria-label' => 'Please enter the URL of the application requesting access.'),
					'app_desc' => array('label' => 'Application Description',
										'aria-label' => 'Please enter a description of the application requesting access.'),
					'poc_name' => array('label' => 'POC Name',
										'aria-label' => 'Please enter a Point of Contact who can speak for the application and explain their needs to the '.PRODUCT_NAME.' Administrators.'),
					'poc_email' => array('label' => 'POC External Email',
										'aria-label' => 'Please enter the email address of the POC above.'),
					'poc_phone' => array('label' => 'POC Phone',
										'aria-label' => 'Please enter the phone number of the POC above.'));
										

?>
				<div id="success">&nbsp;</div>
				<div id="error">&nbsp;</div>
				<h1>Application Edit</h1>
				<div class="column">
					<?PHP if(isset($error_message)) { echo '<div class="message_error">'.$error_message.'</div>'; } ?>
					
					<p>Please fill out all fields in the following form to update your application details.</p>
					<?PHP echo form_open('/applications/application_save',array('id'=>'appForm')); ?>
						<div class="form">
					<?php foreach($fields as $name => $label): ?>
							<label for="<?php echo $name ?>"><?php echo $label['label'] ?>:</label>
							<p class="hidden_context" style="display:none;" id="<?php echo $name ?>_help"><?php echo $label['aria-label'] ?></p>
						<?php if($name == 'app_desc' || $name == 'app_just'): ?>
							<?php echo form_textarea($name, element($name, $form_data), 'id="'.$name.'" class="ttFocus" aria-descriedby="'.$name.'_help" title="'. $label['aria-label'].'"') ?>	
						<?php else: ?>	
							<?php echo form_input($name, element($name, $form_data), 'id="'.$name.'" class="ttFocus" aria-descriedby="'.$name.'_help" title="'. $label['aria-label'].'"') ?>	
						<?php endif ?>										
					<?php endforeach ?>	
							<?PHP if($api_admins):?>
								<div>
								<label for="admin_api_permission" >Admin API Permission:</label>
								<p class="hidden_context" style="display:none;" id="admin_api_permission_help">Please determine the permission to Admin API of the application above.</p> 
								<input class="ttFocus" aria-describedby="admin_api_permission_help" title="Please determine the permission to Admin API of the application above." type="checkbox" name="admin_api_permission" id="admin_api_permission" <?php if($admin_api_permission){?> checked <?php }?>/>&nbsp;&nbsp;
								
								<label for="direct_api_permission" >Direct API Permission:</label>
								<p class="hidden_context" style="display:none;" id="direct_api_permission_help">Please determine the permission to Direct API of the application above.</p> 
								<input class="ttFocus" aria-describedby="direct_api_permission_help" title="Please determine the permission to Direct API of the application above." type="checkbox" name="direct_api_permission" id="direct_api_permission" <?php if($direct_api_permission){?> checked <?php }?>/>
								</div>
								<div>
								<label for="disclosure_api_permission" >Disclosure API Permission:</label>
								<p class="hidden_context" style="display:none;" id="disclosure_api_permission_help">Please determine the permission to Disclosure API of the application above.</p> 
								<input class="ttFocus" aria-describedby="disclosure_api_permission_help" title="Please determine the permission to Disclosure API of the application above." type="checkbox" name="disclosure_api_permission" id="disclosure_api_permission" <?php if($disclosure_api_permission){?> checked <?php }?>/>
								</div>
							<?PHP endif ?>
							<?PHP
								$hidden_inputs = array(
									'app_id' => $app->id,
									'app_request_id' => $app->app_request_id,
									'active_page_select_from_application_save' => $active_cur_page,
									'active_items_per_page_from_application_save' => $active_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
									'pending_page_select_from_application_save' => $pending_cur_page,
									'pending_items_per_page_from_application_save' => $pending_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
									'denied_page_select_from_application_save' => $denied_cur_page,
									'denied_items_per_page_from_application_save' => $denied_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
								);
								echo form_hidden($hidden_inputs,TRUE);
							?>
						</div>
						<div class="text-right"><input class="blue-button" type="submit" value="Save"/></div>
					<?PHP echo form_close(); ?>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>