<?php
/**
* @package direct-as-a-service
* @subpackage views
* @filesource
*/ /** */

?>
<div id="pending">
	<p>This table lists the applications that are awaiting approval for access to the API services.</p>						
	<?php if(empty($pending_list)): ?>
		<div class="message">There are currently no application requests awaiting approval.</div>
	<?php else: ?>
		<table id="pending_table" class="display">
			<caption class="hidden_context">Pending Application Requests</caption>
			<thead>
				<tr class="gridheader">
					<th align="center" scope="col">Application</th>
					<th scope="col">POC</th>											
					<th scope="col">Description</th>
					<th scope="col">Requested Date</th>
					<th scope="col" width="10%" class="displaylast">Actions</th>
				</tr>
			</thead>
			<tbody>							
			<?php foreach($pending_list as $request): ?>
				<tr id="<?php echo $request->id; ?>row">
					<td class="pending_application_request_name">
						<?php echo $request->name; ?>&nbsp;
						<?php if ($request->url): ?>
							<br/><a target="_blank" href="<?php echo $request->url; ?>"><?php echo $request->url; ?></a>&nbsp;
						<?php endif ?>
						<?php if ($request->description): ?>
							<br/><?php echo $request->description; ?>&nbsp;
						<?php endif ?>
					</td>
					<td class="pending_application_request_poc">
						<?php if ($request->poc_name): ?>
							<?php echo $request->poc_name; ?>&nbsp;
						<?php endif ?>
						<?php if ($request->poc_email): ?>
							<br/><a href="mailto:<?php echo $request->poc_email; ?>"><?php echo $request->poc_email; ?></a>&nbsp;
						<?php endif ?>
						<?php if ($request->poc_phone): ?>
							<br/><?php echo $request->poc_phone; ?>&nbsp;
						<?php endif ?>
					</td>
					<td class="pending_application_request_description"><?php echo $request->justification; ?>&nbsp;</td>
					<td class="pending_application_request_date"><?php echo date("M d Y H:i:s",$request->requested_date); ?>&nbsp;</td>
					<td class="pending_application_request_actions">
						<?PHP
							echo form_open('/administration/approve_request',array('id'=>'approveForm'.$request->id,'class'=>'approveForm'));
							$hidden_inputs = array(
								'request_id' => $request->id,
								'pending_page_select_from_approve_button' => $pending_cur_page,
								'pending_items_per_page_from_approve_button' => $pending_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
								'approved_page_select_from_approve_button' => $approved_cur_page,
								'approved_items_per_page_from_approve_button' => $approved_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
								'denied_page_select_from_approve_button' => $denied_cur_page,
								'denied_items_per_page_from_approve_button' => $denied_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
							);
							echo form_hidden($hidden_inputs,TRUE);
							echo form_close();
						?>
						<div id="dialog-form<?php echo $request->id; ?>" title="Reason for Denial">
							<?PHP
								echo form_open('/administration/deny_request',array('id'=>'denyForm'.$request->id));
								echo form_label('Reason for Denial:','denial_reason'.$request->id,array('class'=>'modal'));
								echo form_textarea('reason','','id="denial_reason'.$request->id.'" class="modal"');
								$hidden_inputs = array(
									'request_id' => $request->id,
									'pending_page_select_from_deny_button' => $pending_cur_page,
									'pending_items_per_page_from_deny_button' => $pending_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
									'approved_page_select_from_deny_button' => $approved_cur_page,
									'approved_items_per_page_from_deny_button' => $approved_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
									'denied_page_select_from_deny_button' => $denied_cur_page,
									'denied_items_per_page_from_deny_button' => $denied_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
								);
								echo form_hidden($hidden_inputs,TRUE);
								echo form_close();
							?>
						</div>
						<div class="center">
							<a href="#" onclick="if (confirm('Are you sure you want to approve <?php echo html_escape($request->name); ?>?')){$('#approveForm<?php echo $request->id; ?>').submit();}" title="Approve Request: <?php echo html_escape($request->name); ?>"><img src="/images/icons/accept.png" alt="Approve Request: <?php echo html_escape($request->name); ?>" /></a>
							<a href="#" id="deny-app<?php echo $request->id; ?>" title="Deny Request: <?php echo html_escape($request->name); ?>"><img src="/images/icons/cancel.png" alt="Deny Request: <?php echo html_escape($request->name); ?>" /></a>
						</div>
					</td>
				</tr>
			<?php endforeach; ?>
			</tbody>
		</table>
	<?php endif ?>
</div>