<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
*//** */


/**
* @package direct-as-a-service
* @subpackage models
*/
class PointsOfOriginModel extends CI_Model {
	    
	function message_counts_by_application($application_id = null, $between = null, $order = 'application.name', $dir='ASC', $page_number=1, $items_per_page, $is_export = FALSE) {		
		
		$this->_set_up_message_counts_by_application($application_id, $between, $order, $dir);
		$points_of_origin = $this->db->get()->result();
		$total_size = count($points_of_origin);	//get total size 
		
		//if we need to apply pagination, pull the data again with a limit applied this time
		if(!$is_export && $total_size > $items_per_page){
			$this->_set_up_message_counts_by_application($application_id, $between, $order, $dir);
			$offset = ($page_number - 1) * $items_per_page;
			if($offset > $total_size) 
				$offset = 0;
			$this->db->limit($items_per_page, $offset);
			$points_of_origin = $this->db->get()->result();
		}
		
		$list = array();
		foreach($points_of_origin as $point_of_origin)
			$list[$point_of_origin->application_name] = $point_of_origin;
    	
		return compact('total_size', 'list');
	}
	
	/**
	* Builds base query that is reused in message_counts_by_application() method
	* Must use $this->db->get() after the method is called. 
	* @return none
	*/
	protected function _set_up_message_counts_by_application($application_id, $between, $order_by, $direction) {	
		if(is_array($between)) $between = element('call_date', $between); //we only allow one date filter for this query
		if(empty($order_by)) $order_by = 'application.name';
		if(empty($direction)) $direction = 'ASC';
		if(!empty($order_by) && string_begins_with('application_', $order_by)) $order_by = str_replace('application_', 'application.', $order_by);
		
		$this->db->select('application.name AS application_name, COUNT(request.id) AS message_count');
		$this->db->from('application');
		
		$join_clause = "request.application_id = application.id AND request.response_code=200 AND UPPER(request.call) LIKE '%SEND% POST'";
		if(!empty($between['start']) && $this->is->nonzero_unsigned_integer($between['start']))
			$join_clause .= ' AND request.call_date >= '.$between['start'];
		if(!empty($between['end']) && $this->is->nonzero_unsigned_integer($between['end']))
			$join_clause .= ' AND request.call_date <= '.$between['end'];
		$this->db->join('request', $join_clause, 'left outer', FALSE); //turn off escaping due to UPPER(); note that it is critical to make sure that any user-input data is esaped
		
		if($this->is->nonzero_unsigned_integer($application_id)){
			$this->db->where('request.application_id', $application_id);
		}
		
		$this->db->group_by('application.name, application.id');
		$this->db->order_by($order_by, $direction);
	} 
}