<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
*/

/**
* @package direct-as-a-service
* @subpackage models
*/
class FacilityModel extends CI_Model {
	
    /*
     * get all facility data by facility id
     */
    public function get_facility($id){
    	return $this->db->query('SELECT * FROM api.dbo.facility WHERE id = '. $this->db->escape($id));
    }
    
    /*
     * get the list of facilities (can be filtered)
     */
    public function get_facilities($is_active, $search_input = null){
    	if($is_active === null ) {
    		$sql = 'SELECT * FROM api.dbo.facility ';
    		if($search_input != null && $search_input != '') {
    			$sql .= 'WHERE name like \'%' . $search_input . '%\' ';
    		}
    		$sql .= 'ORDER BY LOWER(name)';
    		return $this->db->query($sql);
    	}    
    	else {
    		$sql = 'SELECT * FROM api.dbo.facility where active = ';
    		if($is_active) {
    			$is_active = 1;
    		}
    		else {
    			$is_active = 0;
    		}
    		$sql .=  $is_active;
    		if($search_input != null && $search_input != '') {
    			$sql .= ' and name like \'%' . $search_input . '%\' ';
    		}
    		$sql .= ' ORDER BY LOWER(name)';
    		return $this->db->query($sql);
    	}
    }
    
    /*
     * get the facility list size(can be filtered)
    */
    public function get_size_of_facility_list($is_active, $search_input = null){
    	if($is_active === null ) {
    		$sql = 'SELECT COUNT(*) as count FROM api.dbo.facility ';
    		if($search_input != null && $search_input != '') {
    			$sql .= 'WHERE name like \'%' . $search_input . '%\' ';
    		}
    		return $this->db->query($sql);
    	}
    	else {
    		$sql = 'SELECT COUNT(*) as count FROM api.dbo.facility where active = ';
    		if($is_active) {
    			$is_active = 1;
    		}
    		else {
    			$is_active = 0;
    		}
    		$sql .=  $is_active;
    		if($search_input != null && $search_input != '') {
    			$sql .= ' and name like \'%' . $search_input . '%\' ';
    		}
    		return $this->db->query($sql);
    	}
    }
    
    /*
     * get number of pages
     */
    public function get_facilities_by_page_number($start, $size, $search_input = null){
		if(!empty($search_input)){
			$this->db->like('name', $search_input);
		}
		return $this->db->order_by('LOWER(name)')->limit($size, $start - 1)->get('api.dbo.facility');
		
		
/*    	$sql = 'SELECT * FROM (select *, ROW_NUMBER() over (order by LOWER(name)) as row FROM facility ';
		if($search_input != null && $search_input != '') {
			$sql .= ' WHERE name like \'%' . $search_input . '%\'';
			
		}
		$sql .= ') a where row >= ' . $this->db->escape($start) . ' and row < ' . $this->db->escape($size+$start);
    	return $this->db->query($sql); */
    }
	
    /*
     * get the first load facilities
     */
	// VAD-732 H.G. 11/10/2014
	function get_first_facilities($size){ //get response when no filters for first page
		$this->_set_up_report_columns();  
		$this->db->group_by('facility.id, facility.name');
		$this->db->order_by('LOWER(facility.name) ASC');
		$this->db->limit($size);
		return $this->db->get();
	}
	
	/*
     * get the list of facilities size
     */
	 
	public function get_facility_list_size()//get size of entire list
	{
		return $this->db->query('SELECT COUNT(*) as count from api.dbo.facility');
	}
	
	/*
     * get the list of facilities reports
     */
    //deprecated, just use get_facility_list_size()
	public function get_facility_list_size_reports()//get size of entire for reports
	{
		return $this->get_facility_list_size();
	}
	
	/*
     * get the list of facilities and where 
     */
	 
	public function get_facility_list_size_reports_sql($sql)//get size of entire for reports
	{
		return $this->db->query('SELECT count(distinct facility.id) as count ' .
								'FROM [api].[dbo].[facility] facility left join [mail].[dbo].[mailboxes] mailboxes ' .
								'ON facility.id = mailboxes.facility_id left join [mail].[dbo].[messages] messages ' .
								'ON messages.mailbox_id = mailboxes.id WHERE ' . $sql);
		
	}
	
	/*
     * get the list of facilities and different orders
     */
	// VAD-732 H.G. 11/10/2014
	//TODO - we should not be passing where clauses as a string that can't be escaped by CI- $sql should be simplified or just applied before this method -- MG 2014/12/2
	function get_request_filter_facility_order($sql,$order,$start,$size){//get response with filters
		$sql= str_replace('(id','(facility.id',$sql);//needed because both tables have the same column name
		$this->db->limit($size, $start - 1);

		return $this->get_request_filter_facility_order_export($sql,$order,$start,$size);
	}
	
	/*
     * get the list of facilities export
     */
	// VAD-732 H.G. 11/10/2014
	//TODO - we should not be passing where clauses as a string that can't be escaped by CI- $sql should be simplified or just applied before this method -- MG 2014/12/2	
	function get_request_filter_facility_order_export($sql,$order,$start,$size){//get response with filters
		$this->_set_up_report_columns();
		$this->db->where($sql, null, false);
		$this->db->group_by('facility.id, facility.name');
		$this->_apply_report_order_by($order);
		return $this->db->get();
	}
	
	/*
     * get the list of facilities
     */
	// VAD-732 H.G. 11/10/2014
	//TODO - we should not be passing where clauses as a string that can't be escaped by CI- $sql should be simplified or just applied before this method -- MG 2014/12/2		
	function get_request_filter_facility($sql,$order,$start,$size){
 		$this->db->limit($size, $start - 1);
		return $this->get_request_filter_facility_order_export($sql,$order,$start,$size);
	}
	
    /*
     * update the facility with passed values
     */
    public function save_facility($id, $name, $active) {	
		$user_id = $this->encrypt->decode($this->session->userdata('user_id'));
    	$permissions = $this->permissions->get_user_permissions($user_id);
    	$active_value = 0;
    	if($active == 'on') {
    		$active_value = 1;
    	}
    	
    	if($permissions['API']['admins']) {
			//$fac = $this->get_facility($id)->result(); //get app data from before change
			if($id != null) {
				return $this->db->query('UPDATE api.dbo.facility SET name = '.$this->db->escape($name).',active = '.$this->db->escape($active_value).' WHERE id = '.$this->db->escape($id));
			}
			else {
				return $this->db->query('INSERT INTO api.dbo.facility (name, active) VALUES (' . $this->db->escape($name). ',' . $this->db->escape($active_value) . ')');
			}
			
    	}
    	else {
    		return FALSE;
    	}
    }
    
    /*
     * Create a new facility, and give it permissions to access the Direct API
     */
    public function create_facility($name, $is_active){
		$this->load->model('usersmodel');
		//create facility in database
		$failed = FALSE;
    	$query = $this->db->query('INSERT INTO api.dbo.facility (name, public_key, private_key, url, description, poc_name, poc_email, poc_phone, app_request_id) VALUES ('.$this->db->escape($name).','.$this->db->escape($public).','.$this->db->escape($private).','.$this->db->escape($url).','.$this->db->escape($desc).','.$this->db->escape($poc_name).','.$this->db->escape($poc_email).','.$this->db->escape($poc_phone).','.$this->db->escape($request_id).')');
		//create facility in LDAP
		if($query) {
			$app_id = $this->get_facility_id_from_public($public);
			$ldap_conn = $this->prepare_ldap_conn();
			$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_ADMIN_USERNAME, LDAP_ANON_ADMIN_PASSWORD); //TO-DO: change bind to current user when permissions are set up
			if($ldap_bind) {
				$app_attributes = array(
					'objectClass' => array('organizationalUnit','top','uidObject'),
					'ou' => $name,
					'uid' => $app_id,
				);
				$requestor_username = $this->usersmodel->get_username_from_id($requestor);
				$admins_attributes = array(
					'objectClass' => 'groupOfNames',
					'cn' => $name.' Administrators',
					'member' => array(LDAP_ANON_ADMIN_USERNAME),
				);
				$users_attributes = array(
					'objectClass' => 'groupOfNames',
					'cn' => $name.' Authorized Users',
					'member' => array(LDAP_ANON_ADMIN_USERNAME),
				);
				if(!empty($requestor_username)) {
					$admins_attributes['member'][1] = $this->usersmodel->get_dn_from_username($requestor_username); //put the requestor in the admins group
					$users_attributes['member'][1] = $this->usersmodel->get_dn_from_username($requestor_username); //put the requestor in the users group
				}
				
				$create_app_in_ldap = ldap_add($ldap_conn, $this->get_dn_from_app_id($app_id), $app_attributes);
				if($create_app_in_ldap) {
					$create_admins_group = ldap_add($ldap_conn, $this->get_admins_dn_from_app_id($app_id), $admins_attributes);
					$create_users_group = ldap_add($ldap_conn, $this->get_users_dn_from_app_id($app_id), $users_attributes);
					$give_api_access = ldap_mod_add($ldap_conn,LDAP_DIRECT_API_PERMISSIONS_GROUP,array('member' => $this->get_dn_from_app_id($app_id)));
					//when a problem comes along, you must whip it... and set this boolean to true
					if(!$create_admins_group || !$create_users_group || !$give_api_access) { $failed = TRUE; }
					else { return TRUE; } //if no problems, we succeeded
				}
				else { $failed = TRUE; }
			}
			//if we failed to create the facility in LDAP for any reason, we need to get rid of the bad data we have created
			if($failed) {
				//get rid of the app in LDAP
				$remove_api_access = ldap_mod_del($ldap_conn,LDAP_DIRECT_API_PERMISSIONS_GROUP,array('member' => $this->get_dn_from_app_id($app_id)));
				$delete_admins_group = ldap_delete($ldap_conn, $this->get_admins_dn_from_app_id($app_id));
				$delete_users_group = ldap_delete($ldap_conn, $this->get_users_dn_from_app_id($app_id));
				$delete_app_in_ldap = ldap_delete($ldap_conn, $this->get_dn_from_app_id($app_id));
				//get rid of the app in database
				$this->db->query('DELETE FROM api.dbo.facility WHERE id='.$this->db->escape($app_id));
			}
		}
		return FALSE;
    }
	
	public function get_facilities_by_name($part_of_name) {
		return $this->db->query("SELECT * FROM api.dbo.facility WHERE LOWER(name) LIKE " .$this->db->escape("%". $part_of_name . "%"));
	}
	
	/* -----------------------------*
	 *  PRIVATE FUNCTIONS           *
	 * -----------------------------*/
	 
	/* This function prepares a connection to LDAP using the configured constants for the facility
	  * and the LDAP options required for the connection. Returns FALSE on failure, LDAP connection resource
	  * on success.
	  */
	 protected function prepare_ldap_conn() {
		$ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) { return FALSE; } 
		if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) { return FALSE; }
		return $ldap_conn;
	}

	// VAD-732 H.G. 11/10/2014
	//helper method for various report methods
	protected function _set_up_report_columns() {
   		$this->db->select('facility.id, facility.name');
		$this->db->select('COUNT(DISTINCT(CASE WHEN mailboxes.is_group=0 THEN mailboxes.id END)) AS Number_of_users', false);
		$this->db->select('COUNT(DISTINCT(CASE WHEN mailboxes.is_group=1 THEN mailboxes.id END)) AS Number_in_group', false);
		$this->db->select('COUNT(DISTINCT(CASE WHEN messages.sent=1 THEN messages.id END)) AS Number_of_sent', false);
		$this->db->select('COUNT(DISTINCT(CASE WHEN messages.draft=1 THEN messages.id END)) AS Number_of_drafts', false);
		$this->db->select('COUNT(DISTINCT(CASE WHEN (messages.sent=0 AND messages.draft=0) THEN messages.id END)) AS Number_of_seen', false); //note that this is actually the number of incoming messages, not seen
		$this->db->select('COUNT(DISTINCT messages.id) AS Total_messages', false);
		//nested queries don't work with active record limit(), so refactored to use the above - seems to be accurate */
		/*$this->db->select('ISNULL((SELECT COUNT(is_group) FROM [mail].[dbo].[mailboxes] WHERE facility_id = facility.id AND is_group = 0 GROUP BY facility_id),0) AS Number_of_users', false);
		$this->db->select('ISNULL((SELECT COUNT(is_group) FROM [mail].[dbo].[mailboxes] WHERE facility_id = facility.id AND is_group != 0 GROUP BY facility_id),0) AS Number_in_group', false);
		$this->db->select('ISNULL(SUM(messages.sent), 0) AS Number_of_sent', false);
		$this->db->select('ISNULL(SUM(messages.draft), 0) AS Number_of_drafts', false);
		$this->db->select('COUNT(messages.id) - ISNULL(SUM(messages.sent),0) AS Number_of_seen', false);
		$this->db->select('COUNT(messages.id) AS Total_messages', false);*/
		$this->db->from('api.dbo.facility');
		$this->db->join('mail.dbo.mailboxes', 'facility.id = mailboxes.facility_id', 'left'); 
		$this->db->join('mail.dbo.messages', 'messages.mailbox_id = mailboxes.id', 'left'); 		
	}

	// VAD-732 H.G. 11/21/2014
	//helper method to a couple of the methods used to generate report data
	//deprecated, exists to support legacy code
	//new code should just apply an active record order by in the controller instead of going the roundabout route of passing a SQL string that needs to be parsed to the model
	protected function _apply_report_order_by($order) {
		$sort_direction = 'ASC';
		if(preg_match('/(\s)+desc(.)*(\s)+desc/i', $order)) {
			// xxxxx DESC, xxxxx DESC
			$sort_direction = 'DESC';
		}

		//Name	
		if ($order == 'name' || preg_match('/^(name(\s)+(desc|asc)(\s)*,id(\s)+(desc|asc))$/i', $order)) {
			return $this->db->order_by('LOWER(facility.name)', $sort_direction);
		}
		//Seen
		if ( $order == 'received' || preg_match('/^(received(\s)+(desc|asc)(\s)*,id(\s)+(desc|asc))$/i', $order)) {
			// received DESC,id DESC or received ASC,id ASC
			return $this->db->order_by('COUNT(DISTINCT(CASE WHEN (messages.sent=0 AND messages.draft=0) THEN  messages.id END))', $sort_direction);
		}
		//Number_of_users
		if ($order == 'user' || preg_match('/^(user(\s)+(desc|asc)(\s)*,id(\s)+(desc|asc))$/i', $order)) {
			// user DESC,id DESC or user ASC,id ASC
			return $this->db->order_by('(SELECT COUNT(is_group) FROM [mail].[dbo].[mailboxes] WHERE facility_id = facility.id AND is_group = 0 GROUP BY facility_id)', $sort_direction);
		}		
		//Sent
		if($order == 'sent' || preg_match('/^(sent(\s)+(desc|asc)(\s)*,id(\s)+(desc|asc))$/i', $order)) {
			// sent DESC,id DESC or sent ASC,id ASC
			return $this->db->order_by('SUM(messages.sent)', $sort_direction);
		}
		//Total
		if ($order == 'total' || preg_match('/^(total(\s)+(desc|asc)(\s)*,id(\s)+(desc|asc))$/i', $order)) {
			// total DESC,id DESC or total ASC,id ASC
			return $this->db->order_by('(COUNT(DISTINCT(CASE WHEN (messages.sent=0 AND messages.draft=0) THEN messages.id END)) + COUNT(DISTINCT(CASE WHEN messages.sent=1 THEN messages.id END)))', $sort_direction);
		}		
		//Group
		if ($order == 'group' || preg_match('/^(group(\s)+(desc|asc)(\s)*,id(\s)+(desc|asc))$/i', $order)) {
			// group DESC,id DESC or group ASC,id ASC
			return $this->db->order_by('(SELECT COUNT(is_group) FROM [mail].[dbo].[mailboxes] WHERE facility_id = facility.id AND is_group != 0 GROUP BY facility_id)', $sort_direction);
		}

		return $this->error->should_be_a_recognized_order_by_clause($order);
	}
}
