<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models-folder
* @filesource
*/

/** */
require_model('entity');

/**
* @package direct-as-a-service
* @subpackage models
*/
class Authentication_log_entry extends DAAS_Entity {
	static $table = 'logins';
	protected static $_relationships = array('user' => array( 'type' => 'belongs_to','model'=> 'user','related_foreign_key' => 'org_id','key_for_relationship' => 'user_org_id'));
	
	protected $_readonly_fields = array( 'session_id', 
										 'ip_address', 
										 'login_time', 
										 'org_id'); 		
	
	public function human_readable_login_time($format = 'm/d/Y h:i:s A'){
		return date($format, $this->login_time);
	}
 
 	public function username(){
		if(array_key_exists('username', $this->_values)) return $this->_values['username'];
 		$user = $this->user;
 		if(!User::is_an_entity($user)) return '';
 		return $user->username;
 	}

	public function values_for_export(){
		$values = $this->values();
		$values['login_time'] = $this->human_readable_login_time();
		return $values;
	}

 	//////////////////////
 	// DATA MANAGEMENT
 	//////////////////////
	
	protected function _run_before_create(){ 
		if(!parent::_run_before_create()) return false;
		
		//populate readonly values
		$hooray = true;
		$hooray = $this->_set_field_value('session_id', session_id(), $error_offset = 0, $override_validation = TRUE) && $hooray;
		$hooray = $this->_set_field_value('ip_address', $_SERVER['HTTP_X_REAL_IP'], $error_offset = 0, $override_validation = TRUE) && $hooray;
		$hooray = $this->_set_field_value('login_time', time(), $error_offset = 0, $override_validation = TRUE) && $hooray;
		
		$organization_id = get_instance()->authentication->organization_id;
		$hooray = $this->_set_field_value('org_id', !is_numeric($organization_id) ? 0 : $organization_id, $error_offset = 0, $override_validation = TRUE) && $hooray;
		
		return $hooray; 
    }	
 	
 	
 	//////////////////////
 	// STATIC
 	//////////////////////
	
	public static function login_success($message){
		return static::create(array('success' => true, 'error_msg' => $message));
	}
	
	public static function login_failure($message){
		return static::create(array('success' => false, 'error_msg' => $message));
	} 
 	
 	public static function count_for_reports($id_or_conditions=array(), $ignore_null = FALSE){
		static::db()->join('users', 'logins.org_id=user_org_id', 'left outer');
		if($ignore_null){
			// do not show logins by NULL users
			static::db()->where('user_id is NOT NULL', NULL, FALSE);
		}
 		return static::count(static::fix_report_conditions($id_or_conditions));
 	}
 	
 	public static function find_for_reports($id_or_conditions=array(), $key_by = null){
 		static::db()->select('logins.*, users.username AS username');
 		static::db()->join('users', 'logins.org_id=user_org_id', 'left outer');
 		return static::find(static::fix_report_conditions($id_or_conditions), $key_by);
 	}

 	//compensate for the truly terrible practices of the developers who created the adhoc reports and cursed us all by saving horrible SQL to the database to be reused forever
 	protected static function fix_report_conditions($id_or_conditions){
 		if(!empty($id_or_conditions) && is_string($id_or_conditions) && !is_numeric($id_or_conditions)){
 			$id_or_conditions = trim(str_replace('0=0 AND', '', trim($id_or_conditions)));
 			$id_or_conditions = str_replace('[id]', '[logins].[id]', $id_or_conditions);
 			$original_id_or_conditions = $id_or_conditions;
 			$id_or_conditions = preg_replace('/[^a-zA-Z0-9_\.]id[^a-zA-Z0-9_-]/', 'logins.org_id', $id_or_conditions);
 			if(string_begins_with('id', $id_or_conditions)) $id_or_conditions = 'logins.'.$id_or_conditions;
 		}
 		return $id_or_conditions;
 	}
	
	



}