<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
*//** */


/**
* @package direct-as-a-service
* @subpackage models
*/
class Application_account extends DAAS_Entity  {
	static $database_group = 'db';
	static $table = 'application_account_link';	
	
	protected static $_relationships = array( 'account_request' => array('type' => 'belongs_to', 'key_for_relationship' => 'user_org_id', 'related_foreign_key' => 'org_id'),
											  'application' => array('type' => 'belongs_to', 'related_foreign_key' => 'app_id'),
											  'user' => array('type' => 'belongs_to', 'key_for_relationship' => 'user_org_id', 'related_foreign_key' => 'org_id'),
											);

	protected $_property_validation_rules = array('app_id' => 'unsigned_integer',
												  'org_id' => 'unsigned_integer');
												  
	protected $_readonly_fields = array( 'created_at', //autogeneraetd on create
										 'unique_id'); //autogenerated from org_id and app_id on create

	
	/** @return boolean */
	public function is_active(){
		if(!$this->is_approved()) return false;
		$user = $this->user;
		return User::is_an_entity($user) && $user->is_active();		
	}
	
	/** @return boolean */
	public function is_approved(){
		$user = $this->user;
		return User::is_an_entity($user);
	}
	
	/** @return boolean */
	public function is_registered(){
		if($this->is_approved()) return true;
		$account_request = $this->account_request;
		return Account_request::is_an_entity($account_request) && ($account_request->is_pending() || $account_request->is_approved());
	}

	/** @return boolean */
	public function is_denied(){
		if($this->is_active()) return false;
		$account_request = $this->account_request;
		return Account_request::is_an_entity($account_request) && $account_request->is_denied();		
	}

	/** @return string */
	public function status(){
		if($this->property_is_empty('org_id')) return 'Unregistered';
		$account_request = $this->account_request;
		if(!Account_request::is_an_entity($account_request)) return 'Unregistered';
		return $account_request->status;
	}

	/** @return string */
	public function url_to_authorize($destination_after_save){
		$url = 'https://' . API_ADMINPANEL_DOMAIN . '/authorize/register/id/' . $this->app_id . "/unique/" .$this->unique_id;	
		if(!empty($destination_after_save))
			$url .= '/destination/'.rawurlencode(base64_encode($destination_after_save));
		return $url;
	}

	/** @return array */
	public function values_for_api($destination_after_save = ''){
		$account_request = $this->account_request;
		
		$values = array('is_registered' => $this->is_registered(),
						'is_approved' => $this->is_approved(),
						'is_denied' =>  Account_request::is_an_entity($account_request) && $account_request->denied,
						'is_active' => $this->is_active(),
						'status' => $this->status(),
						'authorize_url' => $this->url_to_authorize($destination_after_save),
						'organization_id' => $this->org_id);
						
		if($this->is_active())
			$values = array_merge($this->user->values_for_api(), $values);							
		elseif($this->is_registered){
			$values = array_merge($this->account_request->values_for_api(), $values);
		}
						
		return $values;
	}

//////////////////////////
// DATA MANAGEMENT
//////////////////////////

	/** @return true */
	protected function _run_before_create(){ 
		if(!parent::_run_before_create()) return false;
		
		if(!isset($this->app_id))
			return $this->error->warning('Unable to create a new '.$this->model_alias.' without an application id.  Current values: '.$this->error->describe($this->values()));
			
		if(!isset($this->org_id))
			return $this->error->warning('Unable to create a new '.$this->model_alias.' without an organization id.  Current values: '.$this->error->describe($this->values()));
			
		
		$success = $this->_set_field_value('created_at', now(), $error_offset = 0, $override_validation = TRUE);
		$success = $success && $this->_set_field_value('unique_id', hash_hmac('sha256', $this->org_id, $this->application->private_key), $error_offset = 0, $override_validation = TRUE);
		
        return $success; 
    }	

}