<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
*//** */


/**
* @package direct-as-a-service
* @subpackage models
*/
class Account_request extends DAAS_Entity {
	
	static $table = 'account_request';
	
	protected static $_relationships = array( 'application_account' => array('type' => 'has_many',  'foreign_key' => 'org_id', 'related_foreign_key' => 'org_id', 'key_for_relationship' => 'user_org_id'), 
											  'user' => array('type' => 'belongs_to', 'key_for_relationship' => 'user_org_id', 'related_foreign_key' => 'user_org_id'));
	
	public function user_is_deactivated(){
		$user = $this->user;
		return User::is_an_entity($user) && !$user->is_active();
	}
	
	public function is_approved(){
		return !$this->is_denied() && !$this->is_pending();
	}
	
	public function is_denied(){
		return $this->denied;
	}
	
	public function is_pending(){
		return !$this->is_denied() && $this->property_is_empty('approved_date');
	}
	
	public function is_registered(){
		if($this->is_approved()) return true;
		return $this->is_pending();
	}
	
	public function status(){
		if($this->denied) return 'Denied';
		if($this->property_is_empty('approved_date')) return 'Pending';
		return 'Approved';
	}

	function values_for_api(){
		$values = $this->values(array('id', 'username', 'first_name', 'middle_name', 'last_name', 'department', 'organization', 'location', 'telephone', 'mobile', 'facility_id'));
		$values['external_email'] = $this->ext_mail;
		$values['organization_id'] = $this->user_org_id;
		return $values;
	}
	
	public static function find_from_session(){
		$user_org_id = User::organization_id_from_session();
		if(!empty($user_org_id)){
			static::db()->order_by('request_date', 'desc');
			return static::find_one(compact('user_org_id'));
		}
	}
	
	protected function _run_after_create(){
		if(!empty($this->id())){
			$CI = get_instance();
			$CI->load->library('eventlog');
			$CI->eventlog->create_event(4, $this->id(), 4, $this->id(), 'Requested account', time(), 1);
		}
		return parent::_run_after_create(); 
	}	
	
	protected function _run_before_create(){ 
		if(!parent::_run_before_create()) return false;
		
		if(!isset($this->request_date))
			return $this->_set_field_value('request_date', now(), $error_offset = 0, $override_validation = TRUE);
		
		return true;
    }	
	
}
