<?php
/**
* Partial that generates the markup for a group of form fields.
*
* This partial generates the markup for the form fields <i>only</i> and is used by the {@link Field_markup_generator::field_markup() field_markup()} method.  For the 
* partial that generates both fields and label within a standard markup container, see {@link _field_group.php}.  
*
* Form markup generator partials are designed to follow object-oriented-esque patterns of inheritance.  This partial will by default be used by the 
* {@link Field_group_markup_generator} and all of its children that do not have a partial named after their {@link Field_markup_generator::$_type type}.
* If you wish to override this partial in your application, please follow the instructions in the "Partials and Markup Generation" section of the
* {@link Field_markup_generator} class documentation.
*
* Like all {@link Field_markup_generator} partials, this partial expects to be passed a copy of the markup generator calling it, called $markup_generator.
*
* @package vler
* @subpackage form-markup-generator
*
* @author M. Gibbs <gibbs_margaret@bah.com> Last updated 2012-08-02
*/

if(!isset($markup_generator) || !is_a($markup_generator, 'Field_markup_generator'))
	$this->error_helper->should_be_a_field_markup_generator($markup_generator);

?>
<table class="table table-condensed">
	<tr><th>#</th><th>Given Name</th><th>Family Name</th><th>Social Security Number</th><th>Purpose of Disclosure</th><th></th></tr>
<?php foreach($markup_generator->field_names as $key => $field_name): ?>
	<tr>
		<th scope="row" class="row-number"><?php echo $key + 1 ?></th>
	<?php foreach($markup_generator->field($field_name)->field_names as $subfield_name): ?>
		<td><?php echo $markup_generator->field($field_name)->field($subfield_name)->field_markup(); ?></td>
	<?php endforeach ?>
		<td>
		<?php if($key == array_last_key($markup_generator->field_names)): ?>
			<!-- <a href="#" class="btn" title="Click to add information about another patient" onclick="daas.patientDisclosures.addRow($(this).closest('tr'));">Add Patient</a> -->
		<?PHP endif ?>
		</td>
	</tr>
<?php endforeach ?>
</table>