<?php
/**
* @package vler
* @subpackage form-markup-generator
*/

/** require parent file */
require_library('form_markup_generator/field_markup_generators/field_group');

/**
* @package vler
* @subpackage form-markup-generator
*/
class Checkbox_group_markup_generator extends Field_group_markup_generator{
	protected $_type = 'checkbox_group';
	protected $inline = false;
	protected $_options = array();
	protected $_property_validation_rules = array('options' => 'array');

	protected function load_field_generators(){
		if(!$this->inline){
			$this->_width_class = '';
			$this->_label_width_class = '';
		}
		
		if(isset($this->options)){
			foreach($this->options as $name => $label_text){
				$this->_field_templates[$name] = array('type' => 'checkbox', 'label_text' => $label_text);
			}
		}
		
		parent::load_field_generators();
	}
	
}