<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
* @package direct-as-a-service
* @subpackage controllers
*//** */

require_once APPPATH.'controllers/services/mailbox_controller.php';

/**
* @todo Consider abandoning the 'mailbox' parameter and using a 'user' parameter instead
* 
* @package direct-as-a-service
* @subpackage controllers
*/
class User_controller extends Mailbox_controller{

	protected $user;
	
	function __construct(){
		parent::__construct();
		
		if($this->mailbox->is_group){
			$this->response('Mailbox "'.$this->mailbox->name.'" is not a personal mailbox.', 422);
		}
	
		$this->user = $this->mailbox->user;
		if(!User::is_an_entity($this->user))
			$this->response('Mailbox "'.$this->mailbox->name.'" is not a personal mailbox.', 422);
	}
	
	/**
	* Outputs an array of mailboxes that belong to the specified user.
	*
	* Note that only active mailboxes are listed.  Personal mailbox will be listed first.  Unseen message count corresponds to the inbox only.
	*
	* @todo Allow user to specify some kind of order
	* @todo Allow user to specify a limit on the number of mailboxes to retrieve
	* @todo Search criteria for mailbox?
	*
	* @param string $mailbox Mailbox (non-group) name (required)
	* @return string $user Username for the user
	* @return string $mailboxes Array of mailbox information for this user, formatted array($mailbox_id => array('id', 'name', 'is_group', 'facility_id', 'unseen_message_count')
	*/
	function mailboxes_get(){
		$this->respond_with_error_if_fields_are_missing();
		$this->respond_with_error_if_user_is_unauthorized('retrieve');
		$this->respond_with_error_if_fields_are_invalid();
		
		$mailboxes = array($this->mailbox->id => $this->mailbox->values_for_api());
		$mailboxes = $mailboxes + collect('values_for_api', $this->user->groups(array('is_active' => true)));
		
		$this->response(array('user' => $this->user->username, 'mailboxes' => $mailboxes), 200);
	}
}