<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * @package direct-as-a-service
 * @subpackage controllers
 *//** */

require_once APPPATH.'controllers/admin/Reports.php';

class Mail_report_controller extends Reports{

    public function index($adhoc_report_id = null){
        //print indicator from adhoc report page print link
        $adhoc_print_page = $this->input->post('adhoc_print_page',TRUE);
        $data['title'] = 'Direct API: Reports';
        $data['active_tab'] = array('reports'=>true);
        $data['timezone_abbr'] = $this->locale->timezone_abbr_from_name(date_default_timezone_get());
        $data['tabs'] = $this->create_tabs("mail_report");
        //get user id from session to get permissions
        $permissions = $this->account_permissions;
        $data['show'] = $this->show;
        $data['time'] = date('m/d/Y h:i:s A', time());
        $data['user'] = $this->session->userdata('user_info')['first_name']. ' ' .$this->session->userdata('user_info')['last_name'];
        $response_list = $response_export_list = array();
        $selected = array();

        if(!$data['show']['reports']) { show_error('Forbidden',403); }
        $successful = $this->input->post('sender_type',TRUE);//gets selected
        $export_file_name = $this->input->post('export_file_name',TRUE);

        if($successful){//checks to see if there is an application selected.  This shows whether or not this is the first time the page has loaded.
            //adds each component type into its own json
            $selector = array(
                'success' =>  $this->input->post('successful',TRUE),
                'mdn' =>  $this->input->post('mdn',TRUE),
                'inbound_outbound' => $this->input->post('bound',TRUE),
                'protected_data' => $this->input->post('protected_data',TRUE),

            );

            $items = array(
                'id' => $this->search_type($this->input->post('id',TRUE),$this->input->post('id_type',TRUE)),
                'size'=>$this->search_type($this->input->post('file_size',TRUE),$this->input->post('file_size_type',TRUE)),
                'attachment_types'=>$this->search_type($this->input->post('attachment_type',TRUE),$this->input->post('attachment_type_type',TRUE)),
                'sender'=>$this->search_type($this->input->post('sender',TRUE),$this->input->post('sender_type',TRUE)),
                'recipient'=>$this->search_type($this->input->post('recipient',TRUE),$this->input->post('recipient_type',TRUE)),
            );
            $end_date = $this->input->post('end_date',TRUE);
            $start_date = $this->input->post('start_date',TRUE);
            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);

            $between = array(
                'time' => $this->check_paired_dates($start_date,$end_date)
            );

            $typesearch = array (
            );

            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);
            $is_export = FALSE;
            if($export) { $is_export = 'excel'; }
            else if($export_pdf) { $is_export = 'pdf'; }
            else if($print_page == 1) { $is_export = 'print'; }
            $data['is_export'] = $is_export;

            $dir = $this->direction_check($this->input->post('order',TRUE),$this->input->post('lastorder',TRUE),$this->input->post('direction',TRUE),$this->input->post('change',TRUE));
            $export = $this->input->post('export',TRUE);
            $order = $this->input->post('order',TRUE);
            $response = $this->reports_helper('mail',$items,$between,$selector,$typesearch,$order,$dir,$this->destination_page,$export,$this->items_per_page);
            //Set new Adhoc query with new filters
            $response_adhoc = $this->reports_helper_adhoc('mail',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$this->destination_page,$export,$this->items_per_page);
            $event_list = $response['response'];
            $form_data = $this->input->post(NULL,TRUE);
            $form_data['start_date'] = $this->reports_correct_out_of_bound_date($start_date);
            $form_data['end_date'] = $this->reports_correct_out_of_bound_date($end_date);

            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $size = $response['size'];
            if($selector['success'] == 1) { array_push($selected, 'Success: True'); }
            else if($selector['success'] == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'Success: False'); }
            if($selector['mdn'] == 1) { array_push($selected, 'MDN: True'); }
            else if($selector['mdn'] == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'MDN: False'); }
            if($selector['protected_data'] == 1) { array_push($selected, '7332 Protected Data: True'); }
            else if($selector['protected_data'] == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, '7332 Protected Data: False'); }
            if($selector['inbound_outbound'] == 1) { array_push($selected, 'Direction: Inbound'); }
            else if($selector['inbound_outbound'] == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'Direction: Outbound'); }
            //For ExportPDF, PRINT
            if($is_export) {
                $response_export = $this->reports_helper('mail',$items,$between,$selector,$typesearch,$order,$dir,$this->destination_page,$export,$size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items,$between,$selected,null);
            }
        } else if ($adhoc_report_id != ''){
            /*Adhoc Report - Starts Here*/

            //Security Check
            $result_security = $this->adhoc_report_security_check($adhoc_report_id);
            if($result_security==FALSE){
                //Load Error Page
                show_404();
                return;
            }

            $adhoc_report = $this->adhocreportsmodel->get_adhoc_report_by_id($adhoc_report_id, "mail")->result();
            //Filters and Data from db
            if(!isset($adhoc_report[0])){
                show_404();
            }
            $report_selector = str_replace('%', '###', $adhoc_report[0]->report_selector);
            $filters_used = $this->adhocreportsmodel->get_selected_filter_array_from_db($report_selector);
            if(!array_key_exists('protected_data',$filters_used)){
                $filters_used['protected_data'] = '(ALL)';
            }
            $successful = $filters_used['successful'];

            //Different time perios for adhoc report
            $diff_time_period =  $this->input->post('time_period',TRUE);

            //Get Date information
            $time_period_field = $adhoc_report[0]->report_time_field;
            $time_start_check =  $filters_used['start_date'];
            $time_end_check =  $filters_used['end_date'];

            //Display Information
            $form_data['report_created_time']= $adhoc_report[0]->report_created_time;
            $form_data['report_name'] = $adhoc_report[0]->report_name;
            $form_data['report_description'] = $adhoc_report[0]->report_description;
            $form_data['report_created_by'] = $adhoc_report[0]->username;
            $form_data['adhoc_report_id'] = $adhoc_report_id;

            if($diff_time_period != ''){
                //Calculate_new_dates
                $diff_period_start = $this->return_different_start_date($diff_time_period);

                $diff_period_end = $this->return_different_end_date($diff_time_period);
                $sql_query_generator_array = $adhoc_report[0]->report_query_generator;

                //Create new Query based on the different time selected
                $sql = $this->create_different_time_period_query($sql_query_generator_array,$time_start_check,$time_end_check,$time_period_field,$diff_period_start,$diff_period_end);

                //Date information
                $start_date = date('m/d/Y h:i:s A',$diff_period_start);
                $end_date = date('m/d/Y h:i:s A',$diff_period_end);
            } else {
                //calls helper to get data
                $sql = $adhoc_report[0]->report_query_generator;

                //Date information
                $end_date =  $filters_used['end_date'];
                $start_date =  $filters_used['start_date'];
            }

            //Assign data to report fields
            $selector = array(
                'success' =>  $filters_used['successful'],
                'mdn' =>  $filters_used['mdn'],
                'inbound_outbound' => $filters_used['bound'],
                'protected_data' =>  $filters_used['protected_data'],
            );

            $items = array(
                'id' => $this->search_type($filters_used['id'],$filters_used['id_type']),
                'size'=>$this->search_type($filters_used['file_size'],$filters_used['file_size_type']),
                'attachment_types'=>$this->search_type($filters_used['attachment_type'],$filters_used['attachment_type_type']),
                'sender'=>$this->search_type($filters_used['sender'],$filters_used['sender_type']),
                'recipient'=>$this->search_type($filters_used['recipient'],$filters_used['recipient_type']),
            );

            //$date_array = array($end_date, $start_date);
            $date_warning_message = $this->get_paired_dates_filter_validation_message($start_date, $end_date);

            $between = array(
                'time' => $this->check_paired_dates($start_date,$end_date)
            );

            $typesearch = array (
            );

            $this->items_per_page = $filters_used['items_per_page'];
            $export = $this->input->post('export',TRUE);
            $export_pdf = $this->input->post('export_pdf',TRUE);
            $print_page = $this->input->post('print_page',TRUE);

            $is_export = FALSE;
            if($export) { $is_export = 'excel'; }
            else if($export_pdf) { $is_export = 'pdf'; }
            else if($print_page == 1) { $is_export = 'print'; }
            $data['is_export'] = $is_export;

            $dir = $adhoc_report[0]->report_order_by_direction;
            $export = false;
            $order = $adhoc_report[0]->report_order_by;
            $page=1;
			if(empty($sql)) $sql = array();
            $responses_list = Mail_log_entry::find($sql);
            $event_list = $responses_list;
            $form_data['direction'] = $dir;
            $form_data['cur_page'] = $this->destination_page;
            $form_data['date_warning_message'] = $date_warning_message;
            $size = Mail_log_entry::count($sql);
            if($selector['success'] == 1) { array_push($selected, 'Success: True'); }
            else if(mb_strtoupper($selector['success']) == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'Success: False'); }
            if($selector['mdn'] == 1) { array_push($selected, 'MDN: True'); }
            else if(mb_strtoupper($selector['mdn']) == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'MDN: False'); }
            if($selector['inbound_outbound'] == 1) { array_push($selected, 'Direction: Inbound'); }
            else if(mb_strtoupper($selector['inbound_outbound']) == '(ALL)') { array_push($selected, null); }
            else { array_push($selected, 'Direction: Outbound'); }

            //For ExportPDF, PRINT
            if($is_export) {
                $response_export = $this->reports_helper('mail',$items,$between,$selector,$typesearch,$adhoc_report[0]->report_order_by,$dir,$this->destination_page,$export,$size);
                $response_export_list = $response_export['response'];
                $data['filters'] = $this->export_info($items,$between,$selected,null);
            }
            $response_adhoc = $this->reports_helper_adhoc('mail',$items,$between,$selector,$typesearch,$this->input->post('order',TRUE),$dir,$this->destination_page,$export,$this->items_per_page);
            $form_data['order'] = $order;
            //set form filters
            $form_data['id'] = $filters_used['id'];
            $form_data['successful'] = $filters_used['successful'];
            $form_data['mdn'] = $filters_used['mdn'];
            $form_data['id_type'] = $filters_used['id_type'];
            $form_data['bound'] = $filters_used['bound'];
            $form_data['protected_data'] = $filters_used['protected_data'];
            $form_data['sender'] = $filters_used['sender'];
            $form_data['recipient_type']= $filters_used['recipient_type'];
            $form_data['recipient']= $filters_used['recipient'];
            $form_data['sender_type'] = $filters_used['sender_type'];
            $form_data['file_size'] = $filters_used['file_size'];
            $form_data['file_size_type'] = $filters_used['file_size_type'];
            $form_data['attachment_type'] =$filters_used['attachment_type'];
            $form_data['attachment_type_type'] = $filters_used['attachment_type_type'];
            $form_data['end_date'] = $end_date;
            $form_data['start_date'] =  $start_date;
            $data['form_data'] = $form_data;


        } else{//if this is the first time you have loaded the page (ie no filters have fields)
            Mail_log_entry::db()->order_by('time', 'DESC')->limit($this->items_per_page);
            $event_list = Mail_log_entry::find();
            //set defaults
            $form_data = array(
                'direction' =>'DESC',
                'order'=>'time',
                'cur_page'=>'1',
                'bound'=>'(ALL)',
                'success'=>'(ALL)',
            );
            $dir = "DESC";
            $order = "time";
            //get number of items in log
            $size = Mail_log_entry::count();
            $export = FALSE;
            $export_pdf = FALSE;
            $print_page = FALSE;

            //Adhoc Report
            $between = array ("time" => Array("start"=>"", "end" =>""));
            $response_adhoc = "";

            //set blank filters
            $form_data['mdn'] = "(ALL)";
            $form_data['id'] = "";
            $form_data['id_type'] = "";
            $form_data['bound'] = "(ALL)";
            $form_data['protected_data'] = "(ALL)";
            $form_data['sender'] = "";
            $form_data['recipient_type']= "";
            $form_data['recipient']= "";
            $form_data['sender_type'] = "";
            $form_data['file_size'] = "";
            $form_data['file_size_type'] = "";
            $form_data['attachment_type'] = "";
            $form_data['attachment_type_type'] = "";
            $form_data['start_date'] = "";
            $form_data['end_date'] = "";
            $form_data['successful'] = "(ALL)";
            $data['form_data'] = $form_data;
            $data['filters'] = ' ';
            $data['is_export'] = FALSE;
        }
        //set options for comparing
        $data['compare'] = array(
            'equals' => 'Equals',
            'contains' => 'Contains',
            'starts' => 'Starts With',
            'ends' => 'Ends With'
        );
        //Adhoc Report
        $data['adhoc_report_between'] = $between;
        $data['adhoc_report_order'] = $dir;
        $data['adhoc_report_direction'] = $order;
        $data['adhoc_report_response']= $response_adhoc;
        $data['adhoc_report_type'] = "mail";

        //pagination setup
        $this->pages->items_total = $size;
        $this->pages->current_page = $this->destination_page;
        $this->pages->paginate();
        $form_data['pagination_bar'] = $this->pages->display_pages();
        $form_data['items_per_page_dropdown'] = $this->pages->display_items_per_page();

        //gets image for asc or desc
        if($form_data['direction'] == 'DESC'){
            $data['image'] = '<img src="/images/arrow_down.png" style="border : 0;  width:15px;" alt="Descending"/>';
        }
        else{
            $data['image'] = "<img src='/images/arrow_up.png' style='border : 0;  width:15px;' alt='Ascending'/>";
        }

        $form_data['num_pages'] = ceil($size/$this->items_per_page);//num of log pages
        $form_data['items_per_page'] = $this->items_per_page;
        $form_data['pages'] = $this->pages;
        $data['form_data'] = $form_data;
        $data['event_list'] = $event_list;

        //converts application's numbers into their names
        $lists = array($event_list, $response_export_list);
        foreach($lists as $list) {
            if(isset($list)) {
                foreach($list as $event) {
                    //get the recipients and convert to array
                    $event->recipient=$this->json->decode($event->recipient);
                    $recip = '';
                    if(isset($event->recipient)){
                        foreach($event->recipient as $key =>$value){
                            //for csv exports, make sure that emails get normalized to just the address 
							if($export && preg_match('/<(.*?)>/', html_entity_decode(htmlentities($value)), $matches) && $this->is->string_like_an_email_address($matches[1])) {
                            	$value = $matches[1];
							}
                            //for all items after the first
                            if($key > 0) {
                                //if export make them comma separated
                                if($export) { $recip .= ', '; }
                                //else when in view make each email on a line
                                else { $recip.= "\n"; }
                            }
                            $recip .= $value; //add email
                        }
                    }
                    //for csv exports, make sure that emails get normalized to just the address 
                    if($export && preg_match('/<(.*?)>/', $event->sender, $matches) && $this->is->string_like_an_email_address($matches[1])) {
                                $event->sender = $matches[1];
                    }
                    $event->sender = htmlentities($event->sender);
                    $event->recipient = nl2br(htmlentities($recip));

                    //binary true/false into text
                    if($event->success) { $event->success = 'TRUE'; }
                    else { $event->success = 'FALSE'; }

                    //binary mdn into text
                    if($event->mdn) { $event->mdn = 'TRUE'; }
                    else { $event->mdn = 'FALSE'; }

                    //binary 7332 into text
                    if($event->protected_data) { $event->protected_data = 'TRUE'; }
                    else if($event->protected_data === 0) { $event->protected_data = 'FALSE'; }
                    else{ $event->protected_data = 'N/A'; }

                    //binary inbound/outbound into text
                    if($event->inbound_outbound){ $event->inbound_outbound = 'Inbound'; }
                    else { $event->inbound_outbound = 'Outbound'; }
                    //print_r ($event->time);
                    //time in readable format
                    $event->time = date("m/d/Y h:i:s A",$event->time);
                }
            }
        }

        //print boolean set in adhoc report page print link
        if(isset($adhoc_print_page) && $adhoc_print_page == 'true') {
            $data['adhoc_print_page'] = true;
        }

        if($export){
            #TODO - This horrible, horrible hack is necessary because the export function exports columns based on the order they exist in the object
            #so we have to reorder the event_list objects using a copy of the list that puts the columns in the right order. FIX THIS EVENTUALLY!
            $this->export(array('ID','Date ('.$data['timezone_abbr'].')','Size(KB)','Sender','Recipient','Attachment Type','Success', 'Direction','MDN', '7332'),$event_list,$export_file_name,$items,$between,$selected,null);
        }
        else if($export_pdf){
            if (!empty($response_export)){ $data['export_mail_list'] = $response_export_list; }
            $report_content = $this->input->post('report_content',FALSE);
            $html = $this->load->view('api/reports/result_tables/result_mail', $data, true);
            $this->export_pdf($export_file_name.'.pdf', $html, null, $size);
        }
        else if($print_page == 1) {
            $this->clear_cache();
            if (!empty($response_export)){
                $data['export_mail_list'] = $response_export_list;
            }
            $data['print_page'] = true;
            $form_data['page_select'] = $this->destination_page;
            $this->load->view('api/reports/mail', $data);
        }
        else {
            $this->load->view('api/reports/mail', $data);
        }
    }
}