<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* Hooks
* 
* This file lets you define "hooks" to extend CI without hacking the core
* files.  Please see the user guide for info:
*
*	http://codeigniter.com/user_guide/general/hooks.html
*
* @package direct-as-a-service
* @subpackage config
*/

require_once APPPATH.'helpers/environment_helper.php';


if(defined('ENABLE_PERFORMANCE_LOG') && ENABLE_PERFORMANCE_LOG){	
	//set up benchmarks at each hook so that we have more benchmarks than the default
	foreach(array('pre_system', 'pre_controller', 'post_controller_constructor', 'post_controller', 'post_system') as $__dsm_performance_hook){
		$hook[$__dsm_performance_hook][] = array( 'function' => 'add_benchmark', 'filename' => 'hooks.php', 'filepath' => 'hooks', 'params'   => $__dsm_performance_hook); 
	}
	
	//write all the benchmarks to the log once CI is done with its work
	//note that the post_system hook won't be called when we redirect, so we've overridden the default redirect function to include calls to these functions
	$hook['post_system'][] = array( 'function' => 'write_benchmarks_to_log', 'filename' => 'hooks.php', 'filepath' => 'hooks');  
	$hook['post_system'][] = array( 'function' => 'write_api_calls_to_log', 'filename' => 'hooks.php', 'filepath' => 'hooks'); 
}

$hook['pre_system'][] = array( 'function' => 'set_system_defaults',
							   'filename' => 'hooks.php',
							   'filepath' => 'hooks');


if( is_on_dev() && file_exists( APPPATH.'hooks/do_not_upload_me.php') ){
	$hook['post_controller_constructor'][] = array( 'function' => 'turn_on_profiler_if_on_dev',
													'filename' => 'do_not_upload_me.php',
													'filepath' => 'hooks',
													);
} 


$hook['post_controller_constructor'][] = array( 'function' => 'post_controller_constructor',
												'filename' => 'hooks.php',
												'filepath' => 'hooks'
											   ); 




/* End of file hooks.php */
/* Location: ./application/config/hooks.php */