var ajaxMessageCheckInProgress = false;
var saveDraftInProgress = false;
var message_count_refresh_interval = 60000;

$(window).on('load', function() {
	if(typeof dpii === 'object' && typeof dpii.compose === 'object'){
		dpii.compose.files.adjustInputTrigger();
	}
});

$(document).ready(function() {

	if(typeof dpii === 'object' && typeof dpii.compose === 'object') dpii.compose._init();
	if(typeof dpii === 'object' && typeof dpii.message === 'object') dpii.message._init();

	//enhanced tooltips
	if(typeof $().tipTip === 'function') {
		$(".tt-focus").tipTip({activation: "focus", delay:0, edgeOffset:0});
		$(".tt-hover").tipTip({delay:100});
		$(".tt-top-hover").tipTip({defaultPosition:"top",delay:100});
	}
	$('.my_modal_open').on('click', function(){
			$('#my_modal').popup({
				'autoopen': true
			});
		});
	$('#advanced_search_panel').on('keypress', function(e) {
		var code = (e.keyCode ? e.keyCode : e.which);
		if (code == 13) {
			$('#advanced_search_form').submit();
		}
	 });
	$('#login_btn').on('click', function(e){
		window.location.href = '/auth/';
	});
	if($('.c32name').length) {
		$('.c32name').shorten({
			"showChars" : 0,
			"moreText"  : "Show Details",
			"lessText"  : "Hide",
		});
		$('.morelink').click();
	}
	$.ajaxSetup({
		cache: false
	});
	$(':button').on('keyup', function(e) {
		var code = (e.keyCode ? e.keyCode : e.which);
		if(code === 13) { //Enter keycode
			(e.preventDefault) ? e.preventDefault() : e.returnValue = false;
			e.stopPropagation();
			if($(e.target).is(":focus")) {
				$(e.target).trigger('click');
			}
		}
	});
	$(':button').on('keypress', function(e) {
		var code = (e.keyCode ? e.keyCode : e.which);
		if(code === 13) { //Enter keycode
			(e.preventDefault) ? e.preventDefault() : e.returnValue = false;
			e.stopPropagation();
		}
	});
	if($('#mailbox_list').length) {
		$('#mailbox_list').on('mouseover', function() {
			$('#mailbox_list').css('overflow-y','auto');
		}).on('mouseout', function() {
			$('#mailbox_list').css('overflow-y','hidden');
		});
	}
	if($('.folders-wrapper.sidebar-left').length) {
		setInterval(function(){ ajaxMessageCheck(); }, (message_count_refresh_interval ? message_count_refresh_interval : 30000));
	}

	$(window).on('scroll', function() {
		$(".menu_modal").remove();
		if($('.suggest').length) { $('.suggest').css("top",($('textarea[name="message_to"]').offset().top + 20) + "px"); }
	});

	// Open image preview dialog in attachments list
	$('a.image-attachment').on('click', function (e) {
		e.preventDefault(); // Stop the image from opening in current tab
		var dialogEl = $('#dialog_container');
		if (dialogEl.length < 1) { // Element does not exist.
			dialogEl = $("<div/>").attr("id", "dialog_container").appendTo("body");
		}
		var options = {
				title: 'Image Preview',
				maxHeight: $(window).height() * 0.8,
				maxWidth: $(window).width() * 0.85,
				close: function(){dialogEl.empty();},
				draggable: false,
				modal: true,
				resizable: false
			};
		var	id = $('input[name="msg_id"]');
		var downloadURI = '/inbox/compose/draft/attachments/download';
		if(id && id.length && $.isNumeric(id.val())){
			downloadURI = '/inbox/message/' + id.val() + '/attachments/download';
		}
		var filename = $(this).attr('title');
		downloadURI += '/' + rawurlencode(filename);
		var img_src = $(this).attr('href');
		dialogEl.html('<div class="img-preview-wrapper"><img src="'+ img_src +'" class="img-preview" alt="'+ filename +'"/><br/><a href="' + downloadURI + '">Download Image</a></div>').dialog(options);
	});

	if($('a.lightbox').length) {
		initializeLightboxes();
	}

	if($('span.menu').length) {
		$('span.menu').on('click', function(e) {
				$('.menu_modal').remove();

				let target = $('[id="' + e.target.id + '"]');
				let selected_folder_li = target.parent();
				//var nestedFolderMaxDepth = $('#nested_folder_max_depth').val();
				//var currentTreeLevel = selected_folder_li.attr('data-depth');
				let maxChildDepth = selected_folder_li.attr('data-max-child-depth');

				let mailbox = selected_folder_li.children('.custom_folder_name').text();

				let folder_id = selected_folder_li.attr('id').replace('folder_', '');
				//var showUnseen =($('#anchor_'+folder_id).html()).replace(mailbox, '').replace('(', '').replace(')','').replace(' ', '');

				//var mailbox_encoded = base64_encode(mailbox);

				// Build the folder menu
				let html = "<div id=\"folder_menu_" + folder_id + "\" style=\" top:" + e.pageY + "px; " + "left: " + (e.pageX + 10) + "px;" + "\" class=\"menu_modal\">";
				html += '<ul>';
				html += '<li><a id=\"rename_folder_link_' + folder_id + '\">Rename</a></li>';
				if(maxChildDepth > 0) {
					html += '<li><a href="/inbox/archive_folder/' + folder_id + '/" ' +
						'onclick="return confirm(\'Are you sure you want to archive ' + mailbox +
						'? All messages in this folder and its subfolders will be archived.\')">Archive</a></li>';
				}
				else {
					html += '<li><a href="/inbox/archive_folder/' + folder_id + '/">Archive</a></li>';
				}
				html += '<li><a id=\"change_folder_parent_link_' + folder_id + '\">Change Parent</a></li>';
				html += '</ul></div>';

				// add the menu to the DOM
				$(document.body).append(html);

				// Setup some even handlers for the menu item links
				$('html').on('click', function(e) { $('.menu_modal').hide(); $('.menu_modal').remove(); });

				// Folder Renaming
				$('#rename_folder_link_' + folder_id).on('click', function(e) {
					e.preventDefault();
					renameFolder(folder_id);
				});

				$('#change_folder_parent_link_' + folder_id).on('click', function(e) {
					e.preventDefault();
					changeParent(folder_id);
				});
				// prevent any of the other menus from being triggered
				e.stopPropagation();
			}
		);
	}
	//nested folder auto expand to the current mailbox
	if($('#ancestor_id_str').length && $('#ancestor_id_str').val().trim()) {
		var ancestor_ids = ancestor_id_str.split('_');
		for(var i = ancestor_ids.length - 1; i >= 0; i-- ) {
			$("#toggle_image_" + ancestor_ids[i]).trigger('click');
		}
	}

	//event handlers
	var delay = (function(){
		var timer = 0;
		return function(callback, ms){
			clearTimeout (timer);
			timer = setTimeout(callback, ms);
		};
	})();

	// Auto tabbing config
	if ($('input[name*="[ssn]"]').length) {
		if ($('input[name*="[ssn][area_number]"]').length) {
			$('input[name*="[ssn][area_number]"]').each(function () {
				let group_number = $(this).closest('.input-group').find('input#group_number').first();
				if (group_number) {
					$(this).autotab({
						format: 'numeric',
						target: group_number
					});
				}
			});
		}
		if ($('input[name*="[ssn][group_number]"]').length) {
			$('input[name*="[ssn][group_number]"]').each(function () {
				let serial_number = $(this).closest('.input-group').find('input#serial_number').first();
				let area_number = $(this).closest('.input-group').find('input#area_number').first();
				if (area_number && serial_number) {
					$(this).autotab({
						format: 'numeric',
						previous: area_number,
						target: serial_number
					});
				}
			});
		}
		if ($('input[name*="[ssn][serial_number]"]').length) {
			$('input[name*="[ssn][serial_number]"]').each(function () {
				let group_number = $(this).closest('.input-group').find('input#group_number').first();
				if (group_number) {
					$(this).autotab({
						format: 'numeric',
						previous: group_number
					});
				}
			});
		}
	}

	$('#main_form').on('keypress', function(e) {
		var code = (e.keyCode ? e.keyCode : e.which);
		if(code === 13) {
			if($("#main_form").length) {
				if(!$('#message_body').is(":focus")){
					var tag = $(e.target).prop('tagName');
					if(tag === 'INPUT' || tag === 'SELECT') {
						var name = $(e.target).attr('name');
						var id = $(e.target).attr('id');
						if(name === 'message_to' || name === 'message_cc' || name === 'message_to' || name === 'search_input' || name === 'message_subject' || name === 'priority' || name === 'folder_name' || id === 'tefont' || id === 'tesize' || id === 'testyle'  || id === 'move_select' || id === 'token-input-message_to' || id === 'token-input-message_cc' || $(e.target).hasClass('selectmsg')) {
							(e.preventDefault) ? e.preventDefault() : e.returnValue = false;
							if(name === 'search_input') {
								$('#send_btn').attr('clicked','true');
								$('#search_btn').click();
							}
						}
					}
				}
			}
			if(e.target.id === "message_to" || e.target.id === "message_cc") {
				if($('.suggest').length) {
					(e.preventDefault) ? e.preventDefault() : e.returnValue = false;
					var preserve = $('textarea:focus').val().substring(0,$('textarea:focus').val().lastIndexOf(';') + 1);
					var suggestions = $('.suggest > ul > li');
					var suggestion = suggestions[0];
					var suggestion = $(suggestion).text();
					$('textarea:focus').val(preserve.replace(/[\r\n]+$/, '') + suggestion.replace(/[\r\n]+$/, '') + ';');
					$('.suggest').remove();
				}
				return false;
			}
		}
	});

	$('#save_btn').on('click', function(e) { $('#save_btn').attr('clicked','true'); });

	$('#main_form').on('submit', function(e) {
		// if discarding this message, skip validation
		if ( $('#main_form').attr('action').substr(-8) === '/discard') {
			return true;
		}
		if($('#send_btn').attr('clicked') === 'clicked') {
			(e.preventDefault) ? e.preventDefault() : e.returnValue = false;
			mainFormValidationOnSubmit();
		}
		else {
			$('#send_btn').attr('clicked','clicked');
			return mainFormValidationOnSubmit();
		}
	});
	$('#main_form').on('autosave',function(e){ (e.preventDefault) ? e.preventDefault() : e.returnValue = false; dpii.compose.save.run(); });


	if($('.admin_chart').length) {
		$('a.chart').on('click',function(event){
			(event.preventDefault) ? event.preventDefault() : event.returnValue = false;
			$.ajax({
				url : event.target.href + '/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(),
				success: function(data, textStatus, jqXHR) {
					if(userIsNotAuthorized(jqXHR)) {
						window.location = '/auth/logout';
					}
					else {
						$('.admin_chart').html(data);
						$('a.chart').parent().removeClass('active-tab');
						$(event.target).parent().addClass('active-tab');
					}
				}
			});
		});
		if($('.admin_chart').html().length === 0) {
			$.ajax({
					url : $('.active-tab > a').attr('href') + '/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(),
					success: function(data, textStatus, jqXHR) {
						if(userIsNotAuthorized(jqXHR)) {
							window.location = '/auth/logout';
						}
						else {
							$('.admin_chart').html(data);
						}
					}
			});
		}
	}

	if($('.address-book').length) {
		var modal_message_to_text = $('textarea[name="modal_message_to"]').text();
		var modal_message_cc_text = $('textarea[name="modal_message_cc"]').text();

		$('.address-book').on('click', function(e) {
			/* DEPRECATION - Remove when JQuery UI Dialog Replacement successful */
			$.ajax({
				url : '/addressbook/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
			}).done(function(data, textStatus, jqXHR){
				if(userIsNotAuthorized(jqXHR)) {
					window.location = '/auth/logout';
				}
				else {
					/* JQuery UI Dialog Replacement of Fancybox for Section 508/A3lly compatibility. */
					// Here, we're going to have to create a container for the returned HTML representing the dialog content,
					// attach it to the document.body, fill it with the returned HTML, and open a dialog that will be filled
					// with the contents.
					var dialogEl = $('#dialog_container');
					if (dialogEl.length < 1) { // Element does not exist.
						dialogEl = $("<div/>").attr("id", "dialog_container")
									.appendTo("body");
					}
					/* Append footer to the rest of the form code. This was done formerly by
					   use of the 'titleFormat' option for the FancyBox modal -
					   JQuery UI Dialog control does not have that option.
					*/
					var footer = '<div class="footer-modal"><div id="address_list">' +
						'<table><tr><td><button onclick="addModalTo()" aria-label="send to">To &#8594;</button></td>' +
						'<td><label for="modal_message_to" class="hidden_context">To</label>' +
						'<label for="token-input-modal_message_to" class="hidden_context">To</label>' +
						'<textarea name="modal_message_to" id="modal_message_to"></textarea></td></tr>' +
						'<tr><td><button aria-label="send carbon copy to" onclick="addModalCC()">CC &#8594;</button></td>' +
						'<td><label for="modal_message_cc" class="hidden_context">CC</label>' +
						'<label for="token-input-modal_message_cc" class="hidden_context">CC</label>' +
						'<textarea name="modal_message_cc" id="modal_message_cc"></textarea></td></tr>' +
						'</table>' +
						'<div style="float: right; padding: 5px;">' +
						'<button type="button" onclick="useAddressList()">OK</button>' +
						'<button type="button" onclick="cancelAddressList()" id="cancel_button">Cancel</button></div></div></div>';

					dialogEl.html(data)
					.dialog({
						width: 750,
						height: 500,
						modal: true,
						title: 'Global Address Book',
						create: function(event, ui) {$('#given-name-field').focus();},
						close: function(event, ui) {$('.footer-modal').remove(); event.target.focus();}
					});

					// Add footer if it doesn't exist
					if( $('.footer-modal').length < 1){
						$('#dialog_container').parent().append(footer);
						// Set up tokens for To box
						$('textarea#modal_message_to').tokenInput('/inbox/get_contacts_search/',
						{
							theme: "dpii",
							searchDelay: 500,
							hintText: "Enter a Direct address",
							tokenDelimiter: ";",
							onAdd: function(e) {
								if(!multipleAddressSplit(e)) {
									verifyAddress(e);
								}
							},
							noResultsText: "This is not a trusted address",
							resultsFormatter: function(item){
								if(item.description == null) {
									return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.id + "</div></div></li>"
								} else {
									return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.description + "</div></div></li>"
								}
							},
							tokenFormatter: function(item) { item.uid = uniqid();
								if(item.description == null) {
									return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" title=\"" + item.id + "\" data-address=\""+item.id+"\">" + item.name + "</p></li>"
								} else{
									return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" onclick=\"viewDistList('" + item.uid + "','" + htmlentities(base64_encode(json_encode(item))) + "','modal_message_to');\" title=\"" + item.description + "\" data-address=\""+item.id+"\"><img src=\"/images/group.png\" class=\"hover_pointer\" alt=\"Distribution List\"> " + item.name + "</p></li>"
								}
							}
						});

						// Set up tokens for CC box
						$("#modal_message_cc").tokenInput('/inbox/get_contacts_search/',
						{
							theme: "dpii",
							searchDelay: 500,
							hintText: "Enter a Direct address",
							tokenDelimiter: ";",
							onAdd: function(e) {
								if(!multipleAddressSplit(e)) {
									verifyAddress(e);
								}
							},
							noResultsText: "This is not a trusted address",
							resultsFormatter: function(item){
								if(item.description == null) {
									return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.id + "</div></div></li>"
								} else {
									return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.description + "</div></div></li>"
								}
							},
							tokenFormatter: function(item) { item.uid = uniqid();
								if(item.description == null) {
									return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" title=\"" + item.id + "\" data-address=\""+item.id+"\">" + item.name + "</p></li>"
								} else{
									return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" onclick=\"viewDistList('" + item.uid + "','" + htmlentities(base64_encode(json_encode(item))) + "','modal_message_cc');\" title=\"" + item.description + "\" data-address=\""+item.id+"\"><img src=\"/images/group.png\" class=\"hover_pointer\" alt=\"Distribution List\"> " + item.name + "</p></li>"
								}
							}
						});
					} // End modal-footer set up

				/* End JQuery UI Dialog Code */

					$("#address_book_wrapper").parent().scroll(function(){
						$("#result_panel")
							.stop()
							.animate({"marginTop": ($("#address_book_wrapper").parent().scrollTop()) + "px"}, 400);
					});
				}
			});
			(e.preventDefault) ? e.preventDefault() : e.returnValue = false;
		});
	}
	if($('.contact-list').length) {
		$('.contact-list').on('click', function(e) {
			window.__dsm_focus_return_element = e.currentTarget;

			$.ajax({
				url : '/addressbook/contacts/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
			}).done(function(data, statusText, jqXHR){
				if(userIsNotAuthorized(jqXHR)) {
					window.location = '/auth/logout';
				}
				else {

					/* JQuery UI Dialog Replacement of Fancybox for Section 508/A3lly compatibility. */
					// Here, we're going to have to create a container for the returned HTML representing the dialog content,
					// attach it to the document.body, fill it with the returned HTML, and open a dialog that will be filled
					// with the contents.
					var dialogEl = $('#dialog_container');
					if (dialogEl.length < 1) { // Element does not exist.
						dialogEl = $("<div/>").attr("id", "dialog_container")
									.appendTo("body");
					}
						/* Append footer to the rest of the form code. This was done formerly by
							use of the 'titleFormat' option for the FancyBox modal -
							JQuery UI Dialog control does not have that option.
						*/
						var footer = '<div class="footer-modal"><div id="address_list">' +
						'<table><tr><td><button aria-label="send to" onclick="addModalTo()">To &#8594;</button></td>' +
						'<td><label for="modal_message_to" style="display:none;">To</label>' +
						'<label for="token-input-modal_message_to" style="display:none;">To</label>' +
						'<textarea name="modal_message_to" id="modal_message_to"></textarea></td></tr>' +
						'<tr><td><button aria-label="send carbon copy to" onclick="addModalCC()">CC &#8594;</button></td>' +
						'<label for="modal_message_cc" style="display:none;">CC</label>' +
						'<td><label for="token-input-modal_message_cc" style="display:none;">CC</label>' +
						'<textarea name="modal_message_cc" id="modal_message_cc"></textarea></td></tr>' +
						'</table>' +
						'<div style="float: right; padding: 5px;">' +
						'<button type="button" onclick="useAddressList();">OK</button>' +
						'<button type="button" onclick="cancelAddressList()" id="cancel_button">Cancel</button></div></div></div>';

						dialogEl.html(data)
						.dialog({
							width: 750,
							height: 500,
							modal: true,
							title: 'Personal Contacts List',
							create: function(event, ui) {$('#add_contact_link').focus();},
							close: function(event, ui) {$('.footer-modal').remove(); event.target.focus();}
						});
						// Set up modal footer
						if( $('.footer-modal').length < 1){
							$('#dialog_container').parent().append(footer);
							// Set up tokens for To box
							$("#modal_message_to").tokenInput('/inbox/get_contacts_search/',
							{
								theme: "dpii",
								searchDelay: 500,
								hintText: "Enter a Direct address",
								tokenDelimiter: ";",
								onAdd: function(e) {
									if(!multipleAddressSplit(e)) {
										verifyAddress(e);
									}
								},
								noResultsText: "This is not a trusted address",
								resultsFormatter: function(item){
									if(item.description == null) {
										return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.id + "</div></div></li>"
									} else {
										return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.description + "</div></div></li>"
									}
								},
								tokenFormatter: function(item) { item.uid = uniqid();
									if(item.description == null) {
										return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" title=\"" + item.id + "\" data-address=\""+item.id+"\">" + item.name + "</p></li>"
									}
									else{
										return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" onclick=\"viewDistList('" + item.uid + "','" + htmlentities(base64_encode(json_encode(item))) + "','modal_message_to');\" title=\"" + item.description + "\" data-address=\""+item.id+"\"><img src=\"/images/group.png\" class=\"hover_pointer\" alt=\"Distribution List\"> " + item.name + "</p></li>"
									}
								}
							});

							// Set up tokens for CC box
							$("#modal_message_cc").tokenInput('/inbox/get_contacts_search/',
							{
								theme: "dpii",
								searchDelay: 500,
								hintText: "Enter a Direct address",
								tokenDelimiter: ";",
								onAdd: function(e) {
									if(!multipleAddressSplit(e)) {
										verifyAddress(e);
									}
								},
								noResultsText: "This is not a trusted address",
								resultsFormatter: function(item){
									if(item.description == null) {
										 "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.id + "</div></div></li>"
									} else {
										return "<li>" + "<div style='display: inline-block; padding-left: 10px;'><div class='full_name'>" + " " + item.name + "</div><div class='email'>" + item.description + "</div></div></li>"
									}
								},
								tokenFormatter: function(item) { item.uid = uniqid();
									if(item.description == null) {
										return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" title=\"" + item.id + "\" data-address=\""+item.id+"\">" + item.name + "</p></li>"
									} else{
										return "<li class=\"unvalidated\"><p class=\"unvalidated\" id=\""+item.uid+"\" onclick=\"viewDistList('" + item.uid + "','" + htmlentities(base64_encode(json_encode(item))) + "','modal_message_cc');\" title=\"" + item.description + "\" data-address=\""+item.id+"\"><img src=\"/images/group.png\" class=\"hover_pointer\" alt=\"Distribution List\"> " + item.name + "</p></li>"
									}
								}
							});
						}// End modal footer
				}
			});
			(e.preventDefault) ? e.preventDefault() : e.returnValue = false;
		});
	}
	if($('.theme_preview').length) {
		$('.theme_preview').on('click', function(e) {
			var id = $(e.target).attr('id').replace('theme','');
			$('input[name="theme_id"]').val(id);
			$('#theme_form').submit();
		});
	}

	if($('div.mailbox_select.toplevel').length) {
		$('div.mailbox_select.toplevel').on('click', function(e) {
			var show = false;
			if($('div.mailbox_select.list').attr('style') == null) { show = true; }
			else {
				if($('div.mailbox_select.list').attr('style').indexOf('display: none') !== -1) { show = true; }
			}
			if(show) {
				$('div.mailbox_select.list').attr('style','display: block;');
			}
			else {
				$('div.mailbox_select.list').attr('style','display: none;');
			}
			$('html').on('click', function(event) { $('div.mailbox_select.list').attr('style','display: none;'); });
			e.stopPropagation();
		});
		$('div.mailbox_select.toplevel > a').on('click', function(e) {
			var show = false;
			if($('div.mailbox_select.list').attr('style') == null) { show = true; }
			else {
				if($('div.mailbox_select.list').attr('style').indexOf('display: none') !== -1) { show = true; }
			}
			if(show) {
				$('div.mailbox_select.list').attr('style','display: block;');
				$('div.mailbox_select.list > ul > li > a:first').focus();
				}
			else {
				$('div.mailbox_select.list').attr('style','display: none;');
			}
			$('html').on('click', function(event) { $('div.mailbox_select.list').attr('style','display: none;'); });
			e.stopPropagation();
		});
	}


	if($('.social-security-number-form-control-container').length) {
		$('.social-security-number-form-control-container').on('keyup', function(event){
			if ( event.which >= 48 && event.which <= 57 ) { //numbers
				if($(event.target).val().length == $(event.target).attr('maxlength')){
					$(event.target).nextAll('input').first().focus();
				}
			}
		});
	}

	//Accessibility Related Events
	var is_webkit = navigator.userAgent.toLowerCase().indexOf('webkit') > -1;
	var is_opera = navigator.userAgent.toLowerCase().indexOf('opera') > -1;
	if(is_webkit || is_opera)
	{
		var target = document.getElementById('menuContent');
		if(target != null) {
			target.href="#menuContent";
			target.innerText="Menu";
			var skipNav = document.getElementById('skipNav');
			if(skipNav != null) {
				skipNav.setAttribute("onclick" , "document.getElementById('menuContent').setAttribute('tabindex' , '0'); document.getElementById('menuContent').focus();");
			}
		}
		var skipToMenu = document.getElementById('skipToMenu');
		if(skipToMenu != null) {
			skipToMenu.setAttribute("onclick" , "document.getElementById('menuContent').setAttribute('tabindex' , '0'); document.getElementById('menuContent').focus();");
		}
		var target2 = document.getElementById('mainContent');
		if(target2 != null) {
			target2.href="#mainContent";
			target2.innerText="Main Content";
			var skipMail = document.getElementById('skipMailboxList');
			if(skipMail != null) {
				skipMail.setAttribute("onclick" , "document.getElementById('mainContent').setAttribute('tabindex' , '0'); document.getElementById('mainContent').focus();");
			}
			var skipAdminMenu = document.getElementById('skipAdminMenu');
			if(skipAdminMenu != null) {
				skipAdminMenu.setAttribute("onclick" , "document.getElementById('mainContent').setAttribute('tabindex' , '0'); document.getElementById('mainContent').focus();");
			}
		}
		var target3 = document.getElementById('mailboxListContent');
		if(target3 != null) {
			target3.href="#mailboxListContent";
			target3.innerText="Mailbox List";
			var skipMenu = document.getElementById('skipMenu');
			if(skipMenu != null) {
				skipMenu.setAttribute("onclick" , "document.getElementById('mailboxListContent').setAttribute('tabindex' , '0'); document.getElementById('mailboxListContent').focus();");
			}
		}
	}
	$('.hidden_context').on('focus', function(e) {
		$(e.target).addClass('visible');
		if($(e.target).parent().hasClass('custom-mailbox-accessible-menu')) {
			$(e.target).parent().css('height','15px');
		}
	});
	$('.hidden_context').on('blur', function(e) {
		$(e.target).removeClass('visible');
		if($(e.target).parent().hasClass('custom-mailbox-accessible-menu')) {
			$(e.target).parent().css('height','0px');
		}
	});

	delay(function() {
		//$('#tinyeditorframe').contents().find('html').bind('keydown',function(e) {
		$('#tinyeditorframe').contents().find('html').on('keydown',function(e) {
			var code = (e.keyCode ? e.keyCode : e.which);
			if(code === 9) { //tab keycode
				(e.preventDefault) ? e.preventDefault() : e.returnValue = false;
				if(e.shiftKey) {
					$('#testyle').focus();
			}
			else {
				$('#send_btn').focus();
			}
		}
	});
		},15);
		//$('#message_body').bind('keydown',function(e) {
		$('#message_body').on('keydown',function(e) {
			var code = (e.keyCode ? e.keyCode : e.which);
			if(code === 9) { //tab keycode
				(e.preventDefault) ? e.preventDefault() : e.returnValue = false;
				if(e.shiftKey) {
					$('#testyle').focus();
				}
				else {
					$('#send_btn').focus();
				}
			}
		});
	$('div.admin_chart').on('mouseover', function(e) {
		$('.hidden_chart').addClass('visible');
	});
	$('div.admin_chart').on('mouseout', function(e) {
		$('.hidden_chart').removeClass('visible');
	});
	if($('#last_button').val() != null) {
		if($('#last_button').val().length) {
			$('#'+$('#last_button').val()).focus();
		}
	}

	//BEGIN FLAGGING LOGIC
	//event handlers for empty flag slot hovering
	$('img.no_flag').on('mouseover', function() {
		$(this).attr('src','/images/icons/flag_less_transparent.png');
	});
	$('img.no_flag').on('mouseout', function() {
		$(this).attr('src','/images/icons/flag_transparent.png');
	});
	function unbind_flag(image){
		/*$(image).unbind('mouseover');
		$(image).unbind('mouseout');*/
		$(image).off('mouseover');
		$(image).off('mouseout');
		$(image).removeClass('no_flag');
	}
	function bind_flag(image){
		$(image).attr('alt','No Flag');
		$(image).attr('src','/images/icons/flag_transparent.png');
		$(image).addClass('no_flag');
		$(image).on('mouseover', function() {
			$(this).attr('src','/images/icons/flag_less_transparent.png');
		});
		$(image).on('mouseout', function() {
			$(this).attr('src','/images/icons/flag_transparent.png');
		});
	}
	//event handler to add flag menu
	$('a.flag').each(function() {
		update_qtip(this)
	});
	function update_qtip(input){
		if (!$(input).children('img').hasClass('no_flag')){
			$(input).qtip({
				content: {
					text: function(event, api) {
						var display = "";
						if($(input).children('img').attr('message') != ''){
							display += "<span style = \"font-size: 12px;\"> " + nl2br($(input).children('img').attr('message').substring(0,269), false) +(($(input).children('img').attr('message').length>270)?"...":"")+"</span><br/><br/>";
						}
						if($(input).children('img').attr('modify_user') != null){
							display += "<span style = \"color: gray; font-size: 9px;\">Created: " +$(input).children('img').attr('create_user')+ " - " + formatDate(new Date($(input).children('img').attr('create_time')* 1000)) + "  </span>";
							display += "<br/><span style = \"color: gray; font-size: 9px;\">Modified: " +$(input).children('img').attr('modify_user')+ " - " + formatDate(new Date($(input).children('img').attr('modify_time')* 1000)) + "</span>";
						}
						else{
							display += "<span style = \"color: gray; font-size: 9px;\">Loading...</span>";
						}
						return display;
					}
				},
				style: {
					classes: 'qtip-light qtip-rounded',
				},
				show: {
				},
				hide:{
					fixed:true,
					delay:50
				},
				position: {
					my: 'left top',
					at: 'right top'
				}
			});
		}
	}
	$('a.flag').on('click', function(e) {
		//define index of is not set
		defineIndexOf();
		//var db_id = ($(e.target).attr('db_id') != null) ? $(e.target).attr('db_id') : $(e.target).parent().attr('db_id');
		var img_obj = ($(e.target).children('img').attr('id') != null) ? $(e.target).children('img') : $(e.target);
		var uid = img_obj.attr('id').replace("_flagimg","");

		var old_color = $(img_obj).attr('color');
		if(old_color==null){
			old_color="";
		}
		e.stopImmediatePropagation();
		$(img_obj.parent()).qtip("destroy");
		$('#flag-cancel').click();
		$('.flag-menu').remove();
		var colors = new Array('red','purple','blue','green','orange','brown');
		var menu = '<div id="flag_menu" class="flag-menu">';
		for(var i = 0; i < colors.length; i++) {
			menu += '<a href="#" class="flag"><img color="'+colors[i]+'" id="modal_flagimg_'+colors[i]+'_'+uid+'" class="flag flag-selector '+((colors[i] == old_color)?'selected-flag':'')+'" src="/images/icons/flag_'+colors[i]+'.png" alt="'+colors[i]+' Flag" title="'+((colors[i] == old_color)?'Selected ':'')+colors[i].charAt(0).toUpperCase()+ colors[i].slice(1)+' Flag"/></a>';
		}
		menu +=  '<a href="#" class="flag"><img color="" id="modal_flagimg_transparent_'+uid+'" class="flag flag-selector '+(("" == old_color)?'selected-flag':'')+'" src="/images/icons/flag_transparent.png" alt="'+(("" == old_color)?'Selected ':'')+'Remove Flag" title="Remove Flag"/></a>';
		menu += '<br/>';
		menu += '<form id="flag_message_form" method="POST" action="/inbox/save_flag_message">';
		menu += '<label for="flag_message_text" class="hidden_context">Flag Message</label>';
		menu += '<textarea '+((img_obj.hasClass('no_flag'))?'disabled':"")+' id="flag_message_text" class="flag-textarea" name="flag_message_text">'+((img_obj.attr('message') != null && !img_obj.hasClass('no_flag')) ? img_obj.attr('message') : '') +'</textarea>';
		menu += '<input type="hidden" name="message_uid" value="'+img_obj.attr('id').replace('_flagimg','')+'" />';
		menu += '<input type="hidden" name="'+$('input[type="hidden"].token').attr('id')+'" value="'+$('input[type="hidden"].token').val()+'" />';
		menu += '<br/>';
		if($(img_obj).attr('modify_user') != null){
			menu += '<a href="#" class="hidden_context">Modified by '+$(img_obj).attr('modify_user')+' on '+new Date($(img_obj).attr('modify_time')*1000)+'</a>';
			menu += '<a href="#" class="hidden_context">Created by '+$(img_obj).attr('create_user')+' on '+new Date($(img_obj).attr('create_time')*1000)+'</a>';
		}
		if($(img_obj).attr('flag_id') != null){
			menu += '<input type="hidden" value="'+$(img_obj).attr('flag_id')+'" id="flag_id" name="flag_id"/>'
		}
		menu += '<input type="hidden" value="" id="color-flag" name="color-flag"/>'
		menu += '<div style= "float:right;">'
		menu += '<input class="minimal minimal-short" type="button" id="flag-save" value="Save" style="right: 10px; padding: 1px;">';
		menu += '<input class="minimal minimal-short" type="button" id="flag-cancel" value="Cancel" style=" right:5px; padding: 1px; ">';
		menu += '</div><br/><br/>';
		menu += '</form>';
		menu += '</div>';
		var pos = getPos(e.target);
		$(menu).appendTo('body').css({top: (pos[1]) + 'px', left: (pos[0] + 20) + 'px'});

		//handle keyboard focusing

		$('#flag_menu').children('a.flag').first().focus();
		//handle click events on colored flags in menu
		$('#flag_menu > a.flag').on('click', function(e) {
			var color = ($(e.target).attr('color') != null) ? $(e.target).attr('color') : $(e.target).children('img').attr('color');
			$('.selected-flag').attr('title',$('.selected-flag').attr('title').replace("Selected ",""));
			$('.selected-flag').attr('alt',$('.selected-flag').attr('alt').replace("Selected ",""));
			$('.selected-flag').removeClass('selected-flag');
			var element = null;
			if($(e.target).hasClass('flag-selector')){//change which flag is selected
				element = $(e.target);
			}else{
				element = $(e.target).children('img');
			}
			var src = element.attr('src');
			var id = element.attr('id');
			var title = element.attr('title');
			var parent = element.parent();
			element.remove();
			parent.append('<img title="Selected '+title+'" alt="Selected '+title+'" src="'+src+'" class="flag flag-selector selected-flag" id="'+id+'" color="'+color+'">');
			parent.children(':first').focus();
			setTimeout(function(){$('#StatusUpdater').html("Selected "+title);},10);


			//if its a valid color, change the color, otherwise assume we want to remove the flag
			if((colors.indexOf(color) > -1 ? true : false)) {
				$(img_obj).attr('src','/images/icons/flag_'+color+'.png');
				$(img_obj).attr('color',color);
				$(img_obj).attr('alt',color+" Flag");
				unbind_flag(img_obj);
				$('#flag_message_text').attr('disabled', false);
			}
			else {
				bind_flag(img_obj);
				$(img_obj).attr('alt',"No Flag");
				$(img_obj).attr('color','');
				$('#flag_message_text').attr('disabled', true);
			}
		});


		//set up option for message
		var currentMessage = img_obj.attr('message');
		var currentTime = img_obj.attr('modify_time');
		var options = {
			beforeSend: function(data){
				//modify created by
				img_obj.attr('message',$('#flag_message_text').val());
				img_obj.attr('modify_time',new Date().getTime()/1000);
			},
			success: function(data) {
				if(data != null && data !== ""){
					var msg_obj = JSON.parse(data);
					img_obj.attr('message',msg_obj.content);
					img_obj.attr('create_user',msg_obj.created_by);
					img_obj.attr('create_time',msg_obj.created_at);
					img_obj.attr('modify_user',msg_obj.modified_by);
					img_obj.attr('modify_time',msg_obj.modified_at);
					img_obj.attr('flag_id',msg_obj.id);
				}
			},
			error: function(xhr) {
				if(xhr.status !== 0) { // don't give error message if ajax has aborted , it is still processed
					alert('Error saving flag message.');
				}
				img_obj.attr('message',currentMessage);
				img_obj.attr('modify_time',currentTime);
			}

		};

		$('#flag_message_form').ajaxForm(options);
		$('#flag-save').on('click', function(e){
			$('#color-flag').val($(".selected-flag").attr('color'));
			$('#flag_message_form').submit();
			$('.flag-menu').remove();
			update_qtip(img_obj.parent());
			img_obj.parent().focus();
		});
		$('#flag-cancel').on('click', function(e){
			$('.flag-menu').remove();
			if(old_color === '' ){
				bind_flag(img_obj);
				$(img_obj).attr('alt',"No Flag");
				$(img_obj).attr('color','');
				$(img_obj.parent()).qtip("destroy");
			}
			else{
				$(img_obj).attr('src','/images/icons/flag_'+old_color+'.png');
				$(img_obj).attr('color',old_color);
				$(img_obj).attr('alt',old_color+" Flag");
				update_qtip(img_obj.parent());
			}
			update_qtip(img_obj.parent());
			img_obj.parent().focus();
		});
	});

	//////////status functions (load on inbox views only)
	if($('#main_form').length) {
		$('#legend').qtip({content: {
			title: 'Legend',
			text: '<img src="/images/gray_man.png" alt="Unassigned" title="Unassigned" style="height:10px;"/> - Unassigned <br/>'
				+'<img src="/images/orange_man.png" style="height:10px; alt="Assigned to someone else" title="Assigned to someone else" /> - Assigned to someone else <br/>'
				+'<img src="/images/blue_man.png" style="height:10px; alt="Assigned to you" title="Assigned to you" /> - Assigned to you <br/>'
				+'<img src="/images/complete_man.png" style="height:10px; alt="Complete" title="Complete" /> - Complete<br/>'
			},
			style: {
				classes: 'qtip-tipped'
			},
			hide:{
				fixed:true,
				delay:50
			}
		});


		$('.message_status').on('click', function(){
			var id = $(this).attr('id');
			var status = $('#'+id).attr('status');
			var html = $('#'+id).html();
			if(status === "unassigned"){
				$('#'+id).html('<img id="'+id+'_img"  src="/images/blue_man.png" alt="Assigned to '+$('#display_name').attr('value')+'" title="Assigned to '+$('#display_name').attr('value')+'"/>');
				$('#'+id).attr({status:"assigned_me"});
				change_status(id , "assign_to_me", "Failed to assign message status" ,html, "unassigned",true);
			}
			else if(status === "assigned_me"){
				$('#'+id).html('<img src="/images/complete_man.png"  alt="Completed by '+$('#display_name').attr('value')+'" title="Completed by '+$('#display_name').attr('value')+'" />');
				$('#'+id).attr({status:"complete"});
				change_status(id , "complete_message", "Failed to complete message status" ,html, "assigned_me",true);
			}
			else if(status === "complete"){
				$('#'+id).html('<img id="'+id+'_img"  src="/images/gray_man.png" alt="Unassigned" title="Unassigned"/>');
				$('#'+id).attr({status:"unassigned"});
				change_status(id , "reset_message_status", "Failed to reset message status" ,html,"complete", true);
			}
			else{//assigned to other to do
			}
		});
		$('#assign_button').on('click', function(e) {
			$('#assign_menu').attr({style:""});
			$('#assign_menu').remove();
			$('.token-input-dropdown-dpii').remove();
			//$('html').unbind('click');
			$('html').off('click');
			$.ajax({
				url : '/inbox/assign_search_menu/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
				}).done(function(data){
					$('#assign_menu').attr({style:""});
					$('#assign_menu').remove();
					$('.token-input-dropdown-dpii').remove();
					$(document.body).append(data);
					$('#assign_menu').css('top',($('#assign_button').offset().top + 31) + 'px');
					$('#assign_menu').css('left',($('#assign_button').offset().left) + 'px');
					$('html').click(function(e) {
						if((!$('#assign_menu').find($(e.target)).length) && $(e.target).attr('id') != $('#assign_menu').attr('id')) {
							$('#assign_menu').attr({style:""});
							$('#assign_menu').remove();
						}
					});
				$('#assign_menu').find('input[type="text"]').focus();
			});
		});
	}
	if($('img.status_code_icon').length !== 0){
		$('img.status_code_icon').qtip({
					content: {
						text: false
					},
					style: {
						classes: 'qtip-light qtip-rounded',
					},
					show: 'mouseover',
					hide:{
						fixed:true,
						delay:50
					},
					position: {
						my: 'right top',
						at: 'right top'

					}
		});
	}

	if($('[data-toggle="popover"]').length){
		//activate popovers to view patient metadata in inbox
		$('.patient-popover').popover({ trigger: 'click',
										html: true,
										title: function(){ return $(this).parent().children('.title').html(); },
										content: function(){ return $(this).parent().children('.body').html(); },
									  });

		//close popovers when clicking off of them
		$('body').on('click', function (e) {
			if ($(e.target).data('toggle') !== 'popover'
				&& !$(e.target).hasClass('popover-arrow')
				&& $(e.target).parents('[data-toggle="popover"]').length === 0
				&& $(e.target).parents('.popover.in').length === 0
				&& $(e.target).parents('.popover-nav').length === 0) {
			   closeAllPopovers();
			}
		});
	}

	//nested folder drag and drop and expand
	if($('[class*="custom-folder"]').length) {
		//expand folder tree space if a nested folder is selected already
		if(deepestOpenFolderLevel() > 1) {
			$('#message_panel').animate({
				'marginLeft' :  ((deepestOpenFolderLevel()-1) * 35) + "px" //moves screen based on deepest open folder
			});
			$("#mailbox_panel").animate({
				'width' : (((deepestOpenFolderLevel()-1) * 35) + 150) + "px"
			});
		}
		/* $('[class*="custom-folder"]').draggable({
			containment: "#mailbox_list",
			revert : "invalid",
			zIndex : "200",
			helper : "clone",
			opacity : 0.7,
			start : function(event, ui) {
				ui.helper.data('rejected', false);
				ui.helper.data('original_position', ui.helper.offset());
			},
			stop : function(event, ui) {
				if(ui.helper.data('rejected') === true) {
					ui.helper.offset(ui.helper.data('original_position'));
				}
			}
		});
		$('[class*="custom-folder"]').droppable({
			hoverClass : "draggable-folder-hover",
			drop : function(event, ui) {

				var nestedFolderMaxDepth = $('#nested_folder_max_depth').val(); //int - relates to server setting for maximum folder depth

				var folder = $(ui.draggable); //this is an <li> for a custom folder
				var folder_accessible_menu = $('#accessible-menu-' + folder.attr('data-id')); //this is an <li> adjacent to above custom folder <li>
				var folder_children = $('#ul_' + folder.attr('data-id')); //this is an <ul> under the <li> for a custom folder
				var newParent = $(event.target); //this is also an <li> for a custom folder


				//update the UI
				var originalParentUL = $(ui.draggable).parent();
				var newParentUL = $('#ul_' + $(event.target).attr('data-id'));

				//get level of new parent (0 for root, etc.)
				var newParentLevel = parseInt($(event.target).attr('data-depth'));
				//data-max-child-depth is number of children, add one to include the top level folder
				var levelsBeingMoved = parseInt($(ui.draggable).attr('data-max-child-depth')) + 1;

				var draggedFolderClass = $(ui.draggable).attr('class');
				$(ui.draggable).attr('data-depth', (newParentLevel+1));
				//update tree depth of the descendants of the dragged folder
				var descendantsOfDraggedFolder = $('#ul_' + folder.attr('data-id')).find('[class*="custom-folder"]');
				for(var i = 0; i < descendantsOfDraggedFolder.length; i++) {
					currentDescendantTreeLevel =  parseInt($('#' + descendantsOfDraggedFolder[i].id).attr('data-depth'));
					$('#' + descendantsOfDraggedFolder[i].id).attr('data-depth', currentDescendantTreeLevel+1);
				}
				//subtract one from the nestedFolderMaxDepth because root folder is depth level 0, so with a data-depth
				//of 2 and max level of 3, we already have reached max depth, since we add one to number of children to include the
				//top level folders among the ones moved, data-depth (2) + levels being moved (1) should exceed max level (3 - 1 = 2)
				//3 > 2 so it fails
				if(((newParentLevel)+levelsBeingMoved) > (nestedFolderMaxDepth - 1)) {
					var nth = noty({
						text: 'Cannot move folder because it would cause subfolders to exceed maximum depth.',
						type: 'error',
						timeout: 5000
					});
					ui.draggable.data('rejected', true);
					return;
				}

				//update the name attribute if it exists, so that toggles work correctly
				if(!!$(ui.draggable).attr('name')) {
					$(ui.draggable).attr('name', $(event.target).attr('data-id'));
				}
				//move folder
				newParentUL.append(folder.removeAttr('style'));

				//move accessible menu
				newParentUL.append(folder_accessible_menu);

				//move any subfolders under folder
				newParentUL.append(folder_children);

				//remove toggle icon if the original folder no longer has any children
				if(originalParentUL.children('li').not('.ui-draggable-dragging').length < 1) {
					$('#folder_' + originalParentUL.attr('id').replace('ul_','')).addClass('childless');
					$('#toggle_image_' + originalParentUL.attr('id').replace('ul_','')).parent().remove();
				}
				//add icon to parent that originally had no children
				if(newParentUL.children().length > 0) {
					if(!$('#toggle_image_' + newParentUL.attr('id').replace('ul_','')).length) {
						$('#folder_' + newParentUL.attr('id').replace('ul_','')).removeClass('childless');
						//if the new parent had a expanded folder tree already, make sure the toggle direction points the right way
						if(newParentUL.css('display') == 'none') { var img_loc = 'caret-right.png'; }
						else { var img_loc = 'caret-bottom.png'; }
						$('#folder_' + newParentUL.attr('id').replace('ul_','')).prepend('<a href="#" style="display: inline-block; float: left;" onclick="(event.preventDefault) ? event.preventDefault() : event.returnValue = false; toggleFolderTree($(this).children(\':first\'));"><img id="toggle_image_'+newParentUL.attr('id').replace('ul_','')+'" src="/images/'+img_loc+'" alt="Expand Tree Icon"></a>');
					}
				}

				//make the change parent call
				$.post('/inbox/folder/'+ folder.attr('id').replace('folder_', '') + '/change_parent?', "parent_folder_select="+newParent.attr('data-id') + "&" + $('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val() , function(data) {
					//get rid of the error message that comes with a failed service call to just retrieve the response from webmail/folder_controller
					data = data.substring(data.indexOf('{"'), data.indexOf('"}')+2);
					var response = jQuery.parseJSON(data);
					if(!response.status) {
						//revert UI on folder change failure
						originalParentUL.append($(ui.draggable));
						$('#ul_' +  folder.attr('id')).insertAfter($(ui.draggable));
						$('#accessible-menu-' +  folder.attr('id')).insertAfter($(ui.draggable));
						if(newParentUL.children('li').not('.ui-draggable-dragging').length < 1) {
							$('#toggle_image_' + newParentUL.attr('id').replace('ul_','')).parent().remove();
						}
						var nth = noty({
							text: response.message,
							type: 'error',
							timeout: 5000
						});

					}
					else {
						//could display success message here, but lag makes it confusing
					}

				}).fail(function() {
					//revert UI if POST fails
					originalParentUL.append($(ui.draggable));
					if(newParentUL.children('li').not('.ui-draggable-dragging').length < 1) {
						$('#toggle_image_' + newParentUL.attr('id').replace('ul_','')).parent().remove();
					}
					var nth = noty({
						text: 'An error occured while moving this folder. Please try again in a moment, or contact an administrator if the problem persists.',
						type: 'error',
						timeout: 5000
					});
				});
			}
		});*/
	}
	if(typeof $().dialog === 'function') {
		$("#advanced_search_panel").dialog({
				draggable : true,
				resizable : true,
				minHeight: 350,
				minWidth: 270,
				close : function(e){
					$('#advance_search_button').focus()
					}
				,autoOpen : false,
				describedBy : "dialogDescription",
				modal : true,
				buttons: { "Search": function() { $('#advanced_search_form').submit(); }}
		});
	}
	//overwrite z-index of noty_top_layout_container from noty library to a higher value to have the message always shown
	//on top of everything even when user has the browser width and height relatively small.
	$('#noty_top_layout_container').css('z-index', 105);

	$('#advance_search_button').on('click', function() {
		$("#advanced_search_panel").dialog("open").find(":input").eq(0).focus();
		$('.ui-dialog').zIndex(105);
		return false;
	 });

	if($('.purpose-of-disclosure').length){
		$('input[name="disclosures[message_body_has_patient_data]"]').change(function(){
			if($(this).val() === 'yes'){
				$('.purpose-of-disclosure .message-body').show();
			}else{
				$('.purpose-of-disclosure .message-body').hide();
			}
		});
	}

	//event handler for exapnding zip archives in the UI
	if($('a.zip-expand-icon').length) {
		$('a.zip-expand-icon').on('click', function(e) {
			(e.preventDefault) ? e.preventDefault() : e.returnValue = false;
			var index = $(this).attr('data-attachment-index');
			if(!$(this).hasClass('expanded')) {
				if($('#zip_contents' + index).length) {
					$('#zip_contents' + index).css('display', 'inline');
					$(this).addClass('expanded');
					$('#zip_contents' + index).parent().children('a.zip-expand-icon:not(.zip-name)').html('&#x25BC;');
					$('#zip_contents' + index).parent().children('a.zip-expand-icon:not(.zip-name)').attr('title', 'Click to collapse clinical document content from zip archive');
				}
			}
			else {
				if($('#zip_contents' + index).length) {
					$('#zip_contents' + index).css('display', 'none');
					$(this).removeClass('expanded');
					$('#zip_contents' + index).parent().children('a.zip-expand-icon:not(.zip-name)').html('&#x25B6;');
					$('#zip_contents' + index).parent().children('a.zip-expand-icon:not(.zip-name)').attr('title', 'Click to expand clinical document content from zip archive');
				}
			}
		});
	}


	$('.alert-banner').on('closed.bs.alert', function(){
		$.ajax({
			url: '/ajax/dismiss_banner/' + $(this).attr('data-banner-name') + '?' + $('body').attr('data-token') + '=' + $('body').attr('data-hash')
		});
	});

	let discardConfirmation = function() {

		let dc = $('#dialog_container');
		if (dc.length < 1) {
			// Create a new dialog container
			dc = $("<div/>").attr("id", "dialog_container").appendTo("body");
		}  else {
			dc.empty();
		}

		dc.dialog({
			autoOpen: false,
			modal: true,
			title: 'Discard Confirmation',
			draggable: false,
			resizable: false,
			create: function() {
				dc.text('Are you sure you would like to discard this draft?');
			},
			buttons: [
				{
					text: 'Yes',
					type: 'submit',
					click: function() {
						$('#main_form').attr('action', function(i, action) {
							return action + '/discard';
						});
						$('#main_form').submit();
					}
				},
				{
					text: 'No',
					click: function() {
						$(this).dialog("close");
					}
				}
			],
			close: function() {
				$(this).dialog("destroy");
				$('#dialog_container').remove();
				$('#discard_btn').off();
				$('#discard_btn').focus();
				$('#discard_btn').on('click', discardConfirmation);
			}
		});
		dc.dialog('open');
	};
	// Opens a dialog for user verification
	$('#discard_btn').on('click', discardConfirmation);
});

function closeAllPopovers(){
	$('[data-toggle="popover"]').popover('hide');
	$('div.patients').find('div.patient-popover').popover('hide');
}

function popoverDisplayNext(button){
	buttonID = $(button).attr('id');
	patientID = buttonID.substring( 0, buttonID.indexOf('-arrow-next') );
	$(button).parent('.popover-nav').parent('.popover-title').next('.popover-content').html($('.'+patientID+'.body').next('.title').next('.body').html());
	$(button).parent('.popover-nav').parent('.popover-title').html($('.'+patientID+'.title').next('.body').next('.title').html());
	return false;
}

function popoverDisplayPrevious(button){
	buttonID = $(button).attr('id');
	patientID = buttonID.substring( 0, buttonID.indexOf('-arrow-previous') );
	$(button).parent('.popover-nav').parent('.popover-title').next('.popover-content').html($('.'+patientID+'.body').prev('.title').prev('.body').html());
	$(button).parent('.popover-nav').parent('.popover-title').html($('.'+patientID+'.title').prev('.body').prev('.title').html());
	return false;
}

function showRecipients(ele,bool,waiting,sent,processed,displayed,denied,failed, delivered) {
	if (bool==1) {
		var heading = '<a style="text-decoration:none; color:#000000;" title="Message Statistics">Message Statistics</a><br>';
		var waiting = '<img src="/images/email_icons/message-not-yet-processed.png" alt="Messages not yet processed" title="Messages not yet processed" style="vertical-align:bottom;"/><a style="text-decoration:none; color:#000000;" title="Messages not yet processed">: '+waiting+'</a><br>';
		var sent = '<img src="/images/email_icons/message-sent.png" alt="Messages sent" title="Messages sent" style="vertical-align:bottom;"/></><a style="text-decoration:none; color:#000000;" title="Messages sent">: '+sent+'</a><br>';
		var processed = '<img src="/images/email_icons/message-processed.png" alt="Messages processed" title="Messages processed" style="vertical-align:bottom;"/></><a style="text-decoration:none; color:#000000;" title="Messages processed">: '+processed+'</a><br>';
		var displayed = '<img src="/images/email_icons/message-displayed.png" alt="Messages displayed" title="Messages displayed" style="vertical-align:bottom;"/></><a style="text-decoration:none; color:#000000;" title="Messages displayed">: '+displayed+'</a><br>';
		var denied = '<img src="/images/email_icons/message-denied.png" alt="Messages denied" title="Messages denied" style="vertical-align:bottom;"/></><a style="text-decoration:none; color:#000000;" title="Messages denied">: '+denied+'</a><br>';
		var failed = '<img src="/images/email_icons/message-failed.png" alt="Message failures" title="Message failures" style="vertical-align:bottom;"/></><a style="text-decoration:none; color:#000000;" title="Message failures">: '+failed+'</a><br>';
		var delivered = '<img src="/images/email_icons/message-delivered.png" alt="Message delivered" title="Message delivered" style="vertical-align:bottom;"/></><a style="text-decoration:none; color:#000000;" title="Message delivered">: '+delivered+'</a><br>';
		var html = heading+waiting+sent+processed+delivered+displayed+denied+failed;

		$(ele).qtip('option', 'content.text', html);
	}
}

function getPos(ele){
	var x = 0;
	var y = 0;
	while(true){
		x += ele.offsetLeft;
		y += ele.offsetTop;
		if(ele.offsetParent === null){
			break;
		}
		ele = ele.offsetParent;
	}
	return [x, y];
}
//END FLAGGING LOGIC

function skipToAccessibleTextEditor() {
	$('#message_body').focus();
}

function ajaxMessageCheck(button) {
	if(button != null) {
		noty({
			text: 'Checking for new messages.  This may take a moment.',
			type: 'info',
			timeout: 5000,
			focusAfter:$('#get_mail_btn')
		});
	}

	if(ajaxMessageCheckInProgress)
		return false;

	ajaxMessageCheckInProgress = true;

	$.ajax({
		url: '/inbox/message_waiting_count/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(),
		success: function(messageCount, statusText, jqXHR) {
			if(userIsNotAuthorized(jqXHR)) {
				window.location = '/auth/logout';
			}
			else {
				ajaxMessageCheckInProgress = false;

				if(button != null && messageCount < 1) {
					noty({
						text: 'No new messages found.',
						type: 'info',
						timeout: 5000,
						focusAfter:$('#get_mail_btn')
					});
				}

				if($.isNumeric(messageCount) && messageCount > 0) {

					//refresh the list of messages if we're looking at it; this is not an efficient way to be doing this, refactor this in future
					if($('body').hasClass('controller-inbox') && $('body').hasClass('action-index')){
						$.ajax({
							url: '/inbox?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(),
							success: function(data, statusText, jqXHR) {
								if(userIsNotAuthorized(jqXHR)) {
									window.location = '/auth/logout';
								}
									else {
									$(document).attr('title', $('<div>').html(data).find('title').text());
									$('#wrapper').html($('#wrapper', $('<div>').html(data)).children());
								}
							}
						});
					}

					$('body').append('<audio controls="controls" autoplay="autoplay" style="display: none;"><source src="/audio/newmail.mp3" type="audio/mpeg" /><source src="/audio/newmail.ogg" type="audio/ogg" /></audio><!--[if lt IE 9]><embed hidden="true" height="0px" width="0px"  autoplay="true" autostart="True" src="/audio/newmail.mp3" /><![endif]-->');
					_newMessageNotificationDesktop(messageCount);
				}
			}
		}
	});
}

function _newMessageNotificationBrowser(messageCount){
	var body = 'You have ' + ((messageCount > 1) ? messageCount : 'a') + ' new message' + ((messageCount > 1) ? 's' : '') + '.' ;
	noty({	text: body,
			type: 'success',
			timeout: 15000,
		});
}

function _newMessageNotificationDesktop(messageCount){
	if(!("Notification" in window))
		return _newMessageNotificationBrowser(messageCount);

	if(Notification.permission !== 'granted' && Notification.permission !== 'denied'){
		Notification.requestPermission(function(permission){});
	}

	if(Notification.permission !== 'granted'){
		return _newMessageNotificationBrowser(messageCount);
	}

	var title = 'New Direct Message';
	if(messageCount > 1)
		title = messageCount + ' ' + title + 's';

	var notification = new Notification(title);
}


function selectAll() {
	let select = $('#selectall');
	if (select != null) {
		$('.selectmsg').each(function(){
			$(this).prop('checked', select.is(':checked'));
			selectMsg(this);
		});
	}
}

function selectMsg(box) {
	if(box.checked === true) {
		$("#archive_btn").removeAttr('disabled');
		$("#mark_as_read_btn").removeAttr('disabled');
		$("#more_button").removeAttr('disabled');
		$("#assign_button").removeAttr('disabled');
		$("#complete_button").removeAttr('disabled');
		$("#discard_btn").removeAttr('disabled');

		if($('#move_btn').length && $('#move_select option').length > 0){
			$("#move_btn").removeAttr('disabled');
			$('#move_btn').click(function(e) { moveFolderListGenerate(e) });
		}

		var boxes = $('.selectmsg');
		var count = 0;
		for(var i = 0; i < boxes.length; i++) {
			if(boxes[i].checked === true) { count++; }
		}
		if(count > 1) { $("#archive_btn").html('Archive Messages'); }
		else { $("#archive_btn").html('Archive Message'); }
	}
	else {
		var display = false;
		var boxes = $('.selectmsg');
		var count = 0;
		for(var i = 0; i < boxes.length; i++) {
			if(boxes[i].checked === true) { display = true; count++; }
		}
		if(!display) {
			$('#archive_btn').attr('disabled', 'disabled');
			$('#discard_btn').attr('disabled', 'disabled');
			$('#move_btn').attr('disabled', 'disabled');
			$('#mark_as_read_btn').attr('disabled', 'disabled');
			$('#more_button').attr('disabled', 'disabled');
			$('#assign_button').attr('disabled', 'disabled');
			$('#complete_button').attr('disabled', 'disabled');
		}
		if(count > 1) { $("#archive_btn").html('Archive Messages'); }
		else { $("#archive_btn").html('Archive Message'); }
	}
}

function createFolder(e) {
	e.preventDefault();
		$.ajax({
			url : '/inbox/folder/new?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
		}).done(function(data, statusText, jqXHR){
			if(userIsNotAuthorized(jqXHR)) {
				window.location = '/auth/logout';
			}
			else {

				/* JQuery UI Dialog Replacement of Fancybox for Section 508/A3lly compatibility. */
				// Here, we're going to have to create a container for the returned HTML representing the dialog content,
				// attach it to the document.body, fill it with the returned HTML, and open a dialog that will be filled
				// with the contents.

				var dialogEl = $( "<div/>" ).attr( "id", "folder_dialog_container" ).appendTo( "body" );

				dialogEl.html( data );
				dialogEl.dialog({
					autoOpen: true,
					title: "Create New Folder",
					width: 350,
					height: 300,
					buttons: [
						{
							text: "Create Folder",
							click: function() {
								e.preventDefault();
								$('.overlay').remove();
								$(document.body).append("<div class=\"overlay\"></div>");
								$('#pros_modal').css('display','block');
								var form = $( '#form-dialog-container' ).find( 'form' );
								var postUrl = form.attr('action');
								console.log("Action URL: " + postUrl);
								$.ajax({
									url: postUrl,
									type: 'post',
									data: form.serialize(),
									success: function(data) {
										location.reload();
									},
									error: function(err) {
										console.log("Something went wrong: " + err.message);
									}
								});
							},
							type: "submit"
						},
						{
							text: "Close",
							click: function() {
								$( this ).dialog( "close" );
							}
						}
					],
					close: function(event, ui) {$( '#folder_dialog_container' ).remove();}
				}).on( "keypress", "input[type=text]", function( event ) {
					if ( event.keyCode == 13 ) {
						$( '#form-dialog-container' ).find( 'input[type="submit"]' ).click();
						$ ( this ).dialog( "close" );
				}}).dialog( 'open' );
			}
		});
	return false;
}


//find the nested folder level of the deepest open nested folder on the page
function deepestOpenFolderLevel() {
	var openNestedFolders = $('[class*="custom-folder"]:visible');
	var deepestLevel = 0;
	$.each(openNestedFolders, function(index, value) {
		var level = parseInt($(value).attr('data-depth'));
		if(level > deepestLevel) { deepestLevel = level; }
	});
	return deepestLevel;
}

// Change the parent folder of this folder
function changeParent(id) {

	// this is a tweak to get the modal to align correctly
	let viewportWidth = window.innerWidth - 20;
	let viewportHeight = window.innerHeight - 15;
	if (viewportWidth > 670) viewportWidth = 670;
	if (viewportHeight > 400) viewportHeight = 400;

	$.ajax({
		url : '/inbox/folder/' + id + '/change_parent_form?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
	}).done(function(data, statusText, jqXHR){
		/* JQuery UI Dialog Replacement of Fancybox for Section 508/A3lly compatibility. */
		// Here, we're going to have to create a container for the returned HTML representing the dialog content,
		// attach it to the document.body, fill it with the returned HTML, and open a dialog that will be filled
		// with the contents.

		let dialogEl = $('#dialog_container');
		if (dialogEl.length < 1) {
			dialogEl = $("<div/>").attr("id", "dialog_container").appendTo("body");
		} else {
			dialogEl.empty();
		}

		dialogEl.html( data );
		dialogEl.dialog({
			autoOpen: true,
			title: "Change Parent Folder",
			width: viewportWidth,
			height: viewportHeight,
			modal: true,
			position: {
				my: "center",
				at: "center",
				of: window,
				collision: "none"
			},
			buttons: [
				{
					text: "Change Parent",
					click: function(e) {
						e.preventDefault();
						$('.overlay').remove();
						$(document.body).append("<div class=\"overlay\"></div>");
						$('#pros_modal').css('display','block');
						var form = $( '#dialog_container' ).find( 'form' );
						var postUrl = form.attr('action');
						$.ajax({
							url: postUrl,
							type: 'post',
							data: form.serialize(),
							success: function(data) {
								location.reload();
							},
							error: function(err) {
								console.log("Something went wrong: " + err.message);
							}
						});
					},
					type: "submit"
				},
				{
					text: "Cancel",
					click: function() {
						$('.overlay').remove();
						$( this ).dialog( "close" );
					}
				}
			],
			close: function(event, ui) {$( '#dialog_container' ).remove();}
		}).on( "keypress", "input[type=text]", function( event ) {
			if ( event.keyCode == 13 ) {
				$( '#dialog_container' ).find( 'input[type="submit"]' ).click();
				$ ( this ).dialog( "close" );
		}}).dialog( 'open' );
	});
	return false;
}

function moveFolder(link) {
	$('#main_form').append('<input type="hidden" name="move" value="' + link + '" />');
}

function loadingScreen() {
	$('.overlay').remove();
	$(document.body).append("<div class=\"overlay\"></div>");
	$('#pros_modal').css('display','block');
}

//note that this form can be triggered from any page, so we can't count on the hidden token being available
function showFeedbackForm(tokenName, tokenValue) {

	window.__dsm_focus_return_element = document.activeElement;

	// this is a tweak to get the modal to align correctly
	let viewportWidth = window.innerWidth - 20;
	let viewportHeight = window.innerHeight - 15;
	if (viewportWidth > 670) viewportWidth = 670;
	if (viewportHeight > 400) viewportHeight = 400;

	function _trapFocusFor508(e) {
		var TAB_KEY = 9;
		var keyPressed = e.which || e.keyCode;
		var $firstEl = $('#feedback-type-field-general-feedback');
		var $secondEl = $('#feedback-type-field-issue-report');
		var $lastEl = $('#fancybox-close').attr({
			'href': '#', // This is necessary so it can receive focus
			'role': 'button',
			'aria-label': 'Close',
		});

		// Tab Forward
		if (keyPressed === TAB_KEY && !e.shiftKey) {
			if (e.target.id === 'fancybox-close') {
				e.preventDefault();
				$firstEl.focus();
			}
			if (e.target.id === 'feedback-type-field-general-feedback') {
				e.preventDefault();
				$secondEl.focus();
			}
		}

		// Tab Backward
		if (keyPressed === TAB_KEY && e.shiftKey) {
			if (e.target.id === 'feedback-type-field-general-feedback') {
				e.preventDefault();
				$lastEl.focus();
			}
			if (e.target.id === 'feedback-comments-field') {
				e.preventDefault();
				$secondEl.focus();
			}
			if (e.target.id === 'feedback-type-field-issue-report') {
				e.preventDefault();
				$firstEl.focus();
			}
		}
	}

	let dialogEl = $('#dialog_container');
	if (dialogEl.length < 1) {
		dialogEl = $("<div/>").attr("id", "dialog_container").appendTo("body");
	} else {
		dialogEl.empty();
	}
	// setup the dialog
	let formSourceURL = '/feedback/?' + tokenName + '=' + tokenValue;

	dialogEl.dialog({
		autoOpen: false,
		title: 'Provide Feedback',
		width: viewportWidth,
		height: viewportHeight,
		modal: true,
		draggable: true,
		resizable: false,
		position: {
			my: "center",
			at: "center",
			of: window,
			collision: "none"
		},
		open: function(e, ui) {
			// load the form html
			$(this).load(formSourceURL, function(){
				// set the focus to the first form input element
				$('#feedback-type-field-general-feedback').focus();
			});
		},
		buttons: [
			{
				text: 'Submit',
				click: function() {
					let formModal = this;
					let form = $('#form-dialog-container').find('form');
					let postUrl = form.attr('action');
					$.post({
						url: postUrl,
						type: 'post',
						datatype: 'application/json',
						data: form.serialize(),
						success: function(data) {
							console.log('Feedback submission successful');
							$( formModal ).html(data);
						},
						error: function(err) {
							console.log('Feedback submission failed: ' + err.message);
						}
					});
				},
				type: 'submit'
			},
			{
				text: 'Cancel',
				click: function() {
					$( this ).dialog( 'close' );
				}
			}
		],
		close: function(event, ui) {
			$( '#dialog_container' ).remove();
		},
		create: function (event, ui) {
			$(event.target).parent().css('position', 'fixed');
		}
	});
	dialogEl.dialog('open');

	return false;
}

function closeModalDialog() {
	$.dialog.close();
	return false;
}

function exportCSV(log) {
	$('.overlay').remove(); //get rid of stuff if it was already there
	$('.modal').remove();
	$(document.body).append("<div class=\"overlay\"></div>");
	$.ajax({
		url : '/adminpanel/export_form/'+log+'/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
	}).done(function(data){
		$(document.body).append(data);
		$( "input.date" ).datepicker({maxDate : 0});
		$( 'input[name="start_date"]').focus();
		$('.modal').draggable();
	});
}
function checkdate(){
	var today = new Date().getTime();
	var retVal = true;
	if(new Date($('input[name="start_date"]').val()).getTime() > today){
		var msg = "Invalid date range, start date cannot be in the future.";
		var retVal = false;
	}
	if(new Date($('input[name="end_date"]').val()).getTime() > today){
		var msg = "Invalid date range, end date cannot be in the future.";
		var retVal = false;
	}
	if(new Date($('input[name="end_date"]').val()).getTime() < new Date($('input[name="start_date"]').val())){
		var msg = "Invalid date range, start date must be before end date.";
		var retVal = false;
	}
	if(retVal == false) {
		$('a.error_block').remove();
		$('<a class="error_block" style="text-decoration: none;" href="#">' + msg + '</a>').insertBefore($('#export').children('p'));
		$('a.error_block').focus();
	}
	return retVal;
}

function useAddressList() {
	var to = $('#modal_message_to').tokenInput('get');
	var cc = $('#modal_message_cc').tokenInput('get');
	$.each(to, function(index,value) {
		$('#message_to').tokenInput('add',value);
	});
	$('textarea[name="message_to"]').focus();
	if(cc.length) {
		$.each(cc, function(index,value) {
			$('#message_cc').tokenInput('add',value);
		});
		$('textarea[name="message_cc"]').parent().parent().css('display','table-row');
		$('#show-cc').remove();
		$('textarea[name="message_cc"]').focus();
	}
	//parent.jQuery.fancybox.close();
	$('#dialog_container').dialog('close');
}

function cancelAddressList() {
	//parent.jQuery.fancybox.close
	$('.footer-modal').remove();
	$('#dialog_container').dialog('close');
}

function changeGroup(group) {
	window.location = '/inbox/change_mailbox_group/' + encodeURI(group);
}

function addUserToGroup(group,active) {
	$(document.body).append("<div class=\"overlay\"></div>");

	$.getJSON('/adminpanel/ajax_group_member_search/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val() , function(data) {
		var items = [];
		$.each(data, function(key, val) {
			items.push('<option value="'+val.uid+'">' + val.displayname + ' ('+ val.uid + ')</option>');
		});
		var users = items.join('\n');
		$('.modal').remove();
		$.ajax({
			url : '/adminpanel/add_user_to_group_form/' + group + '/' + active + '/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
		}).done(function(data){
			$(document.body).append(data);
			$('#users').html(users);
			$('#user_group_search').focus();
			$('input[name="user_group_search"]').keyup(function(e){
				delay(function() {
					var search = $('input[name="user_group_search"]').val();
					search = $.trim(search);
					$.getJSON('/adminpanel/ajax_group_member_search/' + rawurlencode(search) + '/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), function(data) {
						var items = [];
						$.each(data, function(key, val) {
							items.push('<option value="'+val.uid+'">' + val.displayname + ' ('+ val.uid + ')</option>');
						});
						$('#users').html(items.join('\n'));
					});
				},1000);
			});
			//event handlers
			var delay = (function(){
				var timer = 0;
				return function(callback, ms){
					clearTimeout (timer);
					timer = setTimeout(callback, ms);
				};
			})();
			$('.modal').draggable();
		});

		$('input[name="user_group_search"]').on('keydown', function(e){
			var code = (e.keyCode ? e.keyCode : e.which);
			if(code === 13) { //Enter keycode
				(e.preventDefault) ? e.preventDefault() : e.returnValue = false;
				return false;
			}
		});
		//event handlers
		var delay = (function(){
			var timer = 0;
			return function(callback, ms){
				clearTimeout (timer);
				timer = setTimeout(callback, ms);
			};
		})();
		$('.modal').draggable();
	});
}

//toggles checkbox
function toggleSelectAll(checkbox) {
	var checkboxes = jQuery(':input:checkbox');
	if(checkbox == null || checkbox.id !== 'select_all') {
		var allChecked = true;
		for(var i = 0; i < checkboxes.length; i++) {
			if(!checkboxes[i].checked && checkboxes[i].id !== 'select_all') {
				allChecked = false;
			}
		}
		if(allChecked) {
			$("#select_all").attr('checked', true);
		}
		else {
			$("#select_all").attr('checked', false);
		}
	}
	else if(checkbox.id === 'select_all') {
		if(checkbox.checked) {
			for(var i = 0; i < checkboxes.length; i++) {
				checkboxes[i].checked = true;
			}
		}
		else {
			for(var i = 0; i < checkboxes.length; i++) {
				checkboxes[i].checked = false;
			}
		}
	}
}

function populateUserToGroupSelection() {
	//event handlers
	var delay = (function(){
		var timer = 0;
		return function(callback, ms){
			clearTimeout (timer);
			timer = setTimeout(callback, ms);
		};
	})();
	delay(function() {
		var search = $('input[name="user_group_search"]').val();
		search = $.trim(search);
		$.getJSON('/adminpanel/ajax_group_member_search/' + rawurlencode(search) + '/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), function(data) {
			var items = [];
			$.each(data, function(key, val) {
				items.push('<option value="'+val.uid+'">' + val.displayname + ' ('+ val.uid + ')</option>');
			});
			$('#users').html(items.join('\n'));
		});
	},1000);
}

function updateTimezoneList(country) {
	$.getJSON('/settings/ajax_timezone_list/' + rawurlencode(country.value) + '/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(), function(data) {
		var items = [];
		$.each(data, function(key, val) {
			items.push('<option value="' + key + '">' + val + '</option>');
		});
		$('select[name="timezone"]').html(items.join('\n'));
	});
}

function mainFormValidationOnSubmit() {
	if(navigator.appName === 'Microsoft Internet Explorer') {
		if($('#pros_modal').length) {
			$('#pros_modal').html("<p style=\"text-align: center; \">Processing Request...</p><img src=\"/images/ajax-loader-large.gif\" alt=\"Processing...\" style=\"display: block; margin-top: 10px; margin-right: auto; margin-left: auto;\" />");
		}
	}
	if($("#compose_form").length) {
		return composeFormIsValid();
	}else{
		return true;
	}
}

function moveFolderListGenerate(e){
	$('.menu_modal').remove();
	var availableHeight = $(window).height() - $('#' + e.target.id).offset().top - $('#' + e.target.id).innerHeight() - (2 * parseFloat($('body').css('font-size')));
	$(document.body).append("<div id=\"move_menu\" style=\" top:" + ($('#' + e.target.id).offset().top + 31) + "px; " + "left: " + $('#' + e.target.id).offset().left + 'px; min-height: 2em; max-height:'+ Math.max(availableHeight, 2 * parseFloat($('body').css('font-size'))) + 'px; overflow-y: auto;"' + " class=\"menu_modal\">" + "<p>Move To:</p>" + "<img src=\"/images/ajax-loader.gif\" alt=\"Loading...\"/>" + "</div>");

	var items = [];
	$("#move_select option").each(function(){
		items.push('<li><a onclick=\"moveFolder(\'' + $(this).val() + '\'); $(\'#main_form\').submit();\">' + $(this).text() + '</a></li>');
		$('#move_menu').html("<p>Move To:</p>" + "<ul>" + items.join('\n') + "</ul>");
		$('#move_menu > ul > li > a').focus();
	});

	$('html').on('click', function(e) { $('.menu_modal').remove(); });
	$('#move_menu').on('blur', function(e) { $('#move_menu').remove(); });
	e.stopPropagation();
}

function addressList() {
	$.ajax({
		url : '/addressbook/address_list/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(),
	}).done(function(data, textStatus, jqXHR){
		if(userIsNotAuthorized(jqXHR)) {
			window.location = '/auth/logout';
		}
		else {

			/* JQuery UI Dialog Replacement of Fancybox for Section 508/A3lly compatibility. */
			// Here, we're going to have to create a container for the returned HTML representing the dialog content,
			// attach it to the document.body, fill it with the returned HTML, and open a dialog that will be filled
			// with the contents.
			var dialogEl = $('#dialog_container');
			if (dialogEl.length < 1) { // Element does not exist.
				dialogEl = $("<div/>").attr("id", "dialog_container")
							.appendTo("body");
			} else {
				dialogEl.dialog('destroy');

				dialogEl.html(data)
					.dialog({
						create: function(event, ui) {
							// Unless there's an anomaly I've never heard of, there's no reason to repeat field focus
							// Just a straight-up drop-in from the Fancybox original.
							$('#address_search_input').focus();
							$('#address_search_input').focus();
						}
					});
			}

			jQuery("textarea[class*=expand]").TextAreaExpander(19);

			$("#address_book_wrapper").parent().scroll(function(){
				$("#result_panel")
					.stop()
					.animate({"marginTop": ($("#address_book_wrapper").parent().scrollTop()) + "px"}, 400);
			});
		}
	});
}

function contactsList() {

	$.ajax({
		url : '/addressbook/contacts_list/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
	}).done(function(data, textStatus, jqXHR){
		if(userIsNotAuthorized(jqXHR)) {
			window.location = '/auth/logout';
		}
		else {

			/* JQuery UI Dialog Replacement of Fancybox for Section 508/A3lly compatibility. */
			// Here, we're going to have to create a container for the returned HTML representing the dialog content,
			// attach it to the document.body, fill it with the returned HTML, and open a dialog that will be filled
			// with the contents.
			var dialogEl = $('#dialog_container');
			if (dialogEl.length < 1) { // Element does not exist.
				dialogEl = $("<div/>").attr("id", "dialog_container")
							.appendTo("body");
			} else {
				dialogEl.dialog('destroy');

				dialogEl.html(data)
					.dialog({
						create: function(event, ui) {
							$('#add_contact_link').focus();
						}
					});
			}

			jQuery("textarea[class*=expand]").TextAreaExpander(19);

			$("#address_book_wrapper").parent().scroll(function(){
				$("#result_panel")
					.stop()
					.animate({"marginTop": ($("#address_book_wrapper").parent().scrollTop()) + "px"}, 400);
			});
		}
	});
}

function multipleAddressSplit(address){
	var add = address.id.replace(new RegExp("(&quot;|\")(.*?)(&quot;|\")","g"),"");
	add = add.replace(new RegExp("(&lt;|<)","g"),"");
	add = add.replace(new RegExp("(&gt;|>)","g"),"");
	var array = add.split(/[;,]+/);
	if(array.length > 1){
		$.each(array, function(key, val){
				if(val.length > 1) {
					$('#'+address.uid).parent().parent().parent().children('textarea').tokenInput('add',{ name : val, id : val, uid: uniqid() });
				}
		});
		$('#'+address.uid).parent().parent().parent().children('textarea').tokenInput('remove', address );
		return true;
	}
	else{
		return false;
	}
}

function verifyAddress(address) {
	var address_str = address.id;
	$.ajax({
		url : '/inbox/valid_trusted_address/' + rawurlencode(base64_encode(address_str)) + '/?' + $('input[type="hidden"].token').attr('id') + '=' + $('input[type="hidden"].token').val()
	}).done(function(data) {
		var response = jQuery.parseJSON(data);
		if(response != null && typeof response === 'object') {
			if(response.valid) {
				var trusted = $("<span class=\"token-input-hidden_context\">(Trusted Address)</span>");
				$("#"+address.uid).append(trusted);
				$("#"+address.uid).attr('title',$("#"+address.uid).attr('title') + ' (Trusted)');
				$("#"+address.uid).removeClass('unvalidated');
				$("#"+address.uid).addClass('trusted');
				$("#"+address.uid).parent().removeClass('unvalidated');
				$("#"+address.uid).parent().addClass('trusted');
			}
			else {
				var untrusted = $("<span class=\"token-input-hidden_context\">(Untrusted Address)</span>");
				$("#"+address.uid).append(untrusted);
				$("#"+address.uid).attr('title',$("#"+address.uid).attr('title') + ' (Untrusted)');
				$("#"+address.uid).removeClass('unvalidated');
				$("#"+address.uid).addClass('untrusted');
				$("#"+address.uid).parent().removeClass('unvalidated');
				$("#"+address.uid).parent().addClass('untrusted');
				$("#"+address.uid).attr('data-message',response.message);
			}
		}
		else {
			alert('Problem validating address: ' + address_str + ' as trusted.');
		}
	});
}

function defineIndexOf(){
	if (!Array.prototype.indexOf)
	{
	  Array.prototype.indexOf = function(elt /*, from*/)
	  {
		var len = this.length >>> 0;

		var from = Number(arguments[1]) || 0;
		from = (from < 0)
			 ? Math.ceil(from)
			 : Math.floor(from);
		if (from < 0)
		  from += len;

		for (; from < len; from++)
		{
		  if (from in this &&
			  this[from] === elt)
			return from;
		}
		return -1;
	  };
	}
}

function formatDate(time) {
	var hour = time.getHours();
	var month = time.getMonth() + 1;
	var day = time.getDate();
	var minute = time.getMinutes();
	if(hour === 12) { var ampm = "pm"; }
	else if(hour > 12){
		hour = hour - 12;
		var ampm = "pm";
	}
	else if(hour === 0){
		hour = 12;
		var ampm = "am";
	}
	else {
		var ampm = "am";
	}
	if(hour < 10) { hour = "0" + hour; }
	if(minute < 10) { minute="0" + minute; }
	if(month < 10) { month = "0" + month; }
	if(day < 10) { day = "0" + day; }
	return ""+month+"/"+day+"/"+time.getFullYear()+" "+hour+":"+minute + ampm;
}

//////////status functions
function assign_to_other(id,user_id,name){ //assign message status manually
		var old_status = $('#'+id).attr('status');
		var old_html = $('#'+id).html();
		if(user_id !== $('#current_user').attr('value')){
			$('#'+id).html('<img id="'+id+'_img"  src="/images/orange_man.png" alt="Assigned to '+name+'" title="Assigned to '+name+'"/>');
			$('#'+id).attr({status:"assigned_other"});
		}
		else{
			$('#'+id).html('<img id="'+id+'_img"  src="/images/blue_man.png" alt="Assigned to '+name+'" title="Assigned to '+name+'"/>');
			$('#'+id).attr({status:"assigned_me"});
		}
		$.ajax({
			url : '/inbox/assign_message_status/'+ id + '/'+user_id+'/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(),
			success: function(data) {
				var data = $.parseJSON(data);
				if(!data.success){
					$('#'+id).html(old_html);
					$('#'+id).attr({status:old_status});
				}
			},
			error: function(xhr){
				if(xhr.status !== 0){
					$('#'+id).html(old_html);
					$('#'+id).attr({status:old_status});
				}
			}
		});
	}

	function assign_selected(user_id,name){//assign selected messages

		if($('.detailed_status').length === 0){
			$('.selectmsg:checked').each(function(){
				var id = $(this).attr('id');
				var message_id = 'status_'+id.substring(id.indexOf('t')+1);
				assign_to_other(message_id,user_id,name);
			});
		}
		else{
			assign_to_other($('.message_status').attr('id'),user_id,name);
		}
	}

	function complete_selected(){//complete selected messages
		var ato=false;
		$('.selectmsg:checked').each(function(){
			var id = $(this).attr('id');
			var status_id = 'status_'+id.substring(id.indexOf('t')+1);
			var old_status = $('#'+status_id).attr('status');
			var old_html = $('#'+status_id).html();
			if(old_status === "unassigned" || old_status === "assigned_me"){
				$('#'+status_id).html('<img id="'+status_id+'_img"  src="/images/complete_man.png" alt="Completed by '+$('#display_name').attr('value')+'" title="Completed by '+$('#display_name').attr('value')+'"/>');
				$('#'+status_id).attr({status:"complete"});
				change_status(status_id , "complete_message", "Failed to assign message status" ,old_html, old_status,false);
			}
			else if(old_status === "complete"){
				//do nothing
			}
			else{//belongs to other
				ato = true;
			}

		});
		if(ato){
			alert("Some messages are assigned to other people.  You must assign it to yourself before completing the task.");
		}
	}

	function complete_current(){
		var id = $('.message_status').attr('id')
		var old_status = $('#'+id).attr('status');
		var old_html = $('#'+id).html();
		if(old_status != "complete"){
			if(old_status === "assigned_other" || old_status === "complete_other"){
				alert("Message assigned to a different user.  Status was not changed.");
			}
			else{
				$('#'+id).html('<img id="'+id+'_img"  src="/images/complete_man.png" alt="Completed by '+$('#display_name').attr('value')+'" title="Completed by '+$('#display_name').attr('value')+'"/>');
				$('#'+id).attr({status:"complete"});
				change_status(id , "complete_message", "Failed to assign message status" ,old_html, old_status,true);
			}
		}
	}

	function change_status(id, callurl, errormessage ,reverthtml,revertstatus, alerts){//change status helper
		var db_id = $('#'+id).attr('db_id');
		if(db_id != ''){
			db_id = '/' + db_id;
		}
		$.ajax({
			url : '/inbox/'+callurl+'/'+ id + db_id+'/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val(),
			success: function(data) {
				var data = $.parseJSON(data);
				if(!data.success){
					if(data.error==="already assigned"){
						if(data.complete === 1){
							$('#'+id).html('<img id="'+id+'_img"  src="/images/complete_man.png" alt="Completed by '+data.assigned_to+'" title="Completed by '+data.assigned_to+'"/>');
							$('#'+id).attr({status:"completed_other"});
						}
						else{
							$('#'+id).html('<img id="'+id+'_img"  src="/images/orange_man.png" alt="Assigned to '+data.assigned_to+'" title="Assigned to '+data.assigned_to+'"/>');
							$('#'+id).attr({status:"assigned_other"});
						}
						$('#'+id).attr({db_id:data.id});
						if(alerts){
							alert("Message assigned to " +data.assigned_to);
						}
					}
					else{
						if(alerts && data.error != null){
							alert(errormessage);
						}
					}
				}
				else{
					$('#'+id).attr({db_id:data.id});
				}
			},
			error: function(xhr ){
				if(xhr.status !== 0){
					$('#'+id).html(reverthtml);
					$('#'+id).attr({status:revertstatus});
					if(alerts){
						alert(errormessage);
					}
				}
			}
		});
	}

	///////end status functions

//////////dist list expand functions
function expandAddresses(token, display_names, addresses_in_display_order, field_name) {
	var name_array = display_names.split(';');
	var address_array = addresses_in_display_order.split(';');
	for(var i = 0; i < name_array.length; i++) {
		$('textarea[name="' + field_name + '"]').tokenInput('add',{ name : htmlentities(name_array[i],'ENT_NOQUOTES'), id : address_array[i], uid: uniqid() });
	}
	$('textarea[name="' + field_name + '"]').tokenInput('remove', {id: token});
	closeDistListWindow();
}

function closeDistListWindow() {
	$('.overlay').remove();
	$('.modal').remove();
}

function viewDistList(token_uid, item, field_name) {
	$('.overlay').remove();
	$('.modal').remove();
	var item = JSON.parse(base64_decode(html_entity_decode(item)));
	var token = item.id;
	var dist_list_name = item.name;
	var display_names = item.display_names;
	var addresses_in_display_order = item.addresses_in_display_order;
	var address_tokens = JSON.parse(html_entity_decode(item.address_tokens));
	var address_token_str = '';
	for(var i = 0; i < address_tokens.length; i++) {
		if($("#"+token_uid).attr('data-message') != null && $("#"+token_uid).attr('data-message').length) {
			if($("#"+token_uid).attr('data-message').indexOf(address_tokens[i].split(" ")[0]) != -1) {
				address_token_str += '<span class="hidden_context">Untrusted address</span><span title="Untrusted" style="color: #d00;">' + address_tokens[i] + '</span><br />';
			}
			else {
				address_token_str += '<span class="hidden_context">Trusted address</span><span title="Trusted" style="color: green;">' +address_tokens[i] + '</span><br />';
			}
		}
		else {
			address_token_str += '<span class="hidden_context">Unvalidated address</span>' + address_tokens[i] + "<br />";
		}
	}
	$(document.body).append("<div class=\"overlay\"></div>");
	$(document.body).append(
		"<div id=\"dist_list_expand\" class=\"modal\" style=\"width:600px;\">"
		+ '<a href="#" id="dist_list" class="hidden_context">Distribution list members modal panel</a>'
		+ "<h1>" + dist_list_name + "</h1>"
		+ "<form action=\"/inbox/form_check\" id=\"dist_list_expand_form\" method=\"POST\">"
		+ "<p>All recipients in the distribution list are listed below</p>"
		+ "<label for=\"recepients_in_dist_list\" class=\"hidden_context\">Recipients in the Distribution List</label>"
		+ "<div>" + address_token_str + "</div><br/>"
		+ "<button class=\"minimal\" style=\"padding-left: 5px; padding-right: 5px;\" type=\"button\" name=\"dist_list_expand\" id=\"submit_dist_list_expand\" onclick=\"expandAddresses('"+ token + "','" + display_names + "','" + addresses_in_display_order + "','" + field_name + "');\">Expand</button>&nbsp;&nbsp;"
		+ "<button class=\"minimal\" style=\"padding-left: 5px; padding-right: 5px;\" type=\"button\" name=\"dist_list_expand_cancel\" id=\"dist_list_expand_cancel\" onclick=\"closeDistListWindow();\">Cancel</button>&nbsp;"
		+ "</form>"
		+ "</div>");
	$('#dist_list').focus();
	$('.modal').draggable();

}

//////////end dist list expand functions

function getPersonalAddressBook() {
function _trapFocusFor508(e) {
}

window.__dsm_focus_return_element = $('#personal_contacts_list_link');

$.ajax({
url : '/addressbook/mainContacts/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
}).done(function(data, textStatus, jqXHR){
if(userIsNotAuthorized(jqXHR)) {
	window.location = '/auth/logout';
}
else {
	/* JQuery UI Dialog Replacement of Fancybox for Section 508/A3lly compatibility. */
			// Here, we're going to have to create a container for the returned HTML representing the dialog content,
			// attach it to the document.body, fill it with the returned HTML, and open a dialog that will be filled
			// with the contents.
			var dialogEl = $('#dialog_container');
			if (dialogEl.length < 1) { // Element does not exist.
				dialogEl = $("<div/>").attr("id", "dialog_container").appendTo("body");
			}

			dialogEl.html(data).dialog({
				modal: true,
				title: 'Personal Contacts List',
				width: 750,
				resizable: false,
				draggable: false,
				create: function(event, ui) {
					$('#add_contact_link').focus();
				},
				close: function(event, ui) {
					if (window.__dsm_focus_return_element && window.__dsm_focus_return_element.focus) {
						window.__dsm_focus_return_element.focus();
					} else {
						$('#personal_contacts_list_link').focus();
					}
					window.__dsm_focus_return_element = undefined;
				}
			});
}
});
}

function getGlobalAddressBook() {

var focusReturnElement = document.activeElement;
$.ajax({
url : '/addressbook/mainindex/?'+$('input[type="hidden"].token').attr('id')+'='+$('input[type="hidden"].token').val()
}).done(function(data, textStatus, jqXHR){
if(userIsNotAuthorized(jqXHR)){
	window.location = '/auth/logout';
}
else {
			/* JQuery UI Dialog Replacement of Fancybox for Section 508/A3lly compatibility. */
			// Here, we're going to have to create a container for the returned HTML representing the dialog content,
			// attach it to the document.body, fill it with the returned HTML, and open a dialog that will be filled
			// with the contents.
			var dialogEl = $('#dialog_container');
			if (dialogEl.length < 1) { // Element does not exist.
				dialogEl = $("<div/>").attr("id", "dialog_container").appendTo("body");
			}
			dialogEl.html(data).dialog({
				modal: true,
				title: 'Global Address Book',
				width: 750,
				resizable: false,
				draggable: false,
				create: function(event, ui) {
					$('#address_search_input').focus();
				},
				close: function(event, ui) {
					focusReturnElement.focus();
				}
			});


	$("#address_book_wrapper").parent().scroll(function(){
		$("#result_panel")
			.stop()
			.animate({"marginTop": ($("#address_book_wrapper").parent().scrollTop()) + "px"}, 400);
	});
}
});
}

function getWebservicePermission(mailbox_name, is_group) {

// this is a tweak to get the modal to align correctly
let viewportWidth = window.innerWidth - 20;
let viewportHeight = window.innerHeight - 15;
if (viewportWidth > 675) viewportWidth = 675;
if (viewportHeight > 400) viewportHeight = 400;

let dialogEl = $('#dialog_container');
if (dialogEl.length < 1) {
dialogEl = $("<div/>").attr("id", "dialog_container").appendTo("body");
} else {
dialogEl.empty();
}

let formSourceURL = '';

// setup the dialog
let permissionDataEndpoint = '/registration/get_webservice_permission/'
+ mailbox_name + '/' + is_group + '/?'
+ $('input[type="hidden"].token').attr('id') + '='
+ $('input[type="hidden"].token').val();

$.ajax({
type: "GET",
url : permissionDataEndpoint,
async: false
}).done(function(data) {
console.log(data);
let data_arr = jQuery.parseJSON(data);
formSourceURL = data_arr['permission_url'];
});

dialogEl.dialog({
autoOpen: false,
title: 'API Service Permission Settings',
width: viewportWidth,
height: viewportHeight,
modal: true,
draggable: false,
resizable: false,
position: {
	my: "center",
	at: "center",
	of: window,
	collision: "none"
},
open: function(e, ui) {
	$(this).load(formSourceURL, function(){
		// do i need to set a specific focus here? Not sure yet.
	});
},
buttons: [
	{
		type: 'submit',
		text: 'Submit',
		id: 'dialog-button-submit',
		click: function() {
			let formModal = this;
			let form = $('#form-webservice-permissions');
			let postUrl = form.attr('action');
			$.ajax({
				type: 'get',
				url: postUrl,
				datatype: 'application/json',
				data: form.serialize(),
				success: function(response) {
					$( formModal ).html(response);
					$( formModal ).dialog('option','height','auto');
				},
				error: function(err) {
					console.log('Permissions submission failed: ' + err.message);
				},
				complete: function() {
					$('button#dialog-button-cancel').html('Close');
				}
			});
		}
	},
	{
		text: 'Cancel',
		id: 'dialog-button-cancel',
		click: function() {
			$(this).dialog('close');
		}
	}
],
close: function(event, ui) {
	$('#dialog_container').remove();
},
create: function (event, ui) {
	$(event.target).parent().css('position', 'fixed');
}
});
dialogEl.dialog('open');

return false;
}

function checkBeforeAfterDates(start_date_id, end_date_id, message) {
var startDate = -1;
if($('#' + start_date_id).datepicker('getDate') != null) {
startDate = $('#' + start_date_id).datepicker('getDate').getTime();
}
var endDate = -1;
if($('#' + end_date_id).datepicker('getDate') != null) {
endDate = $('#' + end_date_id).datepicker('getDate').getTime();
}
var dateErrorMessage = document.getElementById('date_error_message');
var filterButton = document.getElementById('filter_button');
if(endDate < startDate && endDate !== -1) {
if(dateErrorMessage.innerHTML.indexOf(message) < 0) {
	dateErrorMessage.innerHTML += message + '<br>';
}
if(dateErrorMessage.innerHTML !== '') {
	$( "#date_error_message" ).fadeIn('slow');
	filterButton.disabled = true;
	filterButton.className = 'minimal_disabled';
}
}
else {
if(dateErrorMessage.innerHTML.indexOf(message) >= 0) {
	dateErrorMessage.innerHTML = dateErrorMessage.innerHTML.replace(message + '<br>', '');
}
if(dateErrorMessage.innerHTML === '') {
	$( "#date_error_message" ).fadeOut('slow');
	filterButton.disabled = false;
	filterButton.className = 'minimal';
}

}
}

function adminSearchContacts(token) {
var search = $('input[name="contact_search_input"]').val();
$.getJSON('/adminpanel/contact_list_search/' + encodeURIComponent(search)+'/?'+token+'=' + $('input[name="'+token+'"]').val(), function(data) {
adminProcessResultContacts(data,search,token);
});
}

function changeShareType() {
if($('#share_type').length) {
if($('#share_type').val() === 'groups') {
	$('div.users_select').css('display','none');
	$('div.groups_select').css('display','block');
}
else if($('#share_type').val() === 'users') {
	$('div.users_select').css('display','block');
	$('div.groups_select').css('display','none');
}
}
}

function printByElementId(elementId) {
var printContent = document.getElementById(elementId);
var windowUrl = 'print_job';
var uniqueName = new Date();
var windowName = 'Print' + uniqueName.getTime();
var printWindow = window.open(windowUrl, windowName, 'left=50000,top=50000,width=0,height=0');
printWindow.document.write(printContent.innerHTML);
printWindow.document.close();
printWindow.focus();
printWindow.print();
printWindow.close();
}


function isJSON(text){
try{$.parseJSON(text);} catch(e){ return false;}
return true;
}

// NOTE: If this logic changes, please update the logic in "fancybox/jquery.fancybox-1.3.4.js" (line number-258)
function userIsNotAuthorized(jqXHR){
return (jqXHR.status === 401 || jqXHR.responseText.indexOf('<!-- AUTH -->') >= 0);
}

function initializeLightboxes() {

function formatTitle(title, currentArray, currentIndex, currentOpts) {
var type = '';
if ( title ) {
	type = title.split('.').pop(); //title is file name
}
downloadText = 'Download File';
if(!type || !type.length) { downloadText = title; }
if($.inArray(type.toLowerCase(), ['jpeg','jpg','gif','png','xml','pdf','doc','docx', 'txt']) == -1) { downloadText = title; }
$('#fancybox-wrap').draggable();
id = $('input[name="msg_id"]');

downloadURI = '/inbox/compose/draft/attachments/download';
if(id && id.length && $.isNumeric(id.val())){
	downloadURI = '/inbox/message/' + id.val() + '/attachments/download';
}

if($('.patient-document-attachment[title="'+title+'"]').length) { //if this is a patient document attachment
	downloadURI += '/format/pdf';
	downloadText = 'Download as PDF';
}

if($('.archived-attachment[title="'+title+'"]').length) {
	var zip_index = $('.archived-attachment[title="'+title+'"]').attr('data-zip-index');
	var zip_name = $('.archived-attachment[title="'+title+'"]').attr('data-zip-name');
	downloadURI += '/' + rawurlencode(zip_name) + '/' + rawurlencode(zip_index);
}
else { downloadURI += '/' + rawurlencode(title); }

return '<table id="fancybox-title-float-wrap" cellpadding="0" cellspacing="0"><tbody><tr><td id="fancybox-title-float-left"></td><td id="fancybox-title-float-main"><a class="title_link" href="' + downloadURI + '" target="_blank" style="target-new: tab;">' + downloadText + '</a></td><td id="fancybox-title-float-right"></td></tr></tbody></table>';

}

var options = {
title: 'Download File',
height: $(window).height() * 0.8,
width: $(window).width() * 0.85,
close: function(){dialogEl.empty();},
autoOpen: false,
closeOnEscape: false,
draggable: false,
modal: true,
resizable: false,
create: function( event, ui ){console.log('I am a dialog now');}
};
$.each($('a.image-attachment'), function(i, val) {
console.log('non-iframe title is ' + $(val).attr('title'));
options.title = formatTitle('This is a file');
$(val).dialog(options);
});
$.each($('a.iframe'), function(i, val) {
console.log('iframe title is ' + $(val).attr('title'));
options.title = 'This is a file';
$(val).dialog(options);
});
}

function cloneFormRow(rowToClone){
	(event.preventDefault) ? event.preventDefault() : event.returnValue = false;
	var newRow = rowToClone.clone();
	var patientNumber = rowToClone.closest('table').find('tr').length;
	newRow.find(':text').val('');
	newRow.find('.has-error').removeClass('has-error');
	newRow.find('th:first').text(patientNumber);
	newRow.find('[name]').each(function(){
		$(this).attr('name', $(this).attr('name').replace(/patient-\d*/g, 'patient-' + patientNumber));
	});
	newRow.find('label[title]').each(function(){
		$(this).text($(this).text().replace(/Patient #\d*/g, 'Patient #' + patientNumber));
	});
	newRow.find('label[title]').each(function(){
		$(this).attr('title', $(this).attr('title').replace(/Patient #\d*/g, 'Patient #' + patientNumber));
	});
	rowToClone.after(newRow);
	rowToClone.find('a.btn').remove();
	console.log('Setting up the autotabbing');
	newRow.find('input#area_number').autotab({
		format: 'numeric',
		target: newRow.find('input#group_number')
	});
	newRow.find('input#group_number').autotab({
		format: 'numeric',
		target: newRow.find('input#serial_number'),
		previous: newRow.find('input#area_number')
	});
	newRow.find('input#serial_number').autotab({
		format: 'numeric',
		previous: newRow.find('input#group_number')
	});
}

function toggleFolderTree(toggleImage) {
var parentFolderId = toggleImage.attr('id').replace('toggle_image_', '');
var child_folders = document.getElementsByName(parentFolderId);


var message_panel_width = '98%';
if(toggleImage.attr('src').indexOf('caret-right') >= 0) {
for(var i = 0; i < child_folders.length; i++){
	$('#' + child_folders[i].id).show(400);
}
$('#' + toggleImage.attr('id')).attr('src', '/images/caret-bottom.png');
$('#' + toggleImage.attr('id')).attr('alt', 'Collapse Tree Icon');
$('#ul_' + parentFolderId).show(400, function() {
	if (deepestOpenFolderLevel() === 1 ){
		message_panel_width = '94%';
	}else if (deepestOpenFolderLevel() >= 2){
		message_panel_width = '91%';
	}
	$('#message_panel').animate({
		'width' : message_panel_width, //moves screen based on deepest open folder
		'marginLeft': (((deepestOpenFolderLevel()) * 35)) + "px"
	});
	$("#mailbox_panel").animate({
		'width' : (((deepestOpenFolderLevel()) * 35) + 150) + "px"
	});
});
}
else {
for(var i = 0; i < child_folders.length; i++){
	$('#' + child_folders[i].id).hide(400, function() {

		if (deepestOpenFolderLevel() === 1 ){
			message_panel_width = '94%';
		}else if (deepestOpenFolderLevel() >= 2){
			message_panel_width = '91%';
		}else if (deepestOpenFolderLevel() === 0){
			message_panel_width = '98%';
		}
		$('#message_panel').animate({
			'marginLeft' :  ((deepestOpenFolderLevel()) * 35) + "px",  //moves screen based on deepest open folder
			'width' : message_panel_width //moves screen based on deepest open folder
		});
		$("#mailbox_panel").animate({
			'width' : (((deepestOpenFolderLevel()) * 35) + 150) + "px"
		});
	});
}
$('#' + toggleImage.attr('id')).attr('src', '/images/caret-right.png');
$('#' + toggleImage.attr('id')).attr('alt', 'Expand Tree Icon');
$('#ul_' + parentFolderId).hide(400, function() {

	if (deepestOpenFolderLevel() == 1 ){
			message_panel_width = '94%';
	}else if (deepestOpenFolderLevel() >= 2){
			message_panel_width = '91%';
	}else if (deepestOpenFolderLevel() == 0){
			message_panel_width = '98%';
	}
	$('#message_panel').animate({
		'marginLeft' :  ((deepestOpenFolderLevel()) * 35) + "px", //moves screen based on deepest open folder
		'width' : message_panel_width
	});
	 $("#mailbox_panel").animate({
		'width' : (((deepestOpenFolderLevel()) * 35) + 150) + "px"
	});

});
}
}

//used to be all by itself in helper.js - moved here to reduce number of requests needed when loading page - MG 2016-08-11
function nl2br(str, is_xhtml) {
var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br />' : '<br>';
return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1'+ breakTag +'$2');
}

// function to use the noty.js mechanisms to display, alerts, status or error messages to the user - BH 2015-05-06
function notyErrorNotification(message, displayInSeconds){
if(!$.isNumeric(timeout) || timeout < 1)
displayInSeconds = 5000;

var nth = noty({
text: message,
type: 'error',
timeout: displayInSeconds
});

}

//declaration of Folder object - note that this will only work on pages that use the Inbox template
function Folder(id){
var self = this;
this.id = id;
this.name = $('#folder_' + this.id).children('.custom_folder_name').html();
this.nameWithMessageCount = $('#anchor_' + this.id).html();
this.depth = $('#folder_' + this.id).attr('data-depth');

this.indentedName = function(){
return Array( (3*this.depth) + 1).join('\u00A0') + this.name;
}


this.rename = function(){
console.log('Runninf rename on folder id ' + this.id);
var csrfToken = {};
csrfToken[$('input[type="hidden"].token').attr('id')] = $('input[type="hidden"].token').val();

$('#folder_' + this.id).children('.custom_folder_name').css('display','inline');
$('#anchor_'+ this.id).css('display','none');
$('#folder_' + this.id).children('.custom_folder_name').editable('/inbox/rename_folder/'+ this.id,{
	event : 'rename_event',
	height: 12,
	width: 100,
	submitdata: csrfToken,
	style : 'position: relative; float: right; z-index: 100;',
	onblur : 'submit',
	indicator : 'Saving...',
	callback: function(json, settings) {
		if(!isJSON(json)){
			self.showRenameError('An error occurred and the folder was not renamed.  Please try again in a moment, and contact an administrator if the problem persists.');
		}else{
			json = $.parseJSON(json);
			if(json.hasOwnProperty('error')){
				self.showRenameError(json.error);
			}else{
				self.showRenameSuccess(json);
			}
		}

		$('#folder_' + id).children('.custom_folder_name').css('display', 'none');
		//$(this).unbind(settings.event);
		$(this).off(settings.event);
		$('#anchor_' + id).blur();
	}
});
$('#folder_' + this.id).children('.custom_folder_name').trigger('rename_event');
}

this.showRenameError = function(message) {
$('#folder_' + this.id).children('.custom_folder_name').html(this.name);
$('#anchor_' + this.id).html(this.nameWithMessageCount);
$('#anchor_' + this.id).css('display', 'block');
noty({text: message, type: 'error',	timeout: 10000});
};

this.showRenameSuccess = function(newValues){
$('#anchor_' + this.id).attr('title', newValues.name_with_message_count);
$('#anchor_' + this.id).html(newValues.name_with_message_count);
$('#old_value_' + this.id).val(newValues.name);
$('#folder_' + this.id + ' .name-for-display').html(newValues.name);
$('#accessible-menu-' + this.id + ' .name-for-display').html(newValues.name);
$('#folder_' + this.id + ' .custom-folder-hash').attr('id', newValues.hashed_name);
$('#anchor_' + this.id).css('display', 'block');
self.updateMessageMoveDropdown();
self.updateAdvancedSearchDropdown();
};

this.updateAdvancedSearchDropdown = function(){
//remove custom folders from the current dropdown
$('#folder_search_select option').each(function(){
	if($(this).val().indexOf('_') >= 0)
		$(this).remove();
});

//repopulate current folders based on changes
$('.custom_folder_tree .custom-folder').each(function(){
	var folder = new Folder($(this).attr('data-id'));
	$('#folder_search_select').append($('<option/>', {value: folder.id + '_' + folder.name, text: folder.indentedName()}));
});
}

this.updateMessageMoveDropdown = function(){
//remove custom folders from the current dropdown
$('#move_select option').each(function(){
	if($.isNumeric($(this).val()))
		$(this).remove();
});

//repopulate current folders based on changes
$('.custom_folder_tree .custom-folder').each(function(){
	var folder = new Folder($(this).attr('data-id'));
	$('#move_select').append($('<option/>', {value: folder.id, text: folder.indentedName()}));
});
}


};

/**
 * Rename a folder
 * @param folder_id
 * @returns {boolean}
 */
function renameFolder(folder_id) {

	window.__dsm_focus_return_element = document.activeElement;


	let dialogEl = $('#dialog_container');
	if (dialogEl.length < 1) {
		dialogEl = $("<div/>").attr("id", "dialog_container").appendTo("body");
	} else {
		dialogEl.empty();
	}

	// setup the dialog
	let formSourceURL = '/inbox/rename_folder_form/' + folder_id;

	dialogEl.dialog({
		autoOpen: false,
		title: 'Rename Folder',
		width: 500,
		height: 250,
		modal: true,
		draggable: true,
		resizable: false,
		position: {
			my: "center",
			at: "center",
			of: window,
			collision: "none"
		},
		open: function(e, ui) {
			// load the form html
			$(this).load(formSourceURL, function(){
				// set the focus to the first form input element
				$('#folder-name-field').focus();
				$('#folder-name-field').on( "keypress", function(e) {
					if ( e.keyCode == 13 ) {
						e.preventDefault;
						$( '#rename_submit_btn' ).click();
					}
				});
			});
		},
		buttons: [
			{
				text: 'Submit',
				id: 'rename_submit_btn',
				click: function() {

					let form = $('#form-dialog-container').find('form');
					let postUrl = form.attr('action');

					// add the background overlay and progess spinner
					$('.overlay').remove();
					$(document.body).append("<div class=\"overlay\"></div>");
					$('#pros_modal').css('display','block');

					$.post({
						url: postUrl,
						type: 'post',
						datatype: 'application/json',
						data: form.serialize(),
						success: function() {
							window.location.reload();
						},
						error: function(err) {
							console.log('Folder renaming failed: ' + err.message);
						}
					});
				},
				type: 'submit'
			},
			{
				text: 'Cancel',
				id: 'rename_cancel_btn',
				click: function() {
					$( this ).dialog( 'close' );
				}
			}
		],
		close: function() {
			$('.overlay').remove();
			$( '#dialog_container' ).remove();
		},
		create: function (event) {
			$(event.target).parent().css('position', 'fixed');
		}
	});
	dialogEl.dialog('open');

	return false;
}
