
//define namespaces for this file
var dpii = dpii || {}; //define a namespace for our js
var $ = $ || console.error('Jquery is required for this script');

//////////////////////////////////////////////////////////////////
// DEALING WITH ONE FILE
// For dealing with more than file at once, see dpii.compose.files
//////////////////////////////////////////////////////////////////

dpii.compose.patientauth = (function() {
	"use strict";

	return {

            _init : function(){
                this.set_initial_state();

                $('#non_va_referral_no').on('click', function(){
                    dpii.compose.patientauth.show_7332_data();
                });

                $('#non_va_referral_yes').on('click', function(){
                     dpii.compose.patientauth.hide_7332_data();
                     dpii.compose.patientauth.hide_7332_auth();
                });

                $('#7332_data_yes').on('click', function(){
                    dpii.compose.patientauth.show_7332_auth();
                    removeErrorMessage($('#7332_data_question'),'7332');
                });

                $('#7332_data_no').on('click', function(){
                        dpii.compose.patientauth.hide_7332_auth();
                        removeErrorMessage($('#7332_auth_question'),'7332');
                        removeErrorMessage($('#7332_data_question'),'7332');
                });

                $('#7332_auth_no').on('click', function(){
                        setErrorMessage("Your message cannot be sent without proper authorization.",$('#7332_auth_question'),'7332');
                        $('#StatusUpdater').html("Your message cannot be sent without proper authorization.");
                });

                $('#7332_auth_yes').on('click', function(){
                        removeErrorMessage($('#7332_auth_question'),'7332');
                });

                $('#non_va_referral_qtip').qtip({
                    content: {
                        text: "1. (H)(i) VHA may disclose any protected health information, including Title 38 USC protected information, to all Non-VA Care (Choice, PC3, etc.) Providers where VA refers or authorizes the Veteran to receive Non-VA care or a VA provider refers the Veteran for outside care to a private provider even though VA is not paying for that care. Referral of care can be for specialty care, home health, hospice, nursing home or assisted living. With the passage of the law it will no longer be required to review the health record for any 38 USC 7332-protected conditions in order to obtain a signed, written authorization from the Veteran before sending information to the Non-VA Care Provider or private provider. This recent change is just for referral of care. ",
                        title: {
                            text: "From the VA Privacy Fact Sheet about Public Law No. 115-26 (AKA S544) Changes to Title 38 USC 7332:"
                        }
                    }
                });

                $('#section_7332').qtip({
                        content: $('#section_7332').attr('alt')
                });


                //todo - this should probably go into some sort of protectedData module
                $('[name=7332_data]').on('keydown', function(event) {
                        var code = (event.keyCode ? event.keyCode : event.which);
                        if(code == 9) { //tab keycode
                                if(!event.shiftKey && $('#7332_auth_question:visible').length === 0) {
                                        if(event.preventDefault) event.preventDefault(); else event.returnValue = false;
                                        if($('#tinyeditorframe').css('display') === "none"){
                                                $('#message_body').focus();
                                        }
                                        else{
                                                $('#tinyeditorframe').contents().find('html').focus(); //this works in Firefox
                                                $('#tinyeditorframe').contents().find('body').focus(); //if previous line does not focus, then this will
                                        }
                                }
                        }
                });

                //todo - this should probably go into some sort of protectedData module
                $('[name=7332_auth]').on('keydown', function(event) {
                        var code = (event.keyCode ? event.keyCode : event.which);
                        if(code == 9) { //tab keycode
                                if(!event.shiftKey) {
                                        if(event.preventDefault) event.preventDefault(); else event.returnValue = false;
                                        if($('#tinyeditorframe').css('display') === "none"){
                                                $('#message_body').focus();
                                        }
                                        else{
                                                $('#tinyeditorframe').contents().find('html').focus(); //this works in Firefox
                                                $('#tinyeditorframe').contents().find('body').focus(); //if previous line does not focus, then this will
                                        }
                                }
                        }
                });
            },
            set_initial_state: function() {
                 if (this.is_checked('non_va_referral_no')) {
                    this.show_7332_data();
                 }

                if(this.is_checked('7332_data_yes')
                         && this.is_checked('non_va_referral_no')){ //load saved data
                        this.show_7332_auth();
                }

            },

            show_7332_data: function () {
                $('#7332_data_question').show();
            },
            hide_7332_data: function () {
                dpii.compose.patientauth.uncheck($('#7332_data_no'));
                dpii.compose.patientauth.uncheck($('#7332_data_yes'));
                $('#7332_data_question').hide();
            },
            show_7332_auth: function () {
                $('#7332_auth_question').show();
            },
            hide_7332_auth: function () {
                dpii.compose.patientauth.uncheck($('#7332_auth_no'));
                dpii.compose.patientauth.uncheck($('#7332_auth_yes'));
                $('#7332_auth_question').hide();
            },
            uncheck: function(checkbox) {
                checkbox.prop('checked', false);
                checkbox.attr('checked', false);
            },
            is_checked: function(elem_name) {
                return $('#'+elem_name).is(':checked');
            },
            is_answered: function(elem_name) {
                var no_element = elem_name + '_no';
                var yes_element = elem_name + '_yes';

                if (this.is_checked(no_element)) {
                     return true;
                }

                if (this.is_checked(yes_element)) {
                     return true;
                }

                 return false;
            },
            get_validation_message: function () {
                var message = '';

                // do not validate patient authorization if the message is saved
                if ($('#save_btn').attr('clicked') === 'true') {
                     return message;
                }

                var msg_non_va_referral =  'Please specify whether this message is for non-VA care as a result of a referral';
                var msg_7332_data = 'Please specify whether this message contains 7332 protected data.';
                var msg_7332_auth = 'Please specify if there is a VA Form 10-5345 signed by the Veteran';
                var no_auth = 'You need patient authorization to send this message.';

                if (this.is_answered('non_va_referral') === false) {
                        dpii.compose.feedback.setValidation($('#non_va_referral_question'), msg_non_va_referral);
                        message = msg_non_va_referral;
                } else if (this.is_checked('non_va_referral_no') === true
                        && this.is_answered('7332_data') === false) {
                        dpii.compose.feedback.setValidation( $('#7332_data_question'), msg_7332_data);
                        message = msg_7332_data;
                } else if (this.is_checked('non_va_referral_no') === true
                        && this.is_checked('7332_data_yes') === true
                        && this.is_answered('7332_auth') === false) {
                        dpii.compose.feedback.setValidation($('#7332_auth_question'), msg_7332_auth);
                        message = msg_7332_auth;
                } else if (this.is_checked('non_va_referral_no') === true
                        && this.is_checked('7332_data_yes') === true
                        && this.is_checked('7332_auth_no') === true) {
                        dpii.compose.feedback.setValidation($('#7332_auth_question'), no_auth);
                        message = no_auth;
                }
                // appeand a space to message if not empty
                if (message.length !== 0) {
                    message += ' ';
                }
                return message;
            }
        };
})();

