

	"use strict";

//define namespaces for this file
var dpii = dpii || {}; //define a namespace for our js
var $ = $ || console.error('Jquery is required for this script');

//////////////////////////////////////////////////////////////////
// DEALING WITH ONE FILE
// For dealing with more than file at once, see dpii.compose.files
//////////////////////////////////////////////////////////////////

dpii.compose.file = {};

//represents a single file (either attachent or file transfer) during the upload process
dpii.compose.file.Upload = function(startedAt){	var element;
	var type;
	var name;
	var size;

	var validationMessages = [];

	var errorMessageGeneric = function(){
		return 'This file could not be uploaded. Please try uploading ' + name + ' again in a moment, and contact an administrator if the problem persists.';
	};

	var errorMessageSize = function(){
		var message = 'The '+ name + ' file could not be uploaded. ';
		if(type == 'file-transfer')
			message += 'File transfers may not be larger than ' + dpii.compose.fileTransfers.maxSizeForDisplay() + ' when uploaded from the Compose page.  To upload larger files, please use the File Transfer Upload form in API Admin.';
		else
			message += 'Adding it would exceed the '+dpii.compose.attachments.maxSizeForDisplay()+' size limit for attachments.';
		return message;
	};

	var errorMessageValidation = function(){
		var message = '';
		validationMessages.forEach(function(validationMessage){
			message += ' ' + validationMessage;
		});
		return message;
	};

	var isPending = function(){
		return ($('.file-list li[data-started-at="' + startedAt + '"].uploading').length > 0);
	};

	var isValid =  function(){
		var maxSize = dpii.compose.attachments.maxSize();
		var nameMaxLength = dpii.compose.attachments.maxNameLength();
        var currentSize = dpii.compose.attachments.size();
		if(type == 'file-transfer'){
			maxSize = dpii.compose.fileTransfers.maxSize();
			nameMaxLength = dpii.compose.fileTransfers.maxNameLength();
		}

        if((currentSize + size) > maxSize) {
        	validationMessages.push(errorMessageSize());
        }

		if(name.length > nameMaxLength) {
            validationMessages.push('The name of the file may not exceed ' + nameMaxLength + ' characters.');
        }

		return validationMessages.length === 0;
	};

	var progressInterval = null;

	var section = function(){
		return type + 's';
	};

	var showComplete = function(file){
		file = $.parseJSON(file);
		console.log(file);
		element.replaceWith(file.markup);

		$(file.markup).find('a:first').focus();
		if($(file.markup).find('a:first').hasClass('lightbox')){
			initializeLightboxes();
		}

		dpii.compose.csrf.update(file.token);
		dpii.compose.changes.mark();
		dpii.compose.files.refreshUI();
		dpii.compose.menu.enableSend();
	};

	var showPending = function(){
		if(!isPending()){
			$('.'+ section()).css('display', 'block');
			$('.file-list .'+ type +'.uploading').last().before(element);
			dpii.compose.files.refreshUI(section());
			dpii.compose.menu.disableSend();
		}
	};

	var setProgress = function(percent){
		var progressBar = $(element).find('.progress-bar').first();
		$(progressBar).css('width', percent + '%');
		$(progressBar).attr('aria-valuenow', percent);
		$(progressBar).text(percent + '%');
	};

	var humanDateTime = function(){
		var currentdate = new Date();
		var datetime = "Now: "  + currentdate.getDate() + "/"
								+ (currentdate.getMonth()+1)  + "/"
								+ currentdate.getFullYear() + " @ "
								+ currentdate.getHours() + ":"
								+ currentdate.getMinutes() + ":"
								+ currentdate.getSeconds();
		return datetime;
	};

	var ajaxFormSettings = function(){

		//make sure that we have a message id before proceeding
		if(!dpii.compose.hasMessageId()){
			showPending();
			$.when(dpii.compose.save.run({'forceSave': true, 'async': false})).done(function(data){
				return this.ajaxFormSettings();
			}.bind(this));
		}

		return {

			dataType: 'text',

			beforeSend: function(xhr){
				showPending();
				var messageID = dpii.compose.messageId();

				if(!dpii.compose.hasMessageId()){
					element.remove();
					dpii.compose.feedback.error('There is a problem with this draft that needs to be corrected before attaching a file.  Please save the draft and try again.');
					return false;
				}
			}.bind(this),

			uploadProgress: function(e, pos, total, percent) {
				//this percent only shows the length of time needed to upload the file to $_FILES
				//for attachments, it'll take a little bit longer for the system to write the file to the cache and return a JSON response
				//for file transfers, it'll take a ton longer to send the file to the API and write the file to the db
				var maxProgress = 98;

				if(type == 'file-transfer'){
					var numberOfIncrements = (total / (1024000 * 32)); //we save to the db in chunks of 32MB
					percent = Math.floor(percent * 0.1);

					//after the upload to $_FILES is complete, make the best guess at progress that we can
					if(pos == total){
						progressInterval = setInterval(function(){
							if(percent < maxProgress){
								percent++;
								setProgress(percent);
							}

						}, 1000 * numberOfIncrements);
					}
				}

				if(percent > maxProgress)
					percent = maxProgress;

				setProgress(percent);
			},

			success: function(data,status,xhr) {
				if(xhr.status > 0 && isJSON(data) && data.length > 0) {
					showComplete(data);
				}else{
					element.remove();
					dpii.compose.feedback.error(errorMessageGeneric());
				}
			}.bind(this),

			error: function(xhr) {
				element.remove();
				if(xhr.status == 413) {
					dpii.compose.feedback.error(errorMessageSize());
				}else {
					dpii.compose.feedback.error(errorMessageGeneric());
				}
			}.bind(this),

			complete: function(xhr) {
				clearInterval(progressInterval);
				dpii.compose.files.refreshUI();
				$('input#attach').focus();
				$('#attach').replaceWith($('#attach').val(null).clone(true));

				dpii.compose.menu.enableSend();
			}.bind(this)
		};
	}; //end ajaxFormSettings

	var _init = function(){

		if($.isNumeric(startedAt)){
			element = $('.file-list li[data-started-at="' + startedAt + '"].uploading');

		}else{
			startedAt = $.now();

			//set up the html for this element
			var file = $('#attach').get(0).files[0];
			//type = (dpii.compose.fileTransfers.enabled() && file.size > dpii.compose.attachments.maxSize()) ? 'file-transfer' : 'attachment';
			type = 'attachment';
			element = $('.file-list .'+ type +'.uploading').last().clone();
			$(element).data('name', file.name).data('size', file.size).data('started-at', startedAt).css('display', 'block');
			$(element).find('.file-name').html(' ' + file.name + '&hellip;');
		}

		name = element.data('name');
		size = element.data('size');
		type = 'attachment';
		if(element.hasClass('file-transfer'))
				type = 'file-transfer';
	};

	_init();

	return {
		element: element,
		errorMessageValidation: errorMessageValidation,
		isValid: isValid,
		ajaxFormSettings: ajaxFormSettings,
	}; //end Upload return
}; //end Upload



///////////////////////////////////////////////////////////////////
// FILES
// Anything that relates to both files transfers and attachments
///////////////////////////////////////////////////////////////////
dpii.compose.files = (function() {

	var sections = ['attachments', 'file-transfers'];

	return {

		adjustInputTrigger: function(){
			var totalFiles = this.count();
			if(totalFiles > 0 &&  $('.file-input-trigger').text() !== 'Attach another file');
				$('.file-input-trigger').text('Attach another file');
			if(totalFiles === 0 &&  $('.file-input-trigger').text() !== 'Attach a file');
				$('.file-input-trigger').text('Attach a file');

			$('input#attach').css({'top':$('tr#attach_row').position().top, 'left':$('tr#attach_row').position().left + $('#attach_row td').first().outerWidth(true)});
		},

		count: function(section){
			section = this.section(section);
			if(typeof section !== 'string')
				return $.map(sections, this.count.bind(this)).reduce(function(a, b){ return a + b; }); //total file count for entire compose page

			return $('ul.'+section+' li').length - 1; //minus one because we keep a hidden template for uploads
		},

		maxNameLength: function(){
			return 260;
		},

		maxSize: function(){
			return $('section.'+this.section()).data('max-size');
		},

		maxSizeForDisplay: function (){
			return $('section.'+this.section()).data('max-size-human');
		},

		maxSizeInMB: function (){
			return $('section.'+this.section()).data('max-size-in-mb');
		},

		refreshUI: function(section){
			section = this.section(section);
			if(typeof section !== 'string')
				return $.map(sections, this.refreshUI.bind(this));

			var fileCount = this.count(section);

			//check to make sure that the ui is displaying things correctly based on this count
			if(fileCount < 1)
				$('section.'+section).hide();
			else if(fileCount > 0 )
				$('section.'+section).show();
			if($('section.'+ section +' h3 .count').text() !== '('+ fileCount +')')
				$('section.'+ section +' h3 .count').text('('+ fileCount +')');

			dpii.compose.files.adjustInputTrigger();
		},

		remove: function(li){
			$.ajax({
				url: this.urlForRemove(li),
				success: function data(){
					$(li).remove();
					dpii.compose.changes.mark();
					this.refreshUI(this.section());
					//we used to do this, but it's forcing the screen to go back to the top of the page after a removal, so seems undesirable.
					//leaving it commented out for now in case someone has a reason why we were doing this - 508 compliance?
					//$('input#attach').focus();
					//dpii.compose.feedback.success('The ' + $(li).data('name') + ' ' + this.type + ' has been removed');
				//}.bind(this),
				}.bind(this),
				error: function(xhr) {
					dpii.compose.feedback.error('The ' + $(li).data('name') + ' file could not be removed.  Please try again in a moment, and contact an administrator if the problem persists.');
				},
			});
		},

		section: function(value){
			if(typeof value === 'string'){

				return value;
			}
			if(typeof this.type === 'string') return this.type + 's';
		},

		setType: function(value){
			if(sections.indexOf(value + 's') < 0){
				console.error(value + ' is not a valid value for dpii.compose.files.type');
				return false;
			}

			this.type = value;
			return true;
		},

		size: function(section){
			if(typeof section !== 'string')
				return $.map(sections, this.size.bind(this)).reduce(function(a, b){ return a + b; }); //total size for entire compose page

			var size = 0;

			$('.'+ section + ' a.delete').each(function() {
			   size += Number($(this).data('size'));
			});

			return size;
		},

		type: null, //extend in child classes

		_init: function(){

			$('.file-input-trigger').click(function(e) {
                            // RDF - Removed the next two statements. The design relied too much on positioning the hidden form. //
                           //$('input#attach').focus();
                           // $('input#attach').click(); //backup in case the file input isn't positioned over the Add Attachment link correctly
                            e.stopPropagation();
			});

			$('input#attach').change(function(e) {
				e.stopImmediatePropagation();
				//performing this if check because IE11 fires this ajaxform submission twice somehow.
				//the extra one has null value for the file path
				if($('#attach').val()){
					var fileUpload = new dpii.compose.file.Upload();
					if(!fileUpload.isValid()){
						dpii.compose.feedback.error(fileUpload.errorMessageValidation());
						return false;
					}else{
						$('#attachment_form').ajaxForm(fileUpload.ajaxFormSettings()).submit();
						$('#attach').val(null);
					}

				}
			});

			$('input#attach').keydown(function(event) {
				var code = (event.keyCode ? event.keyCode : event.which);
				if(code == 9) { //tab keycode
					if(event.preventDefault) event.preventDefault(); else event.returnValue = false;
					if(event.shiftKey) {
						$('#priority').focus();
					}else {
						$('#document_attach_link').focus();
					}
				}
			});



		},
	};
})();


///////////////////////////////////////////////
// ATTACHMENTS
// Extends files for attachments-only behavior
////////////////////////////////////////////////

dpii.compose.attachments = $.extend(true, {}, dpii.compose.files, (function() {
	"use strict";

	return {

		maxNameLength: function(){
			return 160;
		},

		showPatientLookupForm: function(){

			// nested private function so that we can make sure we wait until autosave executes if necessary
			function _showPatientLookupForm(){

				// this is a tweak to get the modal to align correctly
				let viewportWidth = window.innerWidth - 20;
				let viewportHeight = window.innerHeight - 15;
				if (viewportWidth > 800) viewportWidth = 800;
				if (viewportHeight > 550) viewportHeight = 550;

				let formModal = $('#dialog_container');
				if (formModal.length >= 1) {
					formModal.remove();
				}
				formModal = $("<div/>").attr("id", 'dialog_container').appendTo("body");

				let formModalSource = '/inbox/compose/draft/' + dpii.compose.messageId() + '/attach/patient_document' + dpii.compose.csrf.queryString();

				formModal.dialog({
					autoOpen: false,
					title: 'Attach a VA Continuity of Care Document',
					modal: true,
					width: viewportWidth,
					height: viewportHeight,
					resizable: false,
					draggable: true,
					position: {
						my: "center",
						at: "center",
						of: window,
						collision: "none"
					},
					open: function(event, ui) {
						$(this).load(formModalSource, function() {
							$('#given-name-field').focus();
							console.log("Autotab setup from dpii.compose.files");
							// SSN Field Ids: area_number, group_number, serial_number
							$('#area_number').autotab({format: 'numeric', target: '#group_number'});
							$('#group_number').autotab({format: 'numeric', target: '#serial_number', previous: '#area_number'});
							$('#serial_number').autotab({format: 'numeric', previous: '#group_number'});
						});
					},
					buttons: [
						{
							text: 'Find Matching Patients',
							type: 'submit',
							click: function() {
								$('.overlay').remove();
								$(document.body).append("<div class=\"overlay\"></div>");
								$('#pros_modal').css('display','block');
								// submit the form
								let formModalRef = this;
								let form = $('#form-dialog-container').find('form');
								let postUrl = form.attr('action');
								$.ajax({
									url: postUrl,
									type: 'post',
									datatype: 'application/json',
									data: form.serialize(),
									success: function(data) {
										$.when(
											$( formModalRef ).html(data)
										).done(function(formModalRef) {
											$( formModalRef ).dialog('option', 'height','auto');
											if ( $('input[name="patient_id"]').length ) {
												$( formModalRef ).dialog('option', 'buttons',
													[
														{
															text: 'Find and Attach Document',
															type: 'submit',
															click: function () {
																$('.overlay').remove();
																$(document.body).append("<div class=\"overlay\"></div>");
																$('#pros_modal').css('display','block');	
																// submit the form
																let form = $('#form-dialog-container').find('form');
																let postUrl = form.attr('action');
																$.ajax({
																	url: postUrl,
																	type: 'post',
																	datatype: 'application/json',
																	data: form.serialize(),
																	success: function (data) {
																		$(formModalRef).dialog('close');
																		$("#save_btn").click();
																	}
																});
															}
														},
														{
															text: 'Refine Search Terms',
															click: function() {
																_showPatientLookupForm();
															}
														}
													]
												);
											}
											$("#pros_modal").css('display','none');
											$('.overlay').remove();
										});
									},
									error: function(err) {
										console.log('Patient search failed: ' + err.message);
									}
								});
							}
						},
						{
							text: 'Cancel',
							click: function() {
								$( this ).dialog( 'close' );
							}
						}
					],
					close: function(event, ui) {
						$( this ).remove();
						$('#document_attach_link').focus();
					},
					create: function (event, ui) {
						$(event.target).parent().css('position', 'fixed');
					}
				});
				formModal.dialog('open');

				return false;
			}

			if(dpii.compose.hasMessageId()){
				return _showPatientLookupForm();
			}

			$.when(
				dpii.compose.save.run({
					'forceSave': true,
					'async': false
				})
			).done(function(data){
				if(dpii.compose.hasMessageId()) {
					return _showPatientLookupForm();
				}
				dpii.compose.feedback.error(
					'There is a problem with this draft that needs to be corrected before ' +
					'attaching a VA CDD Document.  Please save the draft and try again.'
				);
				return false;
			});

			return false;
		},

		urlForRemove: function(li){
			return '/inbox/clear_attachment/' + $(li).data('name') + this.parent.csrf.queryString();
		},

		_init: function(){
			$('#attach-patient-document').click(function(e) {
				return this.showPatientLookupForm();
			}.bind(this));
		},
	};

})());
dpii.compose.attachments.setType('attachment');



///////////////////////////////////////////////////////////////////
// FILE TRANSFERS
// Extends files for file transfers-only behavior
///////////////////////////////////////////////////////////////////
/*
* file transfers removed. 2/6/2019

dpii.compose.fileTransfers = $.extend(true, {}, dpii.compose.files, (function() {
	"use strict";

	return {

		enabled: function(){
			return ($('.files.file-transfers').length > 0);
		},

		urlForRemove: function(li){
			return '/inbox/compose/draft/' + dpii.compose.messageId() + '/file_transfer/remove/' + $(li).data('id') +  dpii.compose.csrf.queryString();
		},
	};
})());
dpii.compose.fileTransfers.setType('file-transfer');
*/

////////////////////////////////////////////////////////////////////////////////////////////////////////
// INITIALIZATION FUNCTIONS - Things that will be run by document.ready when the page is first loaded
////////////////////////////////////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////
// MENU BUTTONS
// Controls Menu Buttons while attaching files
///////////////////////////////////////////////////////////////////
dpii.compose.menu = {
	disableSend:function() {
	    $('#send_btn').attr('disabled','disabled');
	    $('#send_btn').attr('title', 'Please wait until your files have finished uploading before sending this message.');
	},
	enableSend: function() {
	    $('#send_btn').removeAttr('disabled');
	    $('#send_btn').removeAttr('title');
	},
};

