/* TODO - This file duplicates a lot of code from dpii.compose.js, which is not a good practice at all.  We should refactor this to just make use of the functions from dpii.compose.js.  
          Do not imitate this in future.  -- 2016-08-09 MG
		  Update - Removing attachment and recipient related code (which no pages using this file made use of) removed 90% of this file. Be very cautious about copying and pasting code that you're not using - it's much more difficult to verify that it's not being used and remove it than it is to just not copy it in the first place! - MG 2016-09-06 */
		  
/**
 * 	Initialize Rich Text Editor
 *	define properties of Tiny Editor
 */
function initRichTextEditor(){
	$('textarea.rich-text-editor').each(function(i, el) {
		// Disabling TinyMCE inclusion for the time being.
		/*tinyMCE.init({
			selector: $(el).attr('id'),
			body_id: 'editor',
			branding: false,
			elementpath: false,
			element_format: 'xhtml',
			entity_encoding: 'raw',
			title: 'Message Body Rich Text Editor',
			width: $("#message_body").css('width'),
			height: $("#message_body").css('height'),
			font_formats: 'Verdana, Arial, Georgia, Trebuchet MS',
			menubar: false,
			toolbar: 'code | bold italic underline strikethrough | subscript superscript | orderedlist unorderedlist | outdent indent | ' + 
						'leftalign centeralign rightalign blockjustify | unformat | undo redo n font size style | image hr link unlink | ' +
						'cut copy paste print',
			plugins: 'code'
		}); */
		new TINY.editor.edit('editor',{
			id: $(el).attr('id'),
			title:'Message Body Rich Text Editor',
			width: $(el).css('width'),
			height: $(el).css('height'),
			cssclass:'te',
			controlclass:'tecontrol',
			rowclass:'teheader',
			dividerclass:'tedivider',
			controls: [
				'toggle','|','bold','italic','underline','strikethrough','|','subscript','superscript','|',
			  'orderedlist','unorderedlist','|','outdent','indent','|','leftalign',
			  'centeralign','rightalign','blockjustify','|','unformat','|','undo','redo','n',
			  'font','size','style','|','image','hr','link','unlink','|','cut','copy','paste','print'
			],
			footer:true,
			fonts:['Verdana','Arial','Georgia','Trebuchet MS'],
			xhtml:true,
			cssfile:'/css/tinyeditor.css',
			bodyid:'editor',
			footerclass:'tefooter',
			toggle:{text:'source',activetext:'wysiwyg',cssclass:'toggle'},
			resize:{cssclass:'resize'},
			entity_encoding : "raw"
		});
		$(el).val('');
	});
}

/* JAVASCRIPT ONLY APPILCABLE TO THE COMPOSE PAGE */
var autosaveCheckAttr = 'data-altered-since-save';


function populateBody(){
	if($('#message_body').css('display') == 'none') {
		$('textarea[name="message_body"]').val(editor.getEditorContent());
	}
}


function saveDraft(saveOptions){
	if($('#main_form').attr(autosaveCheckAttr) != 1) return false;

	if(saveDraftInProgress) return false;
	if($('.overlay').length > 0) return false; //when an overlay is on the page, a dialog is open and the user isn't making changes to the draft (and saving the draft may cause problems)
	if($('.form-dialog-container').length > 0) return false; //when the form dialog is open, the user isn't making changes to the draft (and saving may cause problems)

	saveDraftInProgress = true;
	populateBody();

	ajaxSettings = {type: "POST",
					url: "/inbox/ajax_draft_save/",
					data: $("#main_form").serialize(),
					dataType: "html",
					complete: function(jqXHR, status){

						saveDraftInProgress = false;
						$('.autosave').remove();

						if(userIsNotAuthorized(jqXHR)) {
							window.location = '/auth/logout';
							return false;
						}

						if(!isJSON(jqXHR.responseText)){
							return false;
						}

						var parsedResponse = $.parseJSON(jqXHR.responseText);
						var token = parsedResponse['token'];
						$('input[type="hidden"].token').val(token);
						if(status == 'success'){
							var id = parsedResponse['id'];
							if($.isNumeric(id) && id > 1 && Math.floor(id) == id){
								$('input[name="msg_id"]').val(id);
								$('#main_form').attr(autosaveCheckAttr, 0);
							}
						}
					}
				};


	if(jQuery.isPlainObject(saveOptions)){
		if(saveOptions.force_save)
			ajaxSettings.data += '&force_save=true';
		if(saveOptions.async == false)
			ajaxSettings.async = false;
	}

	return $.ajax(ajaxSettings);
}


////////////////////////////////////////////////////////////////////////////////////////////////////////
// INITIALIZATION FUNCTIONS - Things that will be run by document.ready when the page is first loaded
////////////////////////////////////////////////////////////////////////////////////////////////////////


/**
 * Initialize
 */
initRichTextEditor();
