<?PHP
/*
* @package direct-project-innovation-initiative
* @subpackage views
*/

$validation_error_markup = validation_errors();

?><!doctype html>
<html lang="en">
<head>
	<title><?= PORTAL_TITLE_PREFIX.'Patient Context' ?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon" />
	<link rel="icon" href="/favicon.ico" type="image/x-icon" />
	<?= css_link_tag('css/bootstrap-scoped.min.css') ?>
	<style>
		.dsm-widget-outer { margin: 0; }
		.dsm-widget.container-fluid  { padding: 0; border: 1px solid #0f4c7d; font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; font-size: 12px;  background-color: #fff }
		.dsm-widget h1 { margin: 0; font-size: 1.2em; }
		.dsm-widget header, .dsm-widget main, .dsm-widget footer { display: block; padding: 10px; text-align: left; } 
		.dsm-widget header { margin-bottom: 0; background: #0f4c7d url('/images/themes/banners/background_va.png') 0px 0px no-repeat; }
		.dsm-widget header h1 { padding-left: 25px; background-image: url('/images/themes/logos/va_logo.png'); background-size: 16px 16px; background-repeat: no-repeat; color: #fff; }
		.dsm-widget main { margin-top: 1em; margin-bottom: 1em; }
		.dsm-widget main.has-feedback-message { margin-top: 0; margin-bottom: 0; }
		.dsm-widget main.only-feedback-message { text-align: center; }
		.dsm-widget main .feedback { text-align: center; font-style: italic;  }
		.dsm-widget footer { padding-top: 0; text-align: center; }
		.dsm-widget footer.container-fluid {  padding-left: 0 !important; padding-right: 0 !important;  }
		.dsm-widget form .form-group { margin-bottom: 0; }
		.dsm-widget form .form-group .control-label { float: left; padding: 7px 0 0 15px; }
		.dsm-widget .glyphicon { margin-right: 20px; }
		.dsm-widget .patient-name { white-space: nowrap; overflow: hidden; text-overflow: ellipsis; } 		
	</style>
</head>
<body class="dsm-widget-outer bootstrap">
	<div class="dsm-widget container-fluid">
		<header><h1>Send CCDA via Direct Secure Messaging</h1></header>
	<?php if(!empty($feedback_message)): ?>
		<main class="container-fluid only-feedback-message"><?= $feedback_message ?></main>
		<footer><?= link_to(site_url(), 'Full VA Direct Web Portal', array('target' => '_blank', 'class' => 'btn btn-primary')) ?></footer>
	<?php elseif(is_a($patient, 'Patient')): ?>
		<main class="container-fluid <?php if(!empty($validation_error_markup) || !empty($error_message) || !empty($success_message)) echo ' has-feedback-message'; ?>">
			<?php if(!empty($validation_error_markup)): echo $validation_error_markup; ?>
			<?php elseif(!empty($error_message)): echo '<p class="text-danger feedback">'.$error_message.'</p>'; ?>
			<?php elseif(!empty($success_message)): echo '<p class="text-success feedback">'.$success_message.'</p>'; endif; ?>
			<p class="patient-name"><span class="glyphicon glyphicon-paperclip" aria-hidden="true"></span><span class="sr-only">Send </span>CCDA for <?= $patient->full_name() ?></p>
			<?= form_open(current_url(), array('class'=>'form form-horizontal')); ?>
				<div class="form-group ">
					<label for="to-field" class="control-label">To:</label>
					<div class="col-xs-9 col-sm-10 col-md-11">
						<?= form_input(array('type'  => 'email', 'name'  => 'to', 'value' => set_value('to'), 'id' => 'to-field', 'class' => 'form-control', 'required' => 'required')) ?>
					</div>
					<button type="submit" class="btn btn-info">Send</button>
				</div>
			<?= form_close(); ?>
		</main>
		<footer class="container-fluid">
			<div class="btn-group col-xs-12" role="group">
				<?= link_to(site_url('inbox/compose'), 'Compose Message', array('target' => '_blank', 'class' => 'btn btn-primary col-xs-6')) ?>
				<?= link_to(site_url('inbox'), 'Go to Inbox', array('target' => '_blank', 'class' => 'btn btn-primary col-xs-6')) ?>
			</div>
		</footer>
	<?php endif ?>
	</div>
</body>
</html>